/*
 * type1 font (downlodable PostScript font)
 */
#include	"defs.h"
#include	"global.h"
#include	"bifont.h"
#ifdef KPATHSEA
#include	<kpathsea/tex-file.h>
#endif

void
init_t1_fontinfo(fe)
struct font_entry *fe;
{
    struct font_entry *repfe;
    int	mm_markchar();
    void read_t1_fontinfo();

    if ((repfe = dev_get_repfe(biaccinfo(fe)->bf)) == NULL) {
	biinifinfo(fe) = alloc_biinif(biaccinfo(fe)->bf);
	dev_set_repfe(biinifinfo(fe)->bf, fe);
    } else
	biinifinfo(fe) = biinifinfo(repfe);
    fe->fnt_markchar = mm_markchar;
    fe->fnt_readfontinfo = read_t1_fontinfo;
}

void
read_t1_fontinfo(fe)
struct font_entry *fe;
{
    struct biinitfontinfo *bii;
    struct tfmfntinfo *tfmfi;
    char *fn, *filename;
    FILE *fp;
    void read_tfm_finfo();

    bii = biinifinfo(fe);
    tfmfi = NEW(struct tfmfntinfo, "tfmfont info");
    tfmfi->tfm_bf = bii->bf;
    tfmfinfo(fe) = tfmfi;
    read_tfm_finfo(fe);
    dev_tfm_initfe(fe);

    if (dev_get_repfe(bii->bf) == NULL) {
	dev_t1_initfontdict(fe, bii, NULL, NULL);
	return;
    }
    fn = dev_fontpath(tfmfinfo(fe)->tfm_bf);
#ifdef KPATHSEA
    if ((filename = kpsearch_file(fn, fe->n, kpse_type1_format)) == NULL) {
	Warning("Type1 font file %s not found", fn);
	read_null_fontinfo(fe);
	return;
    }
#else
    filename = fn;
#endif
#ifdef DEBUG
    if (Debuguser)
	(void)fprintf(stderr, "Type1font %s (for %s)\n", filename, fe->n);
#endif
    dev_t1_initfontdict(fe, bii, filename, enc_read(bii->bf));
    dev_set_repfe(bii->bf, NULL);
}

struct encr {
    char *er_filename;
    BOOLEAN *er_done;
    struct encr *er_next;
} *encfiles = NULL;

char *
enc_read(bf)
struct bifont *bf;
{
    char *enc, *encname;
    struct encr *er;

    enc = dev_encfile(bf);
#ifdef KPATHSEA
    if (enc != NULL) {
	encname = kpsearch_file(enc, "8a", kpse_tex_ps_header_format);
#ifdef DEBUG
	if (Debuguser)
	    (void)fprintf(stderr, "encoding file %s\n",
			  encname != NULL ? encname : "(null)");
#endif
    } else
	encname = NULL;
#else
    encname = enc;
#endif
    if (encname == NULL)
	return NULL;
    for (er = encfiles; er != NULL; er = er->er_next)
	if (STREQ(encname, er->er_filename))
	    return encname;
    dev_copyfile(encname);
    er = NEW(struct encr, "encr");
    er->er_filename = encname;
    er->er_next = encfiles;
    encfiles = er;
    return encname;
}
