/*
 * avi.h library for AVI file format i/o
 * Copyright (C) 2000 Arne Schirmacher <arne@schirmacher.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _AVI_H
#define _AVI_H 1

#include "frame.h"

#define AVI_INDEX_OF_INDEXES (0x00)
#define AVI_INDEX_OF_CHUNKS (0x01)
#define AVI_INDEX_2FIELD (0x01)

enum { AVI_PAL, AVI_NTSC, AVI_AUDIO_48KHZ, AVI_AUDIO_44KHZ, AVI_AUDIO_32KHZ };

typedef struct
{
        DWORD   dwMicroSecPerFrame;             // frame display rate (or 0L)
        DWORD   dwMaxBytesPerSec;               // max. transfer rate
        DWORD   dwPaddingGranularity;           // pad to multiples of this
        // size; normally 2K.
        DWORD   dwFlags;                        // the ever-present flags
        DWORD   dwTotalFrames;                          // # frames in file
        DWORD   dwInitialFrames;
        DWORD   dwStreams;
        DWORD   dwSuggestedBufferSize;

        DWORD   dwWidth;
        DWORD   dwHeight;

        DWORD   dwReserved[4];
}
MainAVIHeader;

typedef struct
{
        WORD    top, bottom, left, right;
}
RECT;

typedef struct
{
        FOURCC  fccType;
        FOURCC  fccHandler;
        DWORD   dwFlags;                /* Contains AVITF_* flags */
        WORD    wPriority;
        WORD    wLanguage;
        DWORD   dwInitialFrames;
        DWORD   dwScale;
        DWORD   dwRate;                 /* dwRate / dwScale == samples/second */
        DWORD   dwStart;
        DWORD   dwLength;               /* In units above... */
        DWORD   dwSuggestedBufferSize;
        DWORD   dwQuality;
        DWORD   dwSampleSize;
        RECT    rcFrame;
}
AVIStreamHeader;

typedef struct
{
        DWORD   dwDVAAuxSrc;
        DWORD   dwDVAAuxCtl;
        DWORD   dwDVAAuxSrc1;
        DWORD   dwDVAAuxCtl1;
        DWORD   dwDVVAuxSrc;
        DWORD   dwDVVAuxCtl;
        DWORD   dwDVReserved[2];
}
DVINFO;

typedef struct
{
        DWORD   dwSize;
        LONG    biWidth;
        LONG    biHeight;
        WORD    biPlanes;
        WORD    biBitCount;
        DWORD   biCompression;
        DWORD   biSizeImage;
        LONG    biXPelsPerMeter;
        LONG    biYPelsPerMeter;
        DWORD   biClrUsed;
        DWORD   biClrImportant;
}
BITMAPINFOHEADER;

typedef struct
{
        WORD    wFormatTag;
        WORD    nChannels;
        DWORD   nSamplesPerSec;
        DWORD   nAvgBytesPerSec;
        WORD    nBlockAlign;
        WORD    wBitsPerSample;
        //WORD  cbSize;
}
WAVEFORMATEX;

typedef struct
{
        WORD    wLongsPerEntry;
        BYTE    bIndexSubType;
        BYTE    bIndexType;
        DWORD   nEntriesInUse;
        DWORD   dwChunkId;
        DWORD   dwReserved[3];
        struct avisuperindex_entry
        {
                QUADWORD        qwOffset;
                DWORD   dwSize;
                DWORD   dwDuration;
        }
        aIndex[2014];
}
AVISuperIndex;

typedef struct
{
        WORD    wLongsPerEntry;
        BYTE    bIndexSubType;
        BYTE    bIndexType;
        DWORD   nEntriesInUse;
        DWORD   dwChunkId;
        QUADWORD        qwBaseOffset;
        DWORD   dwReserved;
        struct avifieldindex_entry
        {
                DWORD   dwOffset;
                DWORD   dwSize;
        }
        aIndex[4028];
}
AVIStdIndex;

typedef struct
{
        DWORD   dirEntryType;
        DWORD   dirEntryName;
        DWORD   dirEntryLength;
        size_t  dirEntryOffset;
        int     dirEntryWrittenFlag;
        int     dirEntryParentList;
}
AviDirEntry;


class AVIFile : public RIFFFile
{
protected:
        MainAVIHeader   mainHdr;
        AVISuperIndex   indx;
        AVIStdIndex     ix00;
        DWORD   idx1[80000];
        int     idx1_entries;

        int     file_list;
        int     riff_list;
        int     hdrl_list;
        int     avih_chunk;
        int     movi_list;
        int     indx_chunk;
        int     ix00_chunk;
        int     idx1_chunk;
        int     junk_chunk;

public:
        AVIFile();
        AVIFile(char *s);
        virtual ~AVIFile();

        virtual void Init(int format, int sampleFrequency);
        virtual void PrintDirectoryEntryData(RIFFDirEntry entry);
        //        virtual void ReadFrame(void *data, int frameNumber);
        virtual void WriteFrame(const Frame &frame);
        //        virtual void ReadRIFF(void);
        virtual void WriteRIFF(void);
        void FlushIX00Index(void);
        void UpdateIndex(int frame_chunk);
};

class AVI1File : public AVIFile
{
private:
        AVIStreamHeader stream1Hdr;
        DVINFO  dvinfo;
        int     dmlh[62];

        int     strl1_list;
        int     strh1_chunk;
        int     strf1_chunk;
        int     odml_list;
        int     dmlh_chunk;

public:
        AVI1File();
        AVI1File(char *s);
        virtual ~AVI1File();

        virtual void Init(int format, int sampleFrequeny);
        virtual void WriteFrame(const Frame &frame);
        virtual void WriteRIFF(void);
};

class AVI2File : public AVIFile
{
protected:
        AVIStreamHeader         stream1Hdr;
        BITMAPINFOHEADER        bitmapinfo;
        AVIStreamHeader         stream2Hdr;
        WAVEFORMATEX            waveformatex;

        int     strl1_list;
        int     strh1_chunk;
        int     strf1_chunk;
        int     strl2_list;
        int     strh2_chunk;
        int     strf2_chunk;
public:
        AVI2File();
        AVI2File(char *s);
        virtual ~AVI2File();

        virtual void Init(int format, int sampleFrequeny);
        virtual void WriteFrame(const Frame &frame);
        virtual void WriteRIFF(void);
};
#endif


