#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <linux/cdrom.h>

int main (int argc,char *argv[])
{ int fd,i;
  unsigned char book = 0, action = 0, *dev = NULL;
  struct cdrom_generic_command cgc;
  unsigned char buf[0x804];
  char *spec = NULL;

    for (i=1;i<argc;i++)
    {	if (!strncmp (argv[i],"-dvd-rom",7))		book = 0x01;
	else if (!strncmp (argv[i],"-dvd+rw",7))	book = 0x92;
	else if (!strncmp (argv[i],"-inq",4))		book = 0xFF, action = 0x02;
	else if (!strncmp (argv[i],"-media",3))		action = 0x02;
	else if (!strncmp (argv[i],"-unit",3))		action = 0x01;
	else dev=argv[i];
    }

    if (!(dev && book && action))
	fprintf (stderr,"usage: %s [-dvd-rom-spec|-dvd+rw-spec|-inquiry] [-media|-unit] /dev/cdrom\n",argv[0]),
	exit (1);

    if ((fd=open(dev,O_RDONLY)) < 0)
	fprintf (stderr,"unable to open(\"%s\",O_RDONLY): "), perror(NULL),
	exit (1);

    if (book != 0xFF)
    {	memset (&cgc,0,sizeof(cgc));
	cgc.cmd[0] = 0xF9;
	cgc.cmd[1] = action;
	cgc.cmd[2] = book;
	cgc.data_direction = CGC_DATA_NONE;
	if (ioctl (fd,CDROM_SEND_PACKET,&cgc))
	    perror("Unable to VENDOR F9h, examine /var/log/messages"), exit(1);
    }

    if (action == 0x01)
    {	if (book == 0xFF)
	    fprintf (stderr,"No [known] way to query unit settings:-(\n"), exit (1);
	else
	    printf ("The unit was instructed to format DVD%s compliant disks.\n",
			book==0x01?"-ROM":"+RW"), exit(0);
    }

    memset (&cgc,0,sizeof(cgc));
    cgc.cmd[0] = 0xAD;
    cgc.cmd[2] = cgc.cmd[3] = cgc.cmd[4] = cgc.cmd[5] = 0xff;
    cgc.cmd[8] = 0x08; cgc.cmd[9] = 0x04;
    cgc.buffer = buf;
    cgc.buflen = 0x804;
    cgc.data_direction = CGC_DATA_READ;
    if (ioctl (fd,CDROM_SEND_PACKET,&cgc))
	perror("Unable to READ DVD STRUCTURE, examine /var/log/message"), exit(1);

    book = buf[4];
    switch (book&0xF0)
    {	case 0x00:	spec="-ROM";	break;
	case 0x10:	spec="-RAM";	break;
	case 0x20:	spec="-R";	break;
	case 0x30:	spec="-RW";	break;
	case 0x90:	spec="+RW";	break;
    }
    if (spec)	printf ("Current media Book Type Field is %02xh: DVD%s specification [revision %d]\n",book,spec,book&0xF);
    else	printf ("Current media Book Type Field is %02xh: unrecognized value\n",book);

  return 0;
}
