/*
   dpram.S: exception table and irq handler 
  
   Copyright (C) 2001 Ralph Metzler for convergence integrated media GmbH
 
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details. 

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

*/

	.text
	.align
	.globl _start

_start:	
	ldr   pc, reset		// reset vector
	movs  pc, lr            // undefined 
	ldr   pc, swi           // SWI
	subs  pc, lr, #4        // prefetch abort 
	subs  pc, lr, #8        // data abort
	subs  pc, lr, #4        // reserved
	b     irq_handler       // IRQ
	subs  pc, lr, #4        // FIQ

	.word crt_tbl
crt_tbl:
	.word (endtbl - crt_tbl) 	
	.word 0				
  	.word conf		
endtbl:	.word 0				
conf:	.word 0xa5a55a5a
	.word 0x001f1555
	.word 0x00000009

	
reset:	.word reset_handler	
	
swi:	.word swi_handler

/* handle IRQs in DPRAM (faster) */
irq_handler:
	subs  pc, r14, #4 
	

