/* 
    Copyright (C) 2000 Marcus Metzler (mocm@convergence.de)
    for convergence integrated media

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _PLAYER_XPM_H_
#define _PLAYER_XPM_H_

static const gchar *xpm_record[] = {
	"16 16 4 1",
	"  c None",
	". c #000000",
	"R c #FF0000",
	"W c #FFFFFF",
	"                ",
	"                ",
	"                ",
	"       ...W     ",
	"     ..RRR..W   ",
	"    .RRRRRRR.W  ",
	"   .RRRRRRRRR.W ",
	"   .RRRRRRRRR.W ",
	"   .RRRRRRRRR.W ",
	"    .RRRRRRR.W  ",
	"     . RRR..W   ",
	"       ...W     ",
	"                ",
	"                ",
	"                ",
	"                ",
};

static const gchar *xpm_play[] = {
	"16 16 4 1",
	"  c None",
	". c #000000",
	"R c #FF0000",
	"W c #FFFFFF",
	"                ",
	"                ",
	"                ",
	"  W.            ",
	"  W...          ",
	"  W.....        ",
	"  W.......      ",
	"  W.........    ",
	"  W........     ",
	"  W......W      ",
	"  W...W W       ",
	"  W.W           ",
	"   W            ",
	"                ",
	"                ",
	"                ",
};

static const gchar *xpm_fskp[] = {
	"16 16 4 1",
	"  c None",
	". c #000000",
	"R c #FF0000",
	"W c #FFFFFF",
	"                ",
	"                ",
	"             .. ",
	"  W.         .. ",
	"  W...       .. ",
	"  W.....     .. ",
	"  W.......   .. ",
	"  W......... .. ",
	"  W........  .. ",
	"  W......W   .. ",
	"  W...W W    .. ",
	"  W.W        .. ",
	"   W         .. ",
	"                ",
	"                ",
	"                ",
};

static const gchar *xpm_bskp[] = {
	"16 16 4 1",
	"  c None",
	". c #000000",
	"R c #FF0000",
	"W c #FFFFFF",
	"                ",
	"                ",
	" ..             ",
	" ..         .W  ",
	" ..       ...W  ",
	" ..     .....W  ",
	" ..   .......W  ",
	" .. .........W  ",
	" ..  ........W  ",
	" ..   W......W  ",
	" ..    W W...W  ",
	" ..        W.W  ",
	" ..         W   ",
	" ..             ",
	"                ",
	"                ",
};

static const gchar *xpm_ffwd[] = {
	"16 16 4 1",
	"  c None",
	". c #000000",
	"R c #FF0000",
	"W c #FFFFFF",
	"                ",
	"                ",
	" ....  ....     ",
	"  ....  ....    ",
	"   ....  ....   ",
	"    ....  ....  ",
	"     ....  .... ",
	"      ....  ....",
	"      ....  ....",
	"     ....W ....W",
	"    ....W ....W ",
	"   ....W ....W  ",
	"  ....W ....W   ",
	" ....W ....W    ",
	"                ",
	"                ",
};

static const gchar *xpm_slow[] = {
	"16 16 4 1",
	"  c None",
	". c #000000",
	"R c #FF0000",
	"W c #FFFFFF",
	"                ",
	"  W....         ",
	"   W....        ",
	"    WW...       ",
	"       W...     ",
	"         W...   ",
	"          WW..  ",
	"          ..W   ",
	"         ..W     ",
	"        ..W     ",
	"       ..W      ",
	"       ...      ",
	"         ...    ",
	"          W..   ",
	"   W........    ",
	"    WWWWWWWW    ",
};


static const gchar *xpm_pause[] = {
	"16 16 4 1",
	"  c None",
	". c #000000",
	"R c #FF0000",
	"W c #FFFFFF",
	"                ",
	"                ",
	"                ",
	"                ",
	"    ...W  ...W  ",
	"    ...W  ...W  ",
	"    ...W  ...W  ",
	"    ...W  ...W  ",
	"    ...W  ...W  ",
	"    ...W  ...W  ",
	"    ...W  ...W  ",
	"    ...W  ...W  ",
	"    ...W  ...W  ",
	"      W     W   ",
	"                ",
	"                ",
};

static const gchar *xpm_stop[] = {
	"16 16 4 1",
	"  c None",
	". c #000000",
	"R c #FF0000",
	"W c #FFFFFF",
	"                ",
	"                ",
	"                ",
	"                ",
	"    .........W  ",
	"    .........W  ",
	"    .........W  ",
	"    .........W  ",
	"    .........W  ",
	"    .........W  ",
	"    .........W  ",
	"    .........W  ",
	"    .........W  ",
	"      WWWWWWW   ",
	"                ",
	"                ",
};
#endif
