# Upload the files with rsync via ssh.

import os, sys, dputhelper

def upload(fqdn,login,incoming,files_to_upload,debug, dummy):

    files_to_fix = []

    for file in files_to_upload:
        to_fix = os.path.basename(file)
        file_to_fix = os.path.join(incoming, to_fix)
        files_to_fix.append(file_to_fix)

    upload_command = ['rsync', '--copy-links' '--progress', '--partial',
              '-zave', 'ssh -x', '%s@%s:%s' % (login, fqdn, incoming)]
    fix_command = ['ssh', '%s@%s' % (login, fqdn), 'chmod', '0644'] \
              + files_to_fix
    upload_command[1:2] = files_to_upload

    if debug:
        print "D: Uploading with rsync to %s@%s:%s" % \
            (login, fqdn, incoming)
    if dputhelper.spawnv(os.P_WAIT, '/usr/bin/rsync', upload_command):
        print
        print "Error while uploading."
        sys.exit(1)
    if debug:
        print "D: Fixing file permissions with %s@%s" % (login, fqdn)
    if dputhelper.spawnv(os.P_WAIT, '/usr/bin/ssh', fix_command):
        print "Error while fixing permission."
        sys.exit(1)
