/*
 * Copyright (C) 2004-2006 by CERN/IT/GD/CT
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)$RCSfile: srmlogit.c,v $ $Revision: 1.3 $ $Date: 2006/09/01 05:07:54 $ CERN Jean-Philippe Baud";
#endif /* not lint */

#include <errno.h>
#include <fcntl.h>
#include <string.h>
#include <sys/types.h>
#include <time.h>
#include <stdarg.h>
#include "Cglobals.h"
#include "srm_server.h"
extern int jid;
extern char logfile[];

srmlogit(char *func, char *msg, ...)
{
	va_list args;
	char prtbuf[LOGBUFSZ];
	int save_errno;
	int Tid = 0;
	struct tm *tm;
#if defined(_REENTRANT) || defined(_THREAD_SAFE)
	struct tm tmstruc;
#endif
	time_t current_time;
	int fd_log;

	save_errno = errno;
	va_start (args, msg);
	(void) time (&current_time);		/* Get current time */
#if (defined(_REENTRANT) || defined(_THREAD_SAFE)) && !defined(_WIN32)
	(void) localtime_r (&current_time, &tmstruc);
	tm = &tmstruc;
#else
	tm = localtime (&current_time);
#endif
	Cglobals_getTid (&Tid);
	if (Tid < 0)	/* main thread */
		Csnprintf (prtbuf, LOGBUFSZ, "%02d/%02d %02d:%02d:%02d %5d %s: ",
		    tm->tm_mon+1, tm->tm_mday, tm->tm_hour, tm->tm_min, tm->tm_sec,
		    jid, func);
	else
		Csnprintf (prtbuf, LOGBUFSZ, "%02d/%02d %02d:%02d:%02d %5d,%d %s: ",
		    tm->tm_mon+1, tm->tm_mday, tm->tm_hour, tm->tm_min, tm->tm_sec,
		    jid, Tid, func);
	Cvsnprintf (prtbuf+strlen(prtbuf), LOGBUFSZ-strlen(prtbuf), msg, args);
	if (prtbuf[LOGBUFSZ-2] != '\n') {
		prtbuf[LOGBUFSZ-2] = '\n';
		prtbuf[LOGBUFSZ-1] = '\0';
	}
	va_end (args);
#ifdef O_LARGEFILE
	fd_log = open (logfile, O_WRONLY | O_CREAT | O_APPEND | O_LARGEFILE, 0664);
#else
	fd_log = open (logfile, O_WRONLY | O_CREAT | O_APPEND, 0664);
#endif
	write (fd_log, prtbuf, strlen(prtbuf));
	close (fd_log);
	errno = save_errno;
	return (0);
}
