.\" @(#)$RCSfile: Cns_creat.man,v $ $Revision: 1.2 $ $Date: 2005/06/30 08:34:03 $ CERN IT-PDP/DM Jean-Philippe Baud
.\" Copyright (C) 1999-2005 by CERN/IT/PDP/DM
.\" All rights reserved
.\"
.TH CNS_CREAT 3 "$Date: 2005/06/30 08:34:03 $" CASTOR "Cns Library Functions"
.SH NAME
Cns_creat \- create a new CASTOR file or reset it in the name server
.SH SYNOPSIS
.B #include <sys/types.h>
.br
\fB#include "Cns_api.h"\fR
.sp
.BI "int Cns_creat (const char *" path ,
.BI "mode_t " mode )
.sp
.BI "int Cns_creatx (const char *" path ,
.BI "mode_t " mode ,
.BI "struct Cns_fileid *" file_uniqueid )
.SH DESCRIPTION
.B Cns_creat
creates a new CASTOR file or resets it in the name server.
.LP
If the file exists, the length is truncated to 0 and the mode and owner
are unchanged.
.LP
If the file does not exist yet, an entry is created in the name server
database and the file's owner ID is set to the effective user ID of the
requestor.
The group ID of the file is set to the effective group ID of the requestor
or is taken from the parent directory if the latter has the
.B S_ISGID
bit set.
.LP
The access permission bits for the file are taken from
.IR mode ,
then all bits set in the requestor's file mode creation mask are cleared (see
.BR Cns_umask (3)).
.LP
.B Cns_creatx
behaves in the same way and returns the file unique id (name server hostname
and file id).
.TP
.I path
specifies the logical pathname relative to the current CASTOR directory or
the full CASTOR pathname.
.SH RETURN VALUE
This routine returns 0 if the operation was successful or -1 if the operation
failed. In the latter case,
.B serrno
is set appropriately.
.SH ERRORS
.TP 1.3i
.B ENOENT
A component of
.I path
prefix does not exist or
.I path
is a null pathname.
.TP
.B EACCES
Search permission is denied on a component of the
.I path
prefix or the file does not exist and write permission on the parent directory
is denied or the file exists and write permission on the file itself is denied.
.TP
.B EFAULT
.I path
or
.I file_uniqueid
is a NULL pointer.
.TP
.B EEXIST
File exists already and has replicas.
.TP
.B ENOTDIR
A component of
.I path
prefix is not a directory.
.TP
.B EISDIR
.I path
is an existing directory.
.TP
.B EINVAL
The fileclass in the parent directory is zero.
.TP
.B ENOSPC
The name server database is full.
.TP
.B ENAMETOOLONG
The length of
.I path
exceeds
.B CA_MAXPATHLEN
or the length of a
.I path
component exceeds
.BR CA_MAXNAMELEN .
.TP
.B SENOSHOST
Host unknown.
.TP
.B SENOSSERV
Service unknown.
.TP
.B SECOMERR
Communication error.
.TP
.B ENSNACT
Name server is not running or is being shutdown.
.SH SEE ALSO
.BR Castor_limits(4) ,
.BR Cns_chdir(3) ,
.BR Cns_chmod(3) ,
.BR Cns_stat(3) ,
.BR Cns_umask(3)
.SH AUTHOR
\fBCASTOR\fP Team <castor.support@cern.ch>
