/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;

class adClientSession
extends Thread {
    private Socket socket = null;
    private BufferedReader input = null;
    private PrintWriter output = null;
    private boolean running = true;
    private adChatDatasource datasource = null;
    private adChatServer server = null;
    private boolean authenticate_p = false;
    private boolean from_HTML_client = false;
    private String room_id = null;
    private InetAddress inet_address = null;
    public String user_name = null;
    public String user_id = null;
    public boolean moderator = false;

    public adClientSession(adChatServer adChatServer2, Socket socket) {
        this.datasource = adChatServer2.getDatasource();
        this.socket = socket;
        this.server = adChatServer2;
        this.inet_address = socket.getInetAddress();
    }

    public void run() {
        try {
            this.input = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            this.output = new PrintWriter(this.socket.getOutputStream(), true);
            while (this.running) {
                Object object;
                String string = this.input.readLine();
                System.out.println("Receive [" + string + "]");
                if (string.equals("Bye")) {
                    this.running = false;
                    this.output.close();
                    this.datasource.disconnectAll();
                    if (this.inet_address.equals(InetAddress.getLocalHost())) {
                        this.server.shutdown();
                    }
                    return;
                }
                if (!this.authenticate_p) {
                    object = new adChatLoginMessage(string);
                    if (!((adChatLoginMessage)object).isValid()) {
                        this.output.println(adChatMessage.buildBroadcastMsg(null, "Administrator", null, "Access denied."));
                        this.output.close();
                        this.socket.close();
                        this.running = false;
                        return;
                    }
                    this.user_name = ((adChatLoginMessage)object).getUserName();
                    this.room_id = ((adChatLoginMessage)object).getRoomId();
                    this.user_id = ((adChatLoginMessage)object).getUserId();
                    String string2 = ((adChatLoginMessage)object).getPassword();
                    if (string2 != null && string2.equals("T")) {
                        this.moderator = true;
                    }
                    System.out.println("User name: " + this.user_name + ", moderator = " + this.moderator);
                    if (this.user_name.equals("AOL_READER")) {
                        this.datasource.addAolSession(this);
                        this.authenticate_p = true;
                        continue;
                    }
                    if (this.user_name.equals("AOL_WRITER")) {
                        this.from_HTML_client = true;
                        this.authenticate_p = true;
                        continue;
                    }
                    if (this.datasource.isDuplicate(this.user_name, this.room_id)) {
                        this.output.println(adChatMessage.buildBroadcastMsg(null, "Administrator", null, "User already in the room."));
                        this.output.close();
                        this.running = false;
                        return;
                    }
                    String string3 = this.datasource.getAppletUsers(this.room_id);
                    if (string3 != null) {
                        this.output.println(string3);
                    }
                    this.datasource.addSession(this, this.room_id);
                    this.datasource.broadcastAppletOnly(adChatSystemMessage.buildUserEnterMsg(this.user_id, this.user_name), this.room_id);
                    this.datasource.broadcast(adChatMessage.buildBroadcastMsg(this.user_id, this.user_name, this.room_id, " has entered the room."), this.room_id);
                    this.authenticate_p = true;
                    continue;
                }
                System.out.println("Broadcast [" + string + "]");
                if (adChatSimpleXMLParser.containTag(string, "system")) {
                    this.datasource.broadcastAppletOnly(string, this.room_id);
                    continue;
                }
                if (this.from_HTML_client) {
                    object = new adChatMessage(string);
                    this.room_id = ((adChatMessage)object).getRoomId();
                }
                if (!this.moderator) {
                    object = new adChatMessage(string);
                    string = adChatMessage.buildModerateMsg(((adChatMessage)object).getFromUser(), ((adChatMessage)object).getRoomId(), ((adChatMessage)object).getBody());
                }
                this.datasource.broadcast(string, this.room_id);
            }
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.datasource.removeSession(this, this.room_id);
        this.datasource.broadcast(adChatMessage.buildBroadcastMsg(this.user_id, this.user_name, this.room_id, " has leave the room."), this.room_id);
    }

    public void postMessage(String string) {
        try {
            this.output.println(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void disconnect() {
        this.running = false;
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

