import re
from dosage.modules.helpers.BasicComicModule import BasicComicModule

class PensAndTales(BasicComicModule):
    imageUrl = '?date='
    imageSearch = re.compile(r'<img[^>]+?src="([^"]*?comics/.+?)"', re.IGNORECASE)
    prevSearch = re.compile(r'<a href="([^"]*?\?date=\d+)">(:?<img[^>]+?alt=")?Previous Comic', re.IGNORECASE)
    help = 'Index format: yyyymmdd'

    submodules = {
        'Dragonaur': 'http://dragonaur.pensandtales.com/',
        'Evilish': 'http://evilish.pensandtales.com/',
        'FireflyCross': 'http://fireflycross.pensandtales.com/',
        'RedAllOver': 'http://redallover.pensandtales.com/',
        'SavingTaern': 'http://strangekith.pensandtales.com/savingtaern/',
        'Strangekith': 'http://strangekith.pensandtales.com/',
        'StickyEvil': 'http://stickyevil.pensandtales.com/',
        'ThoseDestined': 'http://thosedestined.pensandtales.com/',
        'TreasureHunters': 'http://th.pensandtales.com/',
        'YamiNoTainai': 'http://ynt.pensandtales.com/',
    }

    def __init__(self, submodule):
        BasicComicModule.__init__(self)
        baseUrl = self.submodules[submodule]
        self.latestUrl = baseUrl
        self.imageUrl = baseUrl + self.imageUrl
        self.name = 'PensAndTales' + '/' + submodule
