import re
from dosage.modules.helpers.BasicComicModule import BasicComicModule

class JamesFrancis(BasicComicModule):
    baseUrl = 'http://www.jamesfrancis.net/%s'
    imageUrl = '?strip_id=%s'
    imageSearch = re.compile(r'<img src="(.*?/\d{6}.[^"]+?)"')
    prevSearch = re.compile(r'<a href="([^?]*\?strip_id=\d+)"><img src=images/previous')
    help = 'Index format: nnn'

    submodules = {
        'gonzo': 'gonzo/index.php',
        'psycindom0': 'psycindom/year_0.php',
        'psycindom1': 'psycindom/year_1.php',
        'psycindom2': 'psycindom/index.php',
    }

    def __init__(self, submodule):
        BasicComicModule.__init__(self)
        self.baseUrl = self.baseUrl % self.submodules[submodule]
        self.latestUrl = self.baseUrl
        self.imageUrl = self.baseUrl + self.imageUrl
        self.name = 'JamesFrancis' + '/' + submodule
