/**
 * Class for holding details of a file to be indexed.
 * Many of these will be put together in a linked list in the FileList class.
 *<BR>
 * A very large number of these classes will be instantiated. Therefore, we are
 * trying to keep this class as simple as possible.
 * 
 * @version $Id: IGFile.java,v 1.13 2002/09/15 20:23:06 blsecres Exp $
 * @author Mark Howard
 */
class IGFile extends java.util.HashMap {
    /*
     * Keys to be used in the map are defined in the IGKeySet class
     */

    /**
     * Retrieve the full location of the file
     * @return A string representing the file path
     */
    public String getLocation() { return getString(IGKey.LOCATION); } 


    /**
     * Retrieve a file's meta information based on an integer
     * @param key The integer value to look up
     * @return A string representation of the requested value
     */
    public String getString(int key) {
	return((String) get(new Integer(key)));
    }
  

    /**
     * Retrieve a file's meta information based on an object
     * @param key The object value to look up
     * @return A string representation of the requested value
     */
    public String getString(Object key) {
//	System.out.println("** Get data for "+key);
//	System.out.println( get(key).toString());
	if (! containsKey(key) || get(key) == null) {
	    return null;
	} else {
	    return((String) get(key));
	}
    }
  

    /**
     * Construct a new IGFile object
     * @param fileLocation The file this IGFile object represents
     */
    protected IGFile(String fileLocation) {
	super();   // make the hashmap
	put(IGKey.LOCATION, fileLocation);
    }


    /**
     * Ensure all meta information for this IGFile has a valid string value
     */
    public void fillStrings() {
	// array of keys to establish fall-back order
	IGKey[] keys = new IGKey[] {
	    IGKey.FILE_NAME, IGKey.TITLE, IGKey.AUTHOR, IGKey.DESCRIPTION,
	    IGKey.KEYWORDS, IGKey.FILE_SIZE, IGKey.FILE_TYPE, IGKey.PARSER, 
	};

	for (int i = 0; i < keys.length; i++) {
	    String curString = getString(keys[i]);

	    if (curString == null || curString.length() == 0) {
		if (keys[i].equals(IGKey.FILE_NAME))
		    // put location in for FILE_NAME (LOCATION will always exist
		    put(IGKey.FILE_NAME, getLocation());
		else if (keys[i].equals(IGKey.TITLE))
		    // through the keys order, TITLE can always use FILE_NAME
		    put(IGKey.TITLE, getString(IGKey.FILE_NAME));
		else if (keys[i].equals(IGKey.DESCRIPTION))
		    // DESCRIPTION can use TITLE
		    put(IGKey.DESCRIPTION, getString(IGKey.TITLE));
		else
		    // else, make sure "null" doesn't show up in output
		    put(keys[i], new String(""));
	    }
	}
    }
}

/*
 * $Log: IGFile.java,v $
 * Revision 1.13  2002/09/15 20:23:06  blsecres
 * Added code to fill in all meta information strings for an IGFile object.
 *
 * Revision 1.12  2002/08/26 13:56:26  howama
 * More work & bug fixes
 *
 * Revision 1.11  2002/08/23 03:40:23  blsecres
 * Integrated LinkScanner into FileList.makeList().
 * Started coding support for 'linkfollow' based file system search
 *     in LinkScanner.
 *
 * Revision 1.10  2002/08/22 19:47:13  blsecres
 * Switched code to use IGKey values.
 *
 * Revision 1.9  2002/08/22 13:42:38  howama
 * more work
 *
 * Revision 1.8  2002/08/21 15:13:12  howama
 * more work
 *
 * Revision 1.7  2002/08/16 12:24:24  blsecres
 * Converted DirScanner to be an extension of FileListBuilder.
 *
 * Revision 1.6  2002/08/16 10:12:51  howama
 * hopefully now all at an agreement
 *
 * Revision 1.5  2002/08/08 17:24:41  howama
 * updates
 *
 * Revision 1.4  2002/07/24 09:24:21  howama
 * updated javadoc docs
 *
 * Revision 1.3  2002/07/12 14:07:31  howama
 * updates
 *
 * Revision 1.2  2002/07/05 10:52:01  howama
 * Added log tag
 *
 */
