import junit.framework.*;


/**
 * Unit test for the IGKeySet class
 *
 * @author Ben Secrest &lt;blsecres@users.sourceforge.net&gt;
 * @version $Id: IGKeySetTest.java,v 1.2 2002/08/31 22:00:21 blsecres Exp $
 */
public class IGKeySetTest extends TestCase {
    private IGKeySet keySet;


    /**
     * Initialize IGKeySet object for use in tests
     */
    protected void setUp() {
	keySet = new IGKeySet();
	keySet.set(1 /* IGKey.TITLE */);
	keySet.set(2 /* IGKey.AUTHOR */);
	keySet.clear(3 /* IGKey.DESCRIPTION */);
	keySet.clear(4 /* IGKey.KEYWORDS */);
    }


    /**
     * Test the wants method
     */
    public void testWants() {
	Assert.assertEquals(keySet.wants(IGKey.AUTHOR), true);
	Assert.assertTrue(keySet.wants(IGKey.TITLE));
	Assert.assertEquals(keySet.wants(IGKey.KEYWORDS), false);
	Assert.assertFalse(keySet.wants(IGKey.DESCRIPTION));
	Assert.assertFalse(keySet.wants(null));
    }


    /**
     * Test the setWanted method
     */
    public void testSetWanted() {
	// an array of false keys
	IGKey[] keys = new IGKey[]{IGKey.KEYWORDS, IGKey.DESCRIPTION};

	for (int i = 0; i < keys.length; i++) {
	    Assert.assertFalse(keySet.wants(keys[i]));
	    keySet.setWanted(keys[i]);
	    Assert.assertTrue(keySet.wants(keys[i]));
	}

	keySet.setWanted(null);
    }


    /**
     * Test the ignore method
     */
    public void testIgnore() {
	// an array of true keys
	IGKey[] keys = new IGKey[]{IGKey.AUTHOR, IGKey.TITLE};

	for (int i = 0; i < keys.length; i++) {
	    Assert.assertTrue(keySet.wants(keys[i]));
	    keySet.ignore(keys[i]);
	    Assert.assertFalse(keySet.wants(keys[i]));
	}

	keySet.ignore(null);
    }
}
