import java.util.BitSet;

/**
 * Class for maintaining user preferences concerning attributes to be extracted
 * from documents
 *
 * @author Ben Secrest &lt;blsecres@users.sourceforge.net&gt;
 * @version $Id: IGKeySet.java,v 1.11 2002/08/29 02:04:07 blsecres Exp $
 */
public class IGKeySet extends BitSet {
    /** Number of preferences held */
    private static final int NUM_PREFERENCES = 5;

    /**
     * Construct an IGKeySet
     */
    public IGKeySet() {
	super(NUM_PREFERENCES);
    }


    /**
     * Determine if the set contains the give key
     * @param key The IGKey to look up
     * @return <tt>true</tt> if the key is set, <tt>false</tt> otherwise
     */
    public boolean wants(IGKey key) {
	if (key == null)
	    return false;

	return get(key.getValue());
    }


    /**
     * Add a bit for the given key
     * @param key The IGKey to set
     */
    public void setWanted(IGKey key) {
	if (key == null)
	    return;

	set(key.getValue());
    }


    /**
     * Remove a given key's bit
     * @param key The IGKey to clear
     */
    public void ignore(IGKey key) {
	if (key == null)
	    return;

	clear(key.getValue());
    }
}
