/*
 * Decompiled with CFR 0.152.
 */
package org.dojotoolkit.shrinksafe;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.dojotoolkit.shrinksafe.Compressor;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.tools.ToolErrorReporter;
import org.mozilla.javascript.tools.shell.Global;
import org.mozilla.javascript.tools.shell.QuitAction;
import org.mozilla.javascript.tools.shell.ShellContextFactory;

public class Main {
    protected static final Global global = new Global();
    protected static final ShellContextFactory shellContextFactory = new ShellContextFactory();
    protected static ToolErrorReporter errorReporter;
    protected static int exitCode;
    protected static boolean escapeUnicode;
    protected static String stripConsole;

    public static void main(String[] stringArray) {
        errorReporter = new ToolErrorReporter(false, global.getErr());
        shellContextFactory.setErrorReporter(errorReporter);
        IProxy iProxy = new IProxy(1, Main.processOptions(stringArray));
        global.init(shellContextFactory);
        shellContextFactory.call(iProxy);
    }

    public static String[] processOptions(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (!string2.startsWith("-")) {
                arrayList.add(string2);
                continue;
            }
            if (string2.equals("-js-version")) {
                if (++i == stringArray.length) {
                    string = string2;
                }
                int n = 0;
                try {
                    n = Integer.parseInt(stringArray[i]);
                }
                catch (NumberFormatException numberFormatException) {
                    string = stringArray[i];
                }
                if (!Context.isValidLanguageVersion(n)) {
                    string = stringArray[i];
                }
                if (string == null) continue;
                shellContextFactory.setLanguageVersion(n);
                continue;
            }
            if (string2.equals("-?") || string2.equals("-help")) {
                bl = true;
                continue;
            }
            if (string2.equals("-escape-unicode")) {
                escapeUnicode = true;
                continue;
            }
            if (!string2.equals("-stripConsole")) continue;
            if (i >= stringArray.length - 1) {
                string = Main.getMessage("msg.shell.stripConsoleMissingArg");
                continue;
            }
            if ((stripConsole = stringArray[++i]).equals("normal") || stripConsole.equals("warn") || stripConsole.equals("all")) continue;
            string = Main.getMessage("msg.shell.stripConsoleInvalid");
        }
        if (string != null) {
            global.getOut().println(Main.getMessage("msg.shell.invalid", string));
        }
        if (string != null || bl) {
            global.getOut().println(Main.getMessage("msg.shell.usage"));
            System.exit(1);
        }
        String[] stringArray2 = new String[arrayList.size()];
        stringArray2 = arrayList.toArray(stringArray2);
        return stringArray2;
    }

    static void processFiles(Context context, String[] stringArray) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        if (stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    String string = (String)Main.readFileOrUrl(stringArray[i], true);
                    stringBuffer.append(Compressor.compressScript(string, 0, 1, escapeUnicode, stripConsole));
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        } else {
            byte[] byArray = Kit.readStream(global.getIn(), 4096);
            String string = new String(byArray);
            if (string != null) {
                stringBuffer.append(Compressor.compressScript(string, 0, 1, escapeUnicode, stripConsole));
            }
        }
        global.getOut().println(stringBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object readFileOrUrl(String string, boolean bl) throws IOException {
        Object object;
        URL uRL = null;
        if (string.indexOf(58) >= 2) {
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        InputStream inputStream = null;
        int n = 0;
        if (uRL == null) {
            object = new File(string);
            n = (int)((File)object).length();
            try {
                inputStream = new FileInputStream((File)object);
            }
            catch (IOException iOException) {
                Context.reportError(Main.getMessage("msg.couldnt.open", string));
                throw iOException;
            }
        }
        try {
            object = uRL.openConnection();
            inputStream = ((URLConnection)object).getInputStream();
            n = ((URLConnection)object).getContentLength();
            if (n > 0x100000) {
                n = -1;
            }
        }
        catch (IOException iOException) {
            Context.reportError(Main.getMessage("msg.couldnt.open.url", uRL.toString(), iOException.toString()));
            throw iOException;
        }
        if (n <= 0) {
            n = 4096;
        }
        try {
            try {
                inputStream = new BufferedInputStream(inputStream);
                object = Kit.readStream(inputStream, n);
            }
            finally {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            Context.reportError(iOException.toString());
            throw iOException;
        }
        Object object2 = bl ? new String((byte[])object) : object;
        return object2;
    }

    private static String getMessage(String string) {
        return Main.getMessage(string, (Object[])null);
    }

    private static String getMessage(String string, String string2) {
        return Main.getMessage(string, new Object[]{string2});
    }

    private static String getMessage(String string, Object object, Object object2) {
        return Main.getMessage(string, new Object[]{object, object2});
    }

    private static String getMessage(String string, Object[] objectArray) {
        Context context = Context.getCurrentContext();
        Locale locale = context == null ? Locale.getDefault() : context.getLocale();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org.dojotoolkit.shrinksafe.resources.Messages", locale);
        String string2 = null;
        try {
            string2 = resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            throw new RuntimeException("no message resource found for message property " + string);
        }
        if (objectArray == null) {
            return string2;
        }
        MessageFormat messageFormat = new MessageFormat(string2);
        return messageFormat.format(objectArray);
    }

    static {
        exitCode = 0;
        escapeUnicode = false;
        stripConsole = null;
        global.initQuitAction(new IProxy(3, null));
    }

    private static class IProxy
    implements ContextAction,
    QuitAction {
        private static final int PROCESS_FILES = 1;
        private static final int SYSTEM_EXIT = 3;
        private int type;
        private String[] args;

        IProxy(int n, String[] stringArray) {
            this.type = n;
            this.args = stringArray;
        }

        public Object run(Context context) {
            if (this.type == 1) {
                try {
                    Main.processFiles(context, this.args);
                }
                catch (IOException iOException) {
                    Context.reportError(iOException.toString());
                }
            } else {
                throw Kit.codeBug();
            }
            return null;
        }

        public void quit(Context context, int n) {
            if (this.type == 3) {
                System.exit(n);
                return;
            }
            throw Kit.codeBug();
        }
    }
}

