/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.AWTPermission;
import java.awt.Color;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.SocketPermission;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import netscape.javascript.JSObject;

public final class DOHRobot
extends Applet {
    private JSObject window = null;
    private Robot robot = null;
    private static ExecutorService threadPool = null;
    private static HashMap charMap = null;
    private Vector vkKeys = null;
    private boolean shift = false;
    private boolean altgraph = false;
    private boolean ctrl = false;
    private boolean alt = false;
    private boolean meta = false;
    private boolean numlockDisabled = false;
    private long timingError = 0L;
    private boolean jsready = false;
    private String keystring = "";
    public boolean firebugIgnore = true;
    private static String os = System.getProperty("os.name").toUpperCase();
    private static Toolkit toolkit = Toolkit.getDefaultToolkit();
    private SecurityManager securitymanager;
    private double key = -1.0;
    private boolean inited = false;
    private int docScreenX = -100;
    private int docScreenY = -100;
    private int docScreenXMax;
    private int docScreenYMax;
    private Point margin = null;
    private boolean mouseSecurity = false;
    private int lastMouseX;
    private int lastMouseY;
    public int dir = 1;
    JSObject dohrobot = null;
    private BufferedImage trackingImage;
    Point locationOnScreen = null;

    public void stop() {
        this.window = null;
        this.dohrobot = null;
        if (this.key != -2.0) {
            this.key = -2.0;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    if (threadPool != null) {
                        threadPool.shutdownNow();
                    }
                    DOHRobot.this.log("Stop");
                    DOHRobot.this.securitymanager.checkTopLevelWindow(null);
                    DOHRobot.this.log("Security manager reset");
                    return null;
                }
            });
        }
    }

    public void init() {
        threadPool = Executors.newFixedThreadPool(1);
        this.addComponentListener(new onvisible());
        ProfilingThread profilingThread = new ProfilingThread();
        profilingThread.startProfiling();
        profilingThread.endProfiling();
        this.trackingImage = new BufferedImage(3, 3, 1);
        this.trackingImage.setRGB(0, 0, 3, 3, new int[]{new Color(255, 174, 201).getRGB(), new Color(255, 127, 39).getRGB(), new Color(0, 0, 0).getRGB(), new Color(237, 28, 36).getRGB(), new Color(63, 72, 204).getRGB(), new Color(34, 177, 76).getRGB(), new Color(181, 230, 29).getRGB(), new Color(255, 255, 255).getRGB(), new Color(200, 191, 231).getRGB()}, 0, 3);
    }

    public void _setKey(double d) {
        if (d == -1.0) {
            return;
        }
        if (this.key == -1.0) {
            this.key = d;
        }
    }

    protected Point getDesktopMousePosition() throws Exception {
        Class<?> clazz = Class.forName("java.awt.MouseInfo");
        Class<?> clazz2 = Class.forName("java.awt.PointerInfo");
        Method method = clazz.getMethod("getPointerInfo", new Class[0]);
        Method method2 = clazz2.getMethod("getLocation", new Class[0]);
        Object object = null;
        try {
            object = method.invoke(clazz2, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.getTargetException().printStackTrace();
        }
        return (Point)method2.invoke(object, new Object[0]);
    }

    public Point getLocationOnScreen() {
        return this.locationOnScreen == null ? super.getLocationOnScreen() : this.locationOnScreen;
    }

    private boolean mouseSecure() throws Exception {
        if (!this.mouseSecurity) {
            return true;
        }
        Point point = null;
        try {
            point = this.getDesktopMousePosition();
        }
        catch (Exception exception) {
            return true;
        }
        return point.x >= this.docScreenX && point.x <= this.docScreenXMax && point.y >= this.docScreenY && point.y <= this.docScreenYMax;
    }

    private boolean isSecure(double d) {
        boolean bl = this.key != -1.0 && this.key != -2.0 && this.key == d;
        try {
            bl = bl && this.mouseSecure();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = false;
        }
        if (!bl && this.key != -2.0) {
            this.key = -2.0;
            this.window.eval("doh.robot._appletDead=true;");
            this.log("User aborted test; mouse moved off of browser");
            this.alert("User aborted test; mouse moved off of browser.");
        }
        this.log("Key secure: " + bl);
        return bl;
    }

    public void _callLoaded(final double d) {
        this.log("> _callLoaded Robot");
        Runnable runnable = new Runnable(){

            public void run() {
                if (!DOHRobot.this.isSecure(d)) {
                    return;
                }
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        int n;
                        Point point = DOHRobot.this.getLocationOnScreen();
                        if (os.indexOf("MAC") != -1) {
                            point = new Point();
                            int n2 = 0;
                            n = -1;
                            int n3 = Integer.MAX_VALUE;
                            GraphicsDevice[] graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
                            try {
                                for (n2 = 0; n2 < graphicsDeviceArray.length; ++n2) {
                                    DisplayMode displayMode = graphicsDeviceArray[n2].getDisplayMode();
                                    int n4 = displayMode.getWidth();
                                    int n5 = displayMode.getHeight();
                                    int n6 = DOHRobot.this.trackingImage.getWidth();
                                    int n7 = DOHRobot.this.trackingImage.getHeight();
                                    Robot robot = new Robot(graphicsDeviceArray[n2]);
                                    DOHRobot.this.log("screen dimensions: " + n4 + " " + n5);
                                    BufferedImage bufferedImage = robot.createScreenCapture(new Rectangle(0, 0, n4, n5));
                                    int n8 = 0;
                                    int n9 = 0;
                                    for (n8 = 0; n8 <= n4 - n6; ++n8) {
                                        for (n9 = 0; n9 <= n5 - n7; ++n9) {
                                            boolean bl = false;
                                            int n10 = 0;
                                            block15: for (int i = 0; i < n6; ++i) {
                                                for (int j = 0; j < n7; ++j) {
                                                    int n11 = Math.abs(bufferedImage.getRGB(n8 + i, n9 + j) - DOHRobot.this.trackingImage.getRGB(i, j));
                                                    if ((n10 += n11) >= n3) break block15;
                                                }
                                            }
                                            if (n10 >= n3) continue;
                                            point.x = n8;
                                            point.y = n9;
                                            n3 = n10;
                                            n = n2;
                                        }
                                    }
                                }
                                DOHRobot.this.robot = new Robot(graphicsDeviceArray[n]);
                                DOHRobot.this.robot.setAutoWaitForIdle(true);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                            if (point.x == 0 && point.y == 0) {
                                throw new RuntimeException("Robot not found on screen");
                            }
                            DOHRobot.this.locationOnScreen = point;
                        } else {
                            try {
                                DOHRobot.this.robot = new Robot();
                                DOHRobot.this.robot.setAutoWaitForIdle(true);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        DOHRobot.this.log("Document root: ~" + point.toString());
                        int n12 = point.x + 16;
                        n = point.y + 8;
                        try {
                            Thread.sleep(100L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        DOHRobot.this.robot.mouseMove(n12, n);
                        try {
                            DOHRobot.this.robot = new Robot();
                            DOHRobot.this.robot.setAutoWaitForIdle(true);
                            Thread.sleep(100L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        DOHRobot.this.robot.mousePress(16);
                        try {
                            Thread.sleep(100L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        DOHRobot.this.robot.mouseRelease(16);
                        try {
                            Thread.sleep(100L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        DOHRobot.this.log("< _callLoaded Robot");
                        return null;
                    }
                });
            }
        };
        threadPool.execute(runnable);
    }

    private DOHRobot applet() {
        return this;
    }

    public void log(final String string) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                System.out.println(new Date().toString() + ": " + string);
                return null;
            }
        });
    }

    private void alert(final String string) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                DOHRobot.this.window.eval("top.alert(\"" + string + "\");");
                return null;
            }
        });
    }

    private boolean confirm(String string) {
        JOptionPane jOptionPane = new JOptionPane(string, -1, 2);
        JDialog jDialog = jOptionPane.createDialog(this, "doh.robot");
        jDialog.setLocationRelativeTo(this);
        jDialog.show();
        return (Integer)jOptionPane.getValue() == 0;
    }

    public void setDocumentBounds(double d, int n, int n2, int n3, int n4) throws Exception {
        this.log("> setDocumentBounds");
        if (!this.isSecure(d)) {
            return;
        }
        if (!this.inited) {
            this.inited = true;
            this.lastMouseX = this.docScreenX = n;
            this.lastMouseY = this.docScreenY = n2;
            this.docScreenXMax = n + n3;
            this.docScreenYMax = n2 + n4;
            this.margin = this.getLocationOnScreen();
            this.margin.x -= n;
            this.margin.y -= n2;
            this.mouseSecurity = true;
        }
        this.log("< setDocumentBounds");
    }

    private void _mapKey(char c, int n, boolean bl, boolean bl2) {
        this.log("_mapKey: " + c);
        if (!charMap.containsKey(new Integer(c))) {
            this.log("Notified: " + c);
            KeyEvent keyEvent = new KeyEvent(this.applet(), 0, 0L, (bl ? 1 : 0) + (bl2 ? 32 : 0), (Integer)this.vkKeys.get(n), c);
            charMap.put(new Integer(c), keyEvent);
            this.log("Mapped char " + c + " to KeyEvent " + keyEvent);
            if (c >= 'a' && c <= 'z') {
                char c2 = Character.toUpperCase(c);
                keyEvent = new KeyEvent(this.applet(), 0, 0L, 1 + (bl2 ? 32 : 0), (Integer)this.vkKeys.get(n), c2);
                charMap.put(new Integer(c2), keyEvent);
                this.log("Mapped char " + (char)c2 + " to KeyEvent " + keyEvent);
            }
        }
    }

    public void _notified(final double d, final String string) {
        Runnable runnable = new Runnable(){

            public void run() {
                if (!DOHRobot.this.isSecure(d)) {
                    return;
                }
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        DOHRobot.this.keystring = DOHRobot.this.keystring + string;
                        if (DOHRobot.this.altgraph && !DOHRobot.this.shift) {
                            DOHRobot.this.shift = false;
                            DOHRobot.this.robot.setAutoDelay(1);
                            try {
                                char c;
                                int n;
                                DOHRobot.this.log(DOHRobot.this.keystring);
                                int n2 = 0;
                                for (n = 0; n < DOHRobot.this.vkKeys.size() && n2 < DOHRobot.this.keystring.length(); ++n) {
                                    c = DOHRobot.this.keystring.charAt(n2++);
                                    DOHRobot.this._mapKey(c, n, false, false);
                                }
                                for (n = 0; n < DOHRobot.this.vkKeys.size() && n2 < DOHRobot.this.keystring.length(); ++n) {
                                    c = DOHRobot.this.keystring.charAt(n2++);
                                    DOHRobot.this._mapKey(c, n, true, false);
                                }
                                for (n = 0; n < DOHRobot.this.vkKeys.size() && n2 < DOHRobot.this.keystring.length(); ++n) {
                                    c = DOHRobot.this.keystring.charAt(n2++);
                                    DOHRobot.this._mapKey(c, n, false, true);
                                }
                                DOHRobot.this.dohrobot.call("_onKeyboard", new Object[0]);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                            return null;
                        }
                        if (!DOHRobot.this.shift) {
                            DOHRobot.this.shift = true;
                        } else {
                            DOHRobot.this.shift = false;
                            DOHRobot.this.altgraph = true;
                        }
                        DOHRobot.this.pressNext();
                        return null;
                    }
                });
            }
        };
        threadPool.execute(runnable);
    }

    private void pressNext() {
        Runnable runnable = new Runnable(){

            public void run() {
                DOHRobot.this.log("starting up, " + DOHRobot.this.shift + " " + DOHRobot.this.altgraph);
                if (DOHRobot.this.shift) {
                    DOHRobot.this.robot.keyPress(16);
                    DOHRobot.this.log("Pressing shift");
                }
                try {
                    if (DOHRobot.this.altgraph) {
                        DOHRobot.this.robot.keyPress(65406);
                        DOHRobot.this.log("Pressing alt graph");
                    }
                }
                catch (Exception exception) {
                    DOHRobot.this.log("Error pressing alt graph");
                    exception.printStackTrace();
                    DOHRobot.this._notified(DOHRobot.this.key, "");
                    return;
                }
                DOHRobot.this.dohrobot.call("_nextKeyGroup", new Integer(DOHRobot.this.vkKeys.size()));
                for (int i = 0; i < DOHRobot.this.vkKeys.size(); ++i) {
                    try {
                        DOHRobot.this.log("Press " + (Integer)DOHRobot.this.vkKeys.get(i));
                        DOHRobot.this.robot.keyPress((Integer)DOHRobot.this.vkKeys.get(i));
                        DOHRobot.this.log("Release " + (Integer)DOHRobot.this.vkKeys.get(i));
                        DOHRobot.this.robot.keyRelease((Integer)DOHRobot.this.vkKeys.get(i));
                        if (DOHRobot.this.altgraph && i == DOHRobot.this.vkKeys.size() - 1) {
                            DOHRobot.this.robot.keyRelease(65406);
                            DOHRobot.this.log("Releasing alt graph");
                        }
                        if (DOHRobot.this.shift && i == DOHRobot.this.vkKeys.size() - 1) {
                            DOHRobot.this.robot.keyRelease(16);
                            DOHRobot.this.log("Releasing shift");
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        DOHRobot.this.log("Press space");
                        DOHRobot.this.robot.keyPress(32);
                        DOHRobot.this.log("Release space");
                        DOHRobot.this.robot.keyRelease(32);
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        };
        threadPool.execute(runnable);
    }

    public void _initWheel(final double d) {
        this.log("> initWheel");
        Runnable runnable = new Runnable(){

            public void run() {
                if (!DOHRobot.this.isSecure(d)) {
                    return;
                }
                Thread.yield();
                DOHRobot.this.dir = 1;
                if (os.indexOf("MAC") != -1) {
                    int n;
                    String[] stringArray = "10.5.8".split("\\.");
                    int[] nArray = new int[3];
                    String[] stringArray2 = System.getProperty("os.version").split("\\.");
                    int[] nArray2 = new int[3];
                    for (n = 0; n < 3; ++n) {
                        nArray[n] = Integer.valueOf(stringArray[n]);
                        nArray2[n] = Integer.valueOf(stringArray2[n]);
                    }
                    n = !System.getProperty("os.version").equals("10.6.0") && !System.getProperty("os.version").equals("10.6.1") ? 1 : 0;
                    for (int i = 0; i < nArray.length && n != 0; ++i) {
                        if (nArray2[i] > nArray[i]) {
                            n = 1;
                            break;
                        }
                        if (nArray2[i] >= nArray[i]) continue;
                        n = 0;
                        break;
                    }
                    DOHRobot.this.dir = n != 0 ? DOHRobot.this.dir : -DOHRobot.this.dir;
                }
                DOHRobot.this.robot.mouseWheel(DOHRobot.this.dir);
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                DOHRobot.this.log("< initWheel");
            }
        };
        threadPool.execute(runnable);
    }

    public void _initKeyboard(final double d) {
        this.log("> initKeyboard");
        if (charMap != null) {
            this.dohrobot.call("_onKeyboard", new Object[0]);
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                if (!DOHRobot.this.isSecure(d)) {
                    return;
                }
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        int n;
                        charMap = new HashMap();
                        KeyEvent keyEvent = new KeyEvent(DOHRobot.this.applet(), 0, 0L, 0, 32, ' ');
                        charMap.put(new Integer(32), keyEvent);
                        try {
                            char c;
                            DOHRobot.this.vkKeys = new Vector();
                            for (c = 'a'; c <= 'z'; c = (char)(c + '\u0001')) {
                                DOHRobot.this.vkKeys.add(new Integer(KeyEvent.class.getField("VK_" + Character.toUpperCase(c)).getInt(null)));
                            }
                            for (c = '0'; c <= '9'; c = (char)(c + '\u0001')) {
                                DOHRobot.this.vkKeys.add(new Integer(KeyEvent.class.getField("VK_" + Character.toUpperCase(c)).getInt(null)));
                            }
                            int[] nArray = new int[]{44, 45, 46, 47, 59, 519, 520, 521, 522, 523, 517, 515, 514, 150, 151, 152, 153, 160, 161, 162, 513, 192, 222, 91, 92, 93, 61};
                            for (n = 0; n < nArray.length; ++n) {
                                DOHRobot.this.vkKeys.add(new Integer(nArray[n]));
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        DOHRobot.this.robot.setAutoDelay(1);
                        int n2 = 0;
                        n = 1;
                        do {
                            DOHRobot.this.log("Pressed space");
                            DOHRobot.this.robot.keyPress(32);
                            DOHRobot.this.robot.keyRelease(32);
                            n = ((Boolean)DOHRobot.this.window.eval("doh.robot._spaceReceived")).equals(Boolean.FALSE);
                            DOHRobot.this.log("JS still waiting on a space? " + (n != 0));
                        } while (++n2 < 500 && n != 0);
                        DOHRobot.this.robot.keyPress(10);
                        DOHRobot.this.robot.keyRelease(10);
                        DOHRobot.this.robot.setAutoDelay(0);
                        DOHRobot.this.log("< initKeyboard");
                        DOHRobot.this.pressNext();
                        return null;
                    }
                });
            }
        };
        threadPool.execute(runnable);
    }

    public void typeKey(double d, final int n, final int n2, final boolean bl, final boolean bl2, final boolean bl3, final boolean bl4, final int n3, final boolean bl5) {
        if (!this.isSecure(d)) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    DOHRobot.this.log("> typeKey Robot " + n + ", " + n2 + ", " + bl5);
                    KeyPressThread keyPressThread = new KeyPressThread(n, n2, bl, bl2, bl3, bl4, n3);
                    if (bl5) {
                        Thread thread = new Thread(keyPressThread);
                        thread.start();
                    } else {
                        threadPool.execute(keyPressThread);
                    }
                    DOHRobot.this.log("< typeKey Robot");
                }
                catch (Exception exception) {
                    DOHRobot.this.log("Error calling typeKey");
                    exception.printStackTrace();
                }
                return null;
            }
        });
    }

    public void upKey(double d, final int n, final int n2, final int n3) {
        if (!this.isSecure(d)) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                DOHRobot.this.log("> upKey Robot " + n + ", " + n2);
                KeyUpThread keyUpThread = new KeyUpThread(n, n2, n3);
                threadPool.execute(keyUpThread);
                DOHRobot.this.log("< upKey Robot");
                return null;
            }
        });
    }

    public void downKey(double d, final int n, final int n2, final int n3) {
        if (!this.isSecure(d)) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                DOHRobot.this.log("> downKey Robot " + n + ", " + n2);
                KeyDownThread keyDownThread = new KeyDownThread(n, n2, n3);
                threadPool.execute(keyDownThread);
                DOHRobot.this.log("< downKey Robot");
                return null;
            }
        });
    }

    public void pressMouse(double d, final boolean bl, final boolean bl2, final boolean bl3, final int n) {
        if (!this.isSecure(d)) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                DOHRobot.this.log("> mousePress Robot " + bl + ", " + bl2 + ", " + bl3);
                MousePressThread mousePressThread = new MousePressThread((bl ? 16 : 0) + (bl2 ? 8 : 0) + (bl3 ? 4 : 0), n);
                threadPool.execute(mousePressThread);
                DOHRobot.this.log("< mousePress Robot");
                return null;
            }
        });
    }

    public void releaseMouse(double d, final boolean bl, final boolean bl2, final boolean bl3, final int n) {
        if (!this.isSecure(d)) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                DOHRobot.this.log("> mouseRelease Robot " + bl + ", " + bl2 + ", " + bl3);
                MouseReleaseThread mouseReleaseThread = new MouseReleaseThread((bl ? 16 : 0) + (bl2 ? 8 : 0) + (bl3 ? 4 : 0), n);
                threadPool.execute(mouseReleaseThread);
                DOHRobot.this.log("< mouseRelease Robot");
                return null;
            }
        });
    }

    protected boolean destinationInView(int n, int n2) {
        return n <= this.docScreenXMax && n2 <= this.docScreenYMax && n >= this.docScreenX && n2 >= this.docScreenY;
    }

    public void moveMouse(double d, final int n, final int n2, final int n3, final int n4) {
        if (!this.isSecure(d)) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                int n5;
                int n22 = n + DOHRobot.this.docScreenX;
                if (!DOHRobot.this.destinationInView(n22, n5 = n2 + DOHRobot.this.docScreenY)) {
                    DOHRobot.this.log("Request to mouseMove denied");
                    return null;
                }
                int n32 = n3;
                DOHRobot.this.log("> mouseMove Robot " + n22 + ", " + n5);
                MouseMoveThread mouseMoveThread = new MouseMoveThread(n22, n5, n32, n4);
                threadPool.execute(mouseMoveThread);
                DOHRobot.this.log("< mouseMove Robot");
                return null;
            }
        });
    }

    public void wheelMouse(double d, final int n, final int n2, final int n3) {
        if (!this.isSecure(d)) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                MouseWheelThread mouseWheelThread = new MouseWheelThread(n, n2, n3);
                threadPool.execute(mouseWheelThread);
                return null;
            }
        });
    }

    private int getVKCode(int n, int n2) {
        int n3 = 0;
        if (n >= 32) {
            KeyEvent keyEvent = (KeyEvent)charMap.get(new Integer(n));
            n3 = keyEvent.getKeyCode();
        } else {
            switch (n2) {
                case 13: {
                    n3 = 10;
                    break;
                }
                case 8: {
                    n3 = 8;
                    break;
                }
                case 9: 
                case 25: {
                    n3 = 9;
                    break;
                }
                case 12: {
                    n3 = 12;
                    break;
                }
                case 16: {
                    n3 = 16;
                    break;
                }
                case 17: {
                    n3 = 17;
                    break;
                }
                case 18: {
                    n3 = 18;
                    break;
                }
                case 19: 
                case 63250: {
                    n3 = 19;
                    break;
                }
                case 20: {
                    n3 = 20;
                    break;
                }
                case 27: {
                    n3 = 27;
                    break;
                }
                case 32: {
                    this.log("it's a space");
                    n3 = 32;
                    break;
                }
                case 33: 
                case 63276: {
                    n3 = 33;
                    break;
                }
                case 34: 
                case 63277: {
                    n3 = 34;
                    break;
                }
                case 35: 
                case 63275: {
                    n3 = 35;
                    break;
                }
                case 36: 
                case 63273: {
                    n3 = 36;
                    break;
                }
                case 37: 
                case 63234: {
                    n3 = 37;
                    break;
                }
                case 38: 
                case 63232: {
                    n3 = 38;
                    break;
                }
                case 39: 
                case 63235: {
                    n3 = 39;
                    break;
                }
                case 40: 
                case 63233: {
                    n3 = 40;
                    break;
                }
                case 46: 
                case 63272: {
                    n3 = 127;
                    break;
                }
                case 91: 
                case 224: {
                    n3 = 157;
                    break;
                }
                case 144: 
                case 63289: {
                    n3 = 144;
                    break;
                }
                case 145: 
                case 63249: {
                    n3 = 145;
                    break;
                }
                case 112: 
                case 63236: {
                    n3 = 112;
                    break;
                }
                case 113: 
                case 63237: {
                    n3 = 113;
                    break;
                }
                case 114: 
                case 63238: {
                    n3 = 114;
                    break;
                }
                case 115: 
                case 63239: {
                    n3 = 115;
                    break;
                }
                case 116: 
                case 63240: {
                    n3 = 116;
                    break;
                }
                case 117: 
                case 63241: {
                    n3 = 117;
                    break;
                }
                case 118: 
                case 63242: {
                    n3 = 118;
                    break;
                }
                case 119: 
                case 63243: {
                    n3 = 119;
                    break;
                }
                case 120: 
                case 63244: {
                    n3 = 120;
                    break;
                }
                case 121: 
                case 63245: {
                    n3 = 121;
                    break;
                }
                case 122: 
                case 63246: {
                    n3 = 122;
                    break;
                }
                case 123: 
                case 63247: {
                    n3 = 123;
                    break;
                }
                case 124: {
                    n3 = 61440;
                    break;
                }
                case 125: {
                    n3 = 61441;
                    break;
                }
                case 126: {
                    n3 = 61442;
                    break;
                }
                case 45: 
                case 63302: {
                    n3 = 155;
                    break;
                }
                case 47: {
                    n3 = 156;
                    break;
                }
                default: {
                    n3 = n2;
                }
            }
        }
        this.log("Attempting to type " + (char)n + ":" + n + " " + n2);
        this.log("Converted to " + n3);
        return n3;
    }

    private boolean isUnsafe(int n) {
        this.log("ctrl: " + this.ctrl + ", alt: " + this.alt + ", shift: " + this.shift);
        if ((this.ctrl || this.alt) && n == 27 || this.alt && n == 9 || this.ctrl && this.alt && n == 127) {
            this.log("You are not allowed to press this key combination!");
            return true;
        }
        this.log("Safe to press.");
        return false;
    }

    private boolean disableNumlock(int n, boolean bl) {
        boolean bl2 = !this.numlockDisabled && bl && os.indexOf("WINDOWS") != -1 && toolkit.getLockingKeyState(144) && (n == 37 || n == 38 || n == 39 || n == 40 || n == 36 || n == 35 || n == 33 || n == 34);
        this.log("disable numlock: " + bl2);
        return bl2;
    }

    private void _typeKey(final int n, final int n2, final boolean bl, final boolean bl2, final boolean bl3, final boolean bl4) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                block20: {
                    int n4 = n;
                    int n22 = n2;
                    boolean bl7 = bl;
                    boolean bl22 = bl2;
                    boolean bl32 = bl3;
                    boolean bl42 = bl4;
                    boolean bl5 = false;
                    DOHRobot.this.log("> _typeKey Robot " + n4 + ", " + n22);
                    try {
                        int n3 = DOHRobot.this.getVKCode(n4, n22);
                        if (n4 >= 32) {
                            KeyEvent keyEvent = (KeyEvent)charMap.get(new Integer(n4));
                            if (!bl32) {
                                bl32 = keyEvent.isShiftDown();
                            }
                            bl5 = keyEvent.isAltGraphDown();
                            n3 = keyEvent.getKeyCode();
                        }
                        boolean bl6 = DOHRobot.this.disableNumlock(n3, bl32 || DOHRobot.this.applet().shift);
                        if (DOHRobot.this.isUnsafe(n3)) break block20;
                        if (bl32) {
                            DOHRobot.this.log("Pressing shift");
                            DOHRobot.this.robot.keyPress(16);
                        }
                        if (bl7) {
                            DOHRobot.this.log("Pressing alt");
                            DOHRobot.this.robot.keyPress(18);
                        }
                        if (bl5) {
                            DOHRobot.this.log("Pressing altgraph");
                            DOHRobot.this.robot.keyPress(65406);
                        }
                        if (bl22) {
                            DOHRobot.this.log("Pressing ctrl");
                            DOHRobot.this.robot.keyPress(17);
                        }
                        if (bl42) {
                            DOHRobot.this.log("Pressing meta");
                            DOHRobot.this.robot.keyPress(157);
                        }
                        if (bl6) {
                            DOHRobot.this.robot.keyPress(144);
                            DOHRobot.this.robot.keyRelease(144);
                            DOHRobot.this.numlockDisabled = true;
                        } else if (DOHRobot.this.numlockDisabled && !DOHRobot.this.applet().shift && !bl32) {
                            DOHRobot.this.robot.keyPress(144);
                            DOHRobot.this.robot.keyRelease(144);
                            DOHRobot.this.numlockDisabled = false;
                        }
                        if (n3 != 16 && n3 != 18 && n3 != 65406 && n3 != 17 && n3 != 157) {
                            try {
                                DOHRobot.this.robot.keyPress(n3);
                                DOHRobot.this.robot.keyRelease(n3);
                            }
                            catch (Exception exception) {
                                DOHRobot.this.log("Error while actually typing a key");
                                exception.printStackTrace();
                            }
                        }
                        if (bl22) {
                            DOHRobot.this.robot.keyRelease(17);
                            bl22 = false;
                        }
                        if (bl7) {
                            DOHRobot.this.robot.keyRelease(18);
                            bl7 = false;
                        }
                        if (bl5) {
                            DOHRobot.this.robot.keyRelease(65406);
                            bl5 = false;
                        }
                        if (bl32) {
                            DOHRobot.this.log("Releasing shift");
                            DOHRobot.this.robot.keyRelease(16);
                            bl32 = false;
                        }
                        if (bl42) {
                            DOHRobot.this.log("Releasing meta");
                            DOHRobot.this.robot.keyRelease(157);
                            bl42 = false;
                        }
                    }
                    catch (Exception exception) {
                        DOHRobot.this.log("Error in _typeKey");
                        exception.printStackTrace();
                    }
                }
                DOHRobot.this.log("< _typeKey Robot");
                return null;
            }
        });
    }

    public boolean hasFocus() {
        try {
            boolean bl = (Boolean)this.window.eval("var result=false;if(window.parent.document.hasFocus){result=window.parent.document.hasFocus();}else{result=true;}result;");
            if (!bl) {
                this.log("Document focus lost. Recomputing window position");
                Point point = this.getLocationOnScreen();
                this.log("Old root: " + this.docScreenX + " " + this.docScreenY);
                this.docScreenX = point.x - this.margin.x;
                this.docScreenY = point.y - this.margin.y;
                this.log("New root: " + this.docScreenX + " " + this.docScreenY);
                this.docScreenXMax = this.docScreenX + (Integer)this.window.eval("window.parent.document.getElementById('dohrobotview').offsetLeft");
                this.docScreenYMax = this.docScreenY + (Integer)this.window.eval("window.parent.document.getElementById('dohrobotview').offsetTop");
                this.window.eval("window.parent.focus();");
                return this.isSecure(this.key);
            }
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void setClipboardText(double d, final String string) {
        if (!this.isSecure(d)) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                StringSelection stringSelection = new StringSelection(string);
                DOHRobot.getSystemClipboard().setContents(stringSelection, stringSelection);
                return null;
            }
        });
    }

    public void setClipboardHtml(double d, final String string) {
        if (!this.isSecure(d)) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string2 = "text/html;class=java.lang.String";
                TextTransferable textTransferable = new TextTransferable(string2, string);
                DOHRobot.getSystemClipboard().setContents(textTransferable, textTransferable);
                return null;
            }
        });
    }

    private static Clipboard getSystemClipboard() {
        return toolkit.getSystemClipboard();
    }

    private static class TextTransferable
    implements Transferable,
    ClipboardOwner {
        private String data;
        private static ArrayList htmlFlavors = new ArrayList();

        public TextTransferable(String string, String string2) {
            this.data = string2;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return htmlFlavors.toArray(new DataFlavor[htmlFlavors.size()]);
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return htmlFlavors.contains(dataFlavor);
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (String.class.equals(dataFlavor.getRepresentationClass())) {
                return this.data;
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }

        public void lostOwnership(Clipboard clipboard, Transferable transferable) {
            this.data = null;
        }

        static {
            try {
                htmlFlavors.add(new DataFlavor("text/plain;charset=UTF-8;class=java.lang.String"));
                htmlFlavors.add(new DataFlavor("text/html;charset=UTF-8;class=java.lang.String"));
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
        }
    }

    private final class RobotSecurityManager
    extends SecurityManager {
        private boolean isActive = false;
        private boolean needsSecurityManager = false;
        private SecurityManager oldsecurity = null;

        public RobotSecurityManager(boolean bl, SecurityManager securityManager) {
            this.needsSecurityManager = bl;
            this.oldsecurity = securityManager;
        }

        public boolean checkTopLevelWindow(Object object) {
            if (object == null) {
                this.isActive = !this.isActive;
                DOHRobot.this.log("Active is now " + this.isActive);
            }
            return object == null ? true : this.oldsecurity.checkTopLevelWindow(object);
        }

        public void checkPermission(Permission permission) {
            if (this.isActive && this.needsSecurityManager && SocketPermission.class.isInstance(permission) && permission.getActions().matches(".*resolve.*")) {
                throw new SecurityException("DOH: liveconnect resolve locks up Safari 3. Denying resolve request.");
            }
            if (!permission.equals(new AWTPermission("watchMousePointer"))) {
                this.oldsecurity.checkPermission(permission);
            }
        }

        public void checkPermission(Permission permission, Object object) {
            this.checkPermission(permission);
        }
    }

    private final class MouseWheelThread
    extends ProfilingThread {
        private int amount;

        public MouseWheelThread(int n, int n2, int n3) {
            this.amount = n;
            this.delay = n2;
            this.duration = n3;
        }

        public void run() {
            try {
                Thread.sleep(this.delay);
                DOHRobot.this.log("> run MouseWheelThread " + this.amount);
                while (!DOHRobot.this.hasFocus()) {
                    Thread.sleep(1000L);
                }
                DOHRobot.this.robot.setAutoDelay(Math.max((int)this.duration / Math.abs(this.amount), 1));
                for (int i = 0; i < Math.abs(this.amount); ++i) {
                    DOHRobot.this.robot.mouseWheel(this.amount > 0 ? DOHRobot.this.dir : -DOHRobot.this.dir);
                }
                DOHRobot.this.robot.setAutoDelay(1);
            }
            catch (Exception exception) {
                DOHRobot.this.log("Bad parameters passed to mouseWheel");
                exception.printStackTrace();
            }
            DOHRobot.this.log("< run MouseWheelThread ");
        }
    }

    private final class MouseMoveThread
    extends ProfilingThread {
        private int x;
        private int y;

        public MouseMoveThread(int n, int n2, int n3, int n4) {
            this.x = n;
            this.y = n2;
            this.delay = n3;
            this.duration = n4;
        }

        public double easeInOutQuad(double d, double d2, double d3, double d4) {
            if ((d /= d4 / 2.0) < 1.0) {
                return d3 / 2.0 * d * d + d2;
            }
            return -d3 / 2.0 * ((d -= 1.0) * (d - 2.0) - 1.0) + d2;
        }

        public void run() {
            try {
                int n;
                Thread.sleep(this.delay);
                DOHRobot.this.log("> run MouseMoveThread " + this.x + ", " + this.y);
                while (!DOHRobot.this.hasFocus()) {
                    Thread.sleep(1000L);
                }
                int n2 = DOHRobot.this.lastMouseX;
                int n3 = this.x;
                int n4 = DOHRobot.this.lastMouseY;
                int n5 = this.y;
                if (n2 != n3) {
                    n = this.x - DOHRobot.this.lastMouseX;
                    if (n > 0) {
                        ++n2;
                        --n3;
                    } else {
                        --n2;
                        ++n3;
                    }
                }
                if (n4 != n5) {
                    n = this.y - DOHRobot.this.lastMouseY;
                    if (n > 0) {
                        ++n4;
                        --n5;
                    } else {
                        --n4;
                        ++n5;
                    }
                }
                DOHRobot.this.robot.setAutoWaitForIdle(false);
                n = this.duration == 1L ? 0 : (int)Math.ceil(Math.log(this.duration + 1L)) | 1;
                int n6 = (int)this.duration / (n + 1);
                DOHRobot.this.robot.mouseMove(DOHRobot.this.lastMouseX, DOHRobot.this.lastMouseY);
                DOHRobot.this.lastMouseX = n2;
                DOHRobot.this.lastMouseY = n4;
                int n7 = 0;
                for (int i = 0; i < n; ++i) {
                    long l = new Date().getTime();
                    Thread.sleep(n6);
                    n2 = (int)this.easeInOutQuad(i, DOHRobot.this.lastMouseX, (double)n3 - (double)DOHRobot.this.lastMouseX, (double)n - 1.0);
                    n4 = (int)this.easeInOutQuad(i, DOHRobot.this.lastMouseY, (double)n5 - (double)DOHRobot.this.lastMouseY, (double)n - 1.0);
                    DOHRobot.this.robot.mouseMove(n2, n4);
                    long l2 = new Date().getTime();
                    n7 = ((int)(l2 - l) - n6) / (n - i);
                    DOHRobot.this.log("mouseMove timing error: " + n7);
                    n6 = Math.max(n6 - n7, 1);
                }
                Thread.sleep(n6);
                DOHRobot.this.robot.mouseMove(this.x, this.y);
                DOHRobot.this.robot.setAutoWaitForIdle(true);
                DOHRobot.this.lastMouseX = this.x;
                DOHRobot.this.lastMouseY = this.y;
            }
            catch (Exception exception) {
                DOHRobot.this.log("Bad parameters passed to mouseMove");
                exception.printStackTrace();
            }
            DOHRobot.this.log("< run MouseMoveThread");
        }
    }

    private final class MouseReleaseThread
    extends ProfilingThread {
        private int mask;

        public MouseReleaseThread(int n, int n2) {
            this.mask = n;
            this.delay = n2;
        }

        public void run() {
            try {
                Thread.sleep(this.delay);
                DOHRobot.this.log("> run MouseReleaseThread ");
                while (!DOHRobot.this.hasFocus()) {
                    Thread.sleep(1000L);
                }
                DOHRobot.this.robot.mouseRelease(this.mask);
                DOHRobot.this.robot.waitForIdle();
            }
            catch (Exception exception) {
                DOHRobot.this.log("Bad parameters passed to mouseRelease");
                exception.printStackTrace();
            }
            DOHRobot.this.log("< run MouseReleaseThread ");
        }
    }

    private final class MousePressThread
    extends ProfilingThread {
        private int mask;

        public MousePressThread(int n, int n2) {
            this.mask = n;
            this.delay = n2;
        }

        public void run() {
            try {
                Thread.sleep(this.delay);
                DOHRobot.this.log("> run MousePressThread");
                while (!DOHRobot.this.hasFocus()) {
                    Thread.sleep(1000L);
                }
                DOHRobot.this.robot.mousePress(this.mask);
                DOHRobot.this.robot.waitForIdle();
            }
            catch (Exception exception) {
                DOHRobot.this.log("Bad parameters passed to mousePress");
                exception.printStackTrace();
            }
            DOHRobot.this.log("< run MousePressThread");
        }
    }

    private final class KeyUpThread
    extends ProfilingThread {
        private int charCode;
        private int keyCode;

        public KeyUpThread(int n, int n2, int n3) {
            DOHRobot.this.log("KeyUpThread constructor " + n + ", " + n2);
            this.charCode = n;
            this.keyCode = n2;
            this.delay = n3;
        }

        public void run() {
            try {
                Thread.sleep(this.delay);
                DOHRobot.this.log("> run KeyUpThread");
                while (!DOHRobot.this.hasFocus()) {
                    Thread.sleep(1000L);
                }
                int n = DOHRobot.this.getVKCode(this.charCode, this.keyCode);
                if (this.charCode >= 32) {
                    KeyEvent keyEvent = (KeyEvent)charMap.get(new Integer(this.charCode));
                    if (keyEvent.isShiftDown()) {
                        DOHRobot.this.robot.keyRelease(16);
                        DOHRobot.this.shift = false;
                    }
                    if (keyEvent.isAltGraphDown()) {
                        DOHRobot.this.robot.keyRelease(65406);
                        DOHRobot.this.altgraph = false;
                    }
                } else if (n == 18) {
                    DOHRobot.this.alt = false;
                } else if (n == 17) {
                    DOHRobot.this.ctrl = false;
                } else if (n == 16) {
                    DOHRobot.this.shift = false;
                    if (DOHRobot.this.numlockDisabled) {
                        DOHRobot.this.robot.keyPress(144);
                        DOHRobot.this.robot.keyRelease(144);
                        DOHRobot.this.numlockDisabled = false;
                    }
                } else if (n == 65406) {
                    DOHRobot.this.altgraph = false;
                } else if (n == 157) {
                    DOHRobot.this.meta = false;
                }
                DOHRobot.this.robot.keyRelease(n);
            }
            catch (Exception exception) {
                DOHRobot.this.log("Bad parameters passed to upKey");
                exception.printStackTrace();
            }
            DOHRobot.this.log("< run KeyUpThread");
        }
    }

    private final class KeyDownThread
    extends ProfilingThread {
        private int charCode;
        private int keyCode;

        public KeyDownThread(int n, int n2, int n3) {
            DOHRobot.this.log("KeyDownThread constructor " + n + ", " + n2);
            this.charCode = n;
            this.keyCode = n2;
            this.delay = n3;
        }

        public void run() {
            try {
                Thread.sleep(this.delay);
                DOHRobot.this.log("> run KeyDownThread");
                while (!DOHRobot.this.hasFocus()) {
                    Thread.sleep(1000L);
                }
                int n = DOHRobot.this.getVKCode(this.charCode, this.keyCode);
                if (this.charCode >= 32) {
                    KeyEvent keyEvent = (KeyEvent)charMap.get(new Integer(this.charCode));
                    if (keyEvent.isShiftDown()) {
                        DOHRobot.this.robot.keyPress(16);
                        DOHRobot.this.shift = true;
                    }
                    if (keyEvent.isAltGraphDown()) {
                        DOHRobot.this.robot.keyPress(65406);
                        DOHRobot.this.altgraph = true;
                    }
                } else if (n == 18) {
                    DOHRobot.this.alt = true;
                } else if (n == 17) {
                    DOHRobot.this.ctrl = true;
                } else if (n == 16) {
                    DOHRobot.this.shift = true;
                } else if (n == 65406) {
                    DOHRobot.this.altgraph = true;
                } else if (n == 157) {
                    DOHRobot.this.meta = true;
                } else if (DOHRobot.this.disableNumlock(n, DOHRobot.this.shift)) {
                    DOHRobot.this.robot.keyPress(144);
                    DOHRobot.this.robot.keyRelease(144);
                    DOHRobot.this.numlockDisabled = true;
                }
                if (!DOHRobot.this.isUnsafe(n)) {
                    DOHRobot.this.robot.keyPress(n);
                }
            }
            catch (Exception exception) {
                DOHRobot.this.log("Bad parameters passed to downKey");
                exception.printStackTrace();
            }
            DOHRobot.this.log("< run KeyDownThread");
        }
    }

    private final class KeyPressThread
    extends ProfilingThread {
        private int charCode;
        private int keyCode;
        private boolean alt;
        private boolean ctrl;
        private boolean shift;
        private boolean meta;

        public KeyPressThread(int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n3) {
            DOHRobot.this.log("KeyPressThread constructor " + n + ", " + n2);
            this.charCode = n;
            this.keyCode = n2;
            this.alt = bl;
            this.ctrl = bl2;
            this.shift = bl3;
            this.meta = bl4;
            this.delay = n3;
        }

        public void run() {
            try {
                this.startProfiling();
                while (!DOHRobot.this.hasFocus()) {
                    Thread.sleep(1000L);
                }
                Thread.sleep(this.delay);
                DOHRobot.this.log("> run KeyPressThread");
                DOHRobot.this._typeKey(this.charCode, this.keyCode, this.alt, this.ctrl, this.shift, this.meta);
                this.endProfiling();
            }
            catch (Exception exception) {
                DOHRobot.this.log("Bad parameters passed to _typeKey");
                exception.printStackTrace();
            }
            DOHRobot.this.log("< run KeyPressThread");
        }
    }

    private class ProfilingThread
    implements Runnable {
        protected long delay = 0L;
        protected long duration = 0L;
        private long start;
        private long oldDelay;

        private ProfilingThread() {
        }

        protected void startProfiling() {
            if (this.delay > 0L) {
                this.oldDelay = this.delay;
                this.delay -= DOHRobot.this.timingError + (this.duration > 0L ? DOHRobot.this.timingError : 0L);
                DOHRobot.this.log("Timing error: " + DOHRobot.this.timingError);
                if (this.delay < 1L) {
                    if (this.duration > 0L) {
                        this.duration = Math.max(this.duration + this.delay, 1L);
                    }
                    this.delay = 1L;
                }
                this.start = System.currentTimeMillis();
            } else {
                DOHRobot.this.timingError = 0L;
            }
        }

        protected void endProfiling() {
            if (this.delay > 0L) {
                long l = System.currentTimeMillis();
                DOHRobot.this.timingError += l - this.start - this.oldDelay;
            }
        }

        public void run() {
        }
    }

    private final class onvisible
    extends ComponentAdapter {
        private onvisible() {
        }

        public void componentShown(ComponentEvent componentEvent) {
            if (DOHRobot.this.key != -1.0) {
                return;
            }
            Thread thread = new Thread(){

                public void run() {
                    DOHRobot.this.log("Document root: ~" + DOHRobot.this.applet().getLocationOnScreen().toString());
                    DOHRobot.this.window = JSObject.getWindow((Applet)DOHRobot.this.applet());
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            DOHRobot.this.log("> init Robot");
                            try {
                                SecurityManager securityManager = System.getSecurityManager();
                                boolean bl = DOHRobot.this.applet().getParameter("needsSecurityManager").equals("true");
                                DOHRobot.this.log("Socket connections managed? " + bl);
                                try {
                                    DOHRobot.this.securitymanager = securityManager;
                                    DOHRobot.this.securitymanager.checkTopLevelWindow(null);
                                    if (charMap == null && !DOHRobot.this.confirm("DOH has detected that the current Web page is attempting to access DOH,\nbut belongs to a different domain than the one you agreed to let DOH automate.\nIf you did not intend to start a new DOH test by visiting this Web page,\npress Cancel now and leave the Web page.\nOtherwise, press OK to trust this domain to automate DOH tests.")) {
                                        this.stop();
                                        return null;
                                    }
                                    DOHRobot.this.log("Found old security manager");
                                }
                                catch (Exception exception) {
                                    DOHRobot.this.log("Making new security manager");
                                    DOHRobot.this.securitymanager = new RobotSecurityManager(bl, securityManager);
                                    DOHRobot.this.securitymanager.checkTopLevelWindow(null);
                                    System.setSecurityManager(DOHRobot.this.securitymanager);
                                }
                            }
                            catch (Exception exception) {
                                DOHRobot.this.log("Error calling _init_: " + exception.getMessage());
                                DOHRobot.this.key = -2.0;
                                exception.printStackTrace();
                            }
                            DOHRobot.this.log("< init Robot");
                            return null;
                        }
                    });
                    if (DOHRobot.this.key == -2.0) {
                        DOHRobot.this.window.eval("doh.robot._appletDead=true;doh.run();");
                    } else {
                        DOHRobot.this.log("_initRobot");
                        try {
                            DOHRobot.this.dohrobot = (JSObject)DOHRobot.this.window.eval("doh.robot");
                            DOHRobot.this.dohrobot.call("_initRobot", DOHRobot.this.applet());
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            };
            threadPool.execute(thread);
        }
    }
}

