<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet>
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns="http://www.w3.org/1999/xhtml">

  <xsl:template match="/">
    <html>
      <head>
        <link rel="stylesheet" type="text/css" href="./dnas-xmloutput.css" />
	<title><xsl:value-of select="/dnasml/meta/title"/></title>
      </head>
      <body>
	<h1><xsl:value-of select="/dnasml/meta/title"/></h1>
	<table>
	  <tr>
	    <td>Name</td>
	    <td>Load average </td>
	    <td>Memory usage</td>
	    <td>Memory number</td>
	    <td></td>
	    <td>Top process</td>
	    <td>Network send (eth0)</td>
	    <td>Network receive (eth0)</td>
	  </tr>
	  <xsl:for-each select="/dnasml/machinelist/machine">
	    <xsl:sort select="@machinename"/>
	    <xsl:element name="tr">
	      <xsl:element name="td"><xsl:value-of select="@machinename"/></xsl:element>
	      <xsl:element name="td">
		<xsl:attribute name="class">loadavgstyle</xsl:attribute>
		<xsl:element name="img">
		  <xsl:attribute name="src">gradationbox.png</xsl:attribute>
		  <xsl:attribute name="height">8</xsl:attribute>
		  <xsl:attribute name="width"><xsl:value-of select="load1 * 100.0"/></xsl:attribute>
		</xsl:element>
	      </xsl:element>

	      <xsl:element name="td">
		<xsl:attribute name="class">memstyle</xsl:attribute>
		<xsl:element name="img">
		  <xsl:attribute name="src">gradationbox.png</xsl:attribute>
		  <xsl:attribute name="height">8</xsl:attribute>
		  <xsl:attribute name="width"><xsl:value-of select="(( memused - membuffers - memcached ) div memtotal) * 100.0"/></xsl:attribute>
		</xsl:element>
		<xsl:element name="img">
		  <xsl:attribute name="src">gradationbackground.png</xsl:attribute>
		  <xsl:attribute name="height">8</xsl:attribute>
		  <xsl:attribute name="width"><xsl:value-of select="(1.0 - ( memused - membuffers - memcached ) div memtotal) * 100.0"/></xsl:attribute>
		</xsl:element>
	      </xsl:element>
	      <xsl:element name="td"><xsl:value-of select="memused"/>/<xsl:value-of select="memtotal"/></xsl:element>
	      <xsl:element name="td">
		<xsl:element name="img">
		  <xsl:attribute name="class">faceimage</xsl:attribute>
		  <xsl:attribute name="src">faceimage/<xsl:value-of select="topuser"/>.png</xsl:attribute>
		</xsl:element>
	      </xsl:element>
	      <xsl:element name="td"><xsl:value-of select="topprocess"/></xsl:element>
	    </xsl:element>
	  </xsl:for-each>
	</table>
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>
