/*
 *  dmachinemon / a distributed machine monitor by dancer.
 *  Copyright (C) 2001,2002 Junichi Uekawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Master node
 */
/* 
 * Master node for access. : port for nodes,  port for accessors.
 * 2001 June 9
 *  Junichi Uekawa
 * $Id: dmachinemon-master.c,v 1.29 2002/10/25 13:26:33 dancer Exp $
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <pthread.h>
#include "dmachinemon/libsocket.h"
#include "dmachinemon/dmachinemon-libdatabase.h"
#include "dmachinemon/dmachinemon-commandlineparser.h"
#include "dmachinemon/dmachinemon-servent-libroute.h"
#include "dmachinemon/dmachinemon-master.h"
#include "dmachinemon/dmachinemon-daemonize.h"
#include "config.h"


static int max_seen_by_depth = 0;
static dm_commandoption cdat;	/* the command data. */

static int 
handle_clients(void * data)
{				/* access from clients. */
  int t = ((struct dm_handle_incoming_params*)data)->t;
  FILE* f = (t!=-1)?fdopen(t, "w"):NULL;

  /* although this is suboptimal (depends on number of clients connecting) the 
   master node does not have a reliable clock (yeah, right). It should work fine ... 
   FIXME: dm_randomly_change_route_to should be called periodically in regular intervals
  */
  if (!f)
    {
      if (cdat.debuglevel) 
	{
	  fprintf (stderr, "Incoming handling file pointer is NULL in handle_clients/master\n");
	  if (t == -1)
	    fprintf (stderr, "t was -1 handle_clients/master\n");
	}
    }
  else
    {
      if (cdat.debuglevel > 3) fprintf (stderr, "DEBUG: master node is running Randomly-change-route-to.\n");

      if (!cdat.downlink_static)
	dm_randomly_change_route_to (&maininfo, &cdat);
      master_send_info_to_client (f, &maininfo, 0, max_seen_by_depth, &cdat); /* clear the info./ no. it will remove a lot of info. */
      fclose(f);
    }
  dm_tcp_free_incoming_params(data);
  return 0;  
}

static int
handle_nodes(void * data)
{				/* access from nodes. */
  int t = ( (struct dm_handle_incoming_params*) data )->t;
  FILE*f;
  int return_code;

  dm_send_route(t, &cdat);

  f = (t!=-1)?fdopen(t, "w+"):NULL;

  if (f)
    {
      return_code = dm_process_nodes_input (f, &maininfo, NULL, NULL);
      fclose(f);
    }
  else
    {
      if (cdat.debuglevel) 
	{
	  fprintf (stderr, "Incoming handling file pointer is NULL in handle_nodes/master\n");
	  if (t == -1)
	    fprintf (stderr, "t was -1 handle_clients/master\n");
	}
      return_code = 1;
    }
  
  dm_tcp_free_incoming_params(data);
  return return_code;
}

static void 
tcphosts(void * parameter)
{
  if (1 == dm_tcp_host_setup("dmachinemon-master", (char*)parameter,
			     (void * )handle_nodes))
    {				/* error handle */
      exit (1);
    }
}

int main(int ac, char ** av)
{
  pthread_t thread;

  dmachinemon_parse_options(ac, av, &cdat);
  max_seen_by_depth = cdat.number_of_hosts_of_seenby;
  
  fprintf (stderr, "dmachinemon-master v. %s starting\n", VERSION);

  dm_daemonize(&cdat);

  pthread_create(&thread, NULL, (void*)tcphosts, cdat.port_nodes);
  if (1==dm_tcp_host_setup("dmachinemon-master", cdat.port_client,
			   (void * )handle_clients))
    {				/* error handle */
      exit (1);
    }

  
  return 0;  
}

/* 

What follows is a m4 script!
MANUAL([.TH "dmachinemon-master" 1 "2001 July 17" "Debian-beowulf" "dmachinemon manual"
.SH "NAME"
dmachinemon-master \- master server program for storing machine status
.SH "SYNOPSIS"
.BI "dmachinemon-master [" "options" "]"
.SH "DESCRIPTION"
A master node for 
.B "dmachinemon"
system, holding the status of all machines, and 
accepting information from nodes.
It will accept connection from the clients on the specified port,
and send out the information received from nodes.
.SH "OPTIONS"
] m4_include([dmachinemon-commandlineparser.inc]) COMMAND [
.SH "NOTES"
This software might be a security risk. 
This is the weakest part of dmachinemon system.
.PP
.B "execute_dmachinemon"
is an easier interface to this software.
.SH "AUTHOR"
Junichi Uekawa <dancer@mikilab.doshisha.ac.jp> <dancer@debian.org> <dancer@netfort.gr.jp>

This manual page is autogenerated from dmachinemon-master.c and 
dmachinemon-commandlineparser.c
.SH "SEE ALSO"
.RI "dmachinemon-servent(" 1 "), "
.RI "dmachinemon-gtkiface(" 1 "), "
.RI "dmachinemon-htmoutput(" 1 ")"

]) */
