/*
 *  dmachinemon / a distributed machine monitor by dancer.
 *  Copyright (C) 2001 Junichi Uekawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * individual machines in the cluster.
 */
/* 
 * command-options: serverip serverport time-interval
 * 2001 Jun 9
 *  Junichi Uekawa
 * $Id: dmachinemon-node.c,v 1.4 2001/11/22 08:57:06 dancer Exp $
 *
 * This software is possibly outdated, and no longer maintained.
 *
 * This program is obsoleted: 22 Nov 2001.
 */
/* Derived from : 
 * nantarad client... obtains information from nantarad, and returns 
 * the value obtained to stdout and exit value.
 * on error, returns EXIT_FAILURE on normal failure, and -1 on 
 * more obscure failures.
 *
 * originally a Telnet clone which does little input/output cooking.
 * 2001 Feb 28 Junichi Uekawa <dancer@debian.org>
 * 2001 Mar 4 Junichi Uekawa <dancer@debian.org> reuse for nantaraclient
 * copyright 2001 Junichi Uekawa
 * See GPL version 2 or later for license.
 */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <pthread.h>
#include <time.h>
#include "dmachinemon/libsocket.h"
#include "dmachinemon/dmachinemon-libnodeinfo.h"

static const int MAXRETRIES=100;

static int timesleep;


static void do_main_loop (int socket)
{
  FILE* f = fdopen(socket, "w");
  
  while (1)
    {
      dm_nodeinfo_write_out(f);
      usleep(1000000 * timesleep);
    } 
  
  fclose(f);
}

int main (int ac, char ** av)
{
  int socket ;
  int retries = 0;
    
  if (ac != 4)
    {
      fprintf(stderr, 
	      "dmachinemon-node by Junichi Uekawa <dancer@debian.org>\n"
	      "Copyright 2001 Junichi Uekawa\n"
	      "See GNU Public License version 2 or later for license\n"
	      "Please give the network address, and the port number and interval in seconds\n");
      exit (EXIT_FAILURE);
    }

  timesleep = atol(av[3]);  

  while (-1 == (socket = dm_connect_to_host (av[1], atoi(av[2]))))
    {
      if (retries ++ > MAXRETRIES)
	{
          fprintf(stderr, "Connection failed, max retry count reached... \n");
	  exit (EXIT_FAILURE) ; 
        }
      fprintf (stderr, "Connection failed, retrying... \n");
      usleep (1000000 * 5);
    }
  do_main_loop(socket);  
  exit (EXIT_SUCCESS);
}
