#ifndef _EFFECT_H_INCLUDED
#define _EFFECT_H_INCLUDED

class Effect;

class EffectChannel
{
public:
	EffectChannel(Effect *e, unsigned long in_port, unsigned long out_port);
	EffectChannel(EffectChannel *c, Effect *e, unsigned long in_port, unsigned long out_port);
	virtual ~EffectChannel();

	virtual void setBuffer(float *buffer);
protected:
	virtual void process(unsigned long nsamples);
	Effect *e_effect;
	bool e_slave;

	friend class Effect;
};

class Effect
{
public:
	Effect();
	virtual ~Effect();
	
	virtual unsigned long ports();
	virtual void setControl(unsigned long port, float data);
	virtual float control(unsigned long port);
	virtual void process(unsigned long nsamples);

	virtual EffectChannel *left();
	virtual EffectChannel *right();
protected:
	EffectChannel *e_left;
	EffectChannel *e_right;
	unsigned long e_srate;

	friend class EffectChannel;
};

#endif
