#include "dragsort.h"

#include <stdio.h>
#include <qtimer.h>

DragSortList::DragSortList(QWidget *parent, const char *name, WFlags f) : QListView(parent, name, f)
{
	scrolling=false;
	mouse_down=false;
	scroll_timer=new QTimer(this);
	connect(scroll_timer, SIGNAL(timeout()), this, SLOT(scrollTimeout()));
	setSorting(-1, true);
}

DragSortList::~DragSortList()
{
}

void DragSortList::contentsMousePressEvent ( QMouseEvent * e )
{
	if(e->button() == LeftButton)
	{
		click_pos=e->pos();
		mouse_down=true;
		click_item=itemAt(contentsToViewport(e->pos()));
	}

	QListView::contentsMousePressEvent(e);
}

void DragSortList::contentsMouseReleaseEvent ( QMouseEvent * e )
{
	if(e->button() == LeftButton && mouse_down)
	{
		mouse_down=false;
		if(scrolling)
		{
			scroll_timer->stop();
			scrolling=false;
		}
		QMouseEvent ef(e->type(), click_pos, e->button(), e->state());
		QListView::contentsMouseReleaseEvent(&ef);
		return;
	}
	QListView::contentsMouseReleaseEvent(e);
}

void DragSortList::contentsMouseMoveEvent ( QMouseEvent * e )
{
	if(mouse_down)
	{
		if(!click_item)
			return;
		
		if(contentsToViewport(e->pos()).y() < 0)
		{
			scroll_down=false;
			if(!scrolling)
			{
				scrollTimeout();
				scroll_timer->start(100);
			}
			scrolling=true;
		}
		else if(contentsToViewport(e->pos()).y() > viewport()->height())
		{
			scroll_down=true;
			if(!scrolling)
			{
				scrollTimeout();
				scroll_timer->start(100);
			}
			scrolling=true;
		}
		else
		{
			if(scrolling)
			{
				scroll_timer->stop();
				scrolling=false;
			}
			QListViewItem *cur_item=itemAt(contentsToViewport(e->pos()));
			if(cur_item && cur_item != click_item)
			{
				if(cur_item->itemAbove() == click_item)
					click_item->moveItem(cur_item);
				else
				{
					if(cur_item->itemAbove() == NULL)
						cur_item->moveItem(click_item);
					else
						click_item->moveItem(cur_item->itemAbove());
				}
			}
			ensureItemVisible(click_item);
		}
		return;
	}
	QListView::contentsMouseMoveEvent(e);
}

void DragSortList::scrollTimeout()
{
	if(scroll_down)
	{
//		verticalScrollBar()->addLine();
		if(click_item->itemBelow())
		{
			click_item->moveItem(click_item->itemBelow());
			ensureItemVisible(click_item);
		}
	}
	else
	{
//		verticalScrollBar()->subtractLine();
		QListViewItem *a=click_item->itemAbove();
		if(a)
		{
			if(a->itemAbove())
				click_item->moveItem(a->itemAbove());
			else
				a->moveItem(click_item);
			ensureItemVisible(click_item);
		}
	}
}
