/*
 * diehard_operm5 test header.
 */

/*
 * function prototype
 */
void diehard_operm5(Test **test, int irun);

static Dtest diehard_operm5_dtest = {
  "Diehard OPERM5 Test",
"\n\
#==================================================================\n\
#          Diehard Overlapping 5-Permutations Test.\n\
# This is the OPERM5 test.  It looks at a sequence of one mill- \n\
# ion 32-bit random integers.  Each set of five consecutive     \n\
# integers can be in one of 120 states, for the 5! possible or- \n\
# derings of five numbers.  Thus the 5th, 6th, 7th,...numbers   \n\
# each provide a state. As many thousands of state transitions  \n\
# are observed,  cumulative counts are made of the number of    \n\
# occurences of each state.  Then the quadratic form in the     \n\
# weak inverse of the 120x120 covariance matrix yields a test   \n\
# equivalent to the likelihood ratio test that the 120 cell     \n\
# counts came from the specified (asymptotically) normal dis-   \n\
# tribution with the specified 120x120 covariance matrix (with  \n\
# rank 99).  This version uses 1,000,000 integers, twice.       \n\
#\n\
# Note that Dieharder runs the test 100 times, not twice, by\n\
# default.\n\
#\n\
# WARNING! This test currently fails ALL RNGs including ones that\n\
# are strongly believed to be \"good\" ones (that pass the other \n\
# dieharder tests).  DO NOT USE THIS TEST TO ASSESS RNGs!  It very\n\
# likely contains either implementation bugs or incorrect data used\n\
# to compute the test statistic.  rgb\n\
#==================================================================\n",
  100,
  1000000,
  1
};

/*
 *========================================================================
 * R and S data ported from diehard and put into C-style matrix form
 *========================================================================
 */
static int r[60][60] = {
  {    5817257,   -6873271,   -5128747,   -5402629,     777663,     980677,    2407731,    2347927,    2954082,    2749952,    2512448,    3103860,    2631372,    1019585,    5833700,   -1609797,    -136098,      14746,    4199803,   15820046,   15661640,    5888319,   -3837421,   -1317810,    -375269,    -496546,     149397,      21483,    -341148,     314595,    2772502,     843578,    8843654,   -1211426,    2341534,    3013752,    1250340,    -699051,    -654566,     961558,   -2338987,   -2621631,    2873613,    1261792,    8000951,   -1746067,       6638,     -47636,   -5088578,   -5013620,   -3253847,   -3180615,    2711412,    3844202,     880534,   -1042552,    6946781,   -3015244,     406795,    1147260},
  {   -6873271,    5940872,   -5186478,   -5307926,     773214,     938192,    2462991,    2185748,    2756969,    2860993,    2501911,    3080424,    2695718,    1101077,    7899915,   -3833937,    -175045,     -54950,    6072206,   13434946,   15661640,    5768163,   -3875391,   -1169953,    -292941,    -536013,     124632,      45505,    -337415,     265604,    2721922,     823928,    8523149,   -1017852,    2281795,    2999166,    1218871,    -700064,    -634661,     957048,   -2629675,   -2235002,    2733295,    1136430,    7885100,   -1626583,     -58766,     124832,   -4795309,   -5249849,   -3154841,   -3094350,    2642865,    3795316,     872576,   -1015702,    6779035,   -2926770,     386412,    1127795},
  {   -5128747,   -5186478,   12208259,    1266547,   -1384963,   -1449671,   -3169754,   -1595651,   -1946939,   -1940155,   -3378061,   -3782485,   -1922633,   -1103400,   -4529238,    1922627,      67943,    -594084,   -4436559,  -10716612,  -12948181,   -3099354,    3086687,     741196,     127286,     909813,     551771,     418521,    -174949,    -545067,   -1869313,    -876135,   -7345496,     178672,   -2378999,   -2769171,   -1090475,     331067,     236296,    -551403,    2892697,    2810799,   -2367546,   -1617469,   -4838379,    1451362,    -568191,     978772,     574172,    2759542,     386836,    3123220,   -1235398,   -2188412,    -119033,     987303,   -5601207,    1946655,    -583034,   -1102184},
  {   -5402629,   -5307926,    1266547,   12576469,   -1912105,   -1491496,   -1977361,   -3787433,   -3866431,   -3931068,   -2169174,   -2042830,   -2367628,   -1217010,   -5574861,    2386416,    -567819,     399012,   -5292193,  -13303845,  -13360923,   -5639180,    3651213,    1466137,     880935,    -148585,    -363477,    -353888,     618037,     631948,   -2599440,   -1019748,   -8865897,     687501,   -2968293,   -3124000,   -1089813,     119334,     419444,    -786927,    3367082,    3316348,   -2961598,   -1738843,   -6050705,    1707414,     789397,    -308316,    1178460,    3734616,    3617835,    1360963,   -2307922,   -2689133,    -407480,    1067944,   -6848988,    2699162,    -925197,   -1068995},
  {     777663,     773214,   -1384963,   -1912105,   11788007,    1145706,    1193936,     968826,    3495027,    3575638,    1116536,    3617330,    3145167,     110228,    7883910,   -2325769,     103020,    -580856,    7068780,   17106824,   17369039,    5744570,   -6152687,    -983990,    -364426,    -482051,     205432,     171091,    -512242,     192023,    3244057,    1864653,   11153794,    -125218,    2622003,    3388711,    1601939,    -856517,    -817212,     825017,   -3038222,   -2961270,    3416768,    2474327,    8116870,   -1917663,     572557,    -258900,   -3200854,   -5353978,   -3054952,   -4014445,     410478,    3983005,    1088413,   -1375640,    8044077,   -3289536,     441887,    1325474},
  {     980677,     938192,   -1449671,   -1491496,    1145706,   12630118,    3156565,    3488013,    1910767,    1992878,    2735849,    1745194,    2635085,    1072076,    9179053,   -2371600,    -331321,    -726418,    7681229,   19285416,   19432752,    6482845,   -4523253,   -3272693,    -597204,    -336131,     -60141,     313513,    -626813,     170991,    4236377,    1050429,   11461421,   -1234081,    3788310,    4585317,    1236864,    -894703,   -1197329,    1736061,   -3427987,   -3398261,    5012230,    1426003,    9463295,   -1841304,     154862,    -198796,   -3804025,   -5955104,   -4195634,   -4485277,    2898985,    1978361,    1142239,    -988737,    9409193,   -3205744,     894517,    1606478},
  {    2407731,    2462991,   -3169754,   -1977361,    1193936,    3156565,    7707161,   -3210627,   -1751105,   -1898045,   -4862023,   -3470391,   -2214791,    -164614,   -5625407,    1704720,    -162789,    1058901,   -4040265,  -11094051,  -11240782,   -4277352,    3075254,    1065447,     234919,    -912108,     650889,     150505,      89522,    -509848,   -1766909,     277069,   -7775749,    1180521,   -1906123,   -2596068,    -578000,     357487,     367605,    -646039,    2484350,    2560723,   -2311007,    -195134,   -5880504,    1481832,    -645252,     765355,    2637470,    2458334,     907216,    2880116,   -2988096,   -1995274,    -783123,     393286,   -5564831,    1655303,    -297358,   -1033184},
  {    2347927,    2185748,   -1595651,   -3787433,     968826,    3488013,   -3210627,    7473799,   -3528010,   -3376497,   -3304459,   -1503292,   -2411204,      89031,   -5943125,    1917870,    1311823,    -122953,   -4332928,  -11706073,  -11653524,   -3963993,    3185910,    1308114,   -1090325,     -48253,    -510843,    -290876,    1024800,     623728,   -1974078,     169173,   -6030119,    -477907,   -2291701,   -2499215,    -533396,     449148,     352872,    -885457,    2684378,    2523291,   -2661828,    -154622,   -6156614,    1638839,     973738,    -705099,    2787313,    2932584,    3357426,    1068284,   -3746916,   -2087932,    -673963,     -44993,   -5854907,    2108010,    -584389,    -737864},
  {    2954082,    2756969,   -1946939,   -3866431,    3495027,    1910767,   -1751105,   -3528010,    7674168,   -5061376,   -1170678,   -3391201,   -1173129,    -624707,   -4576847,    1695880,     476307,    -158287,   -3332444,   -9534973,   -9589812,   -3359207,    2586819,     946168,     852391,    -121459,    -417820,    -187145,    -994183,     727155,   -1116115,    -339665,   -5873899,     366444,    -529818,   -3127321,    -861888,     762433,     675088,    -804551,    2122875,    2007541,   -1390150,    -899468,   -4708544,    1257097,     336976,    -271853,    2382850,    2263714,    2150539,     755793,    -943518,   -3487005,    -942169,     853872,   -5023503,    1542516,    -396522,    -857101},
  {    2749952,    2860993,   -1940155,   -3931068,    3575638,    1992878,   -1898045,   -3376497,   -5061376,    7676071,   -1157770,   -3401474,   -1256009,    -647207,   -4486485,    1690858,     608305,    -257057,   -3350870,   -9555891,   -9589812,   -3250732,    2572294,     948690,     646779,      76395,    -432195,    -170690,    1147802,   -1408811,   -1083128,    -383340,   -5876692,     381082,   -2650521,    -978117,    -962546,     746717,     749606,    -760829,    2024721,    2095214,   -1355683,    -815464,   -5012953,    1493020,     421631,    -389564,    2325617,    2413194,    2271141,     678383,   -1024047,   -3555556,    -851184,     779183,   -4684921,    1214615,    -415255,    -854396},
  {    2512448,    2501911,   -3378061,   -2169174,    1116536,    2735849,   -4862023,   -3304459,   -1170678,   -1157770,    8064414,   -3701394,   -2310077,     287117,   -5317816,    1555682,     130010,     978906,   -4169702,  -11195194,  -11240782,   -4157808,    3204649,    1299856,     130348,    1033123,   -1142203,     701920,     -27570,    -660547,   -1635451,   -1672910,   -5915594,    1031074,   -1979946,   -2368771,    -664404,     614133,     645425,   -1082134,    2441715,    2443669,   -2964969,    -100626,   -5598599,    1199646,    -218183,     621491,    2897493,    2894383,    1396294,    3009586,   -3031303,   -2134450,    -403409,     839727,   -5502336,    1239352,   -1319653,   -1327582},
  {    3103860,    3080424,   -3782485,   -2042830,    3617330,    1745194,   -3470391,   -1503292,   -3391201,   -3401474,   -3701394,    7209204,    -664777,    -850019,   -3914508,    1380687,    -396598,     882119,   -3458436,   -9122862,   -9177070,   -3454519,    2713532,    1139070,      -9605,    1098575,     766756,   -1302001,    -282375,    -582102,   -2863014,    -392040,   -5742588,      66937,    -664050,   -1225271,   -1034744,     544433,     606184,    -476333,    2033048,    2032012,   -1039768,   -1543121,   -4192878,    1227365,    -664222,     753326,    2349673,    2331917,     192786,    2496085,    -814587,   -3847450,    -315744,    1314137,   -4125681,    1287673,    -515796,   -1501943},
  {    2631372,    2695718,   -1922633,   -2367628,    3145167,    2635085,   -2214791,   -2411204,   -1173129,   -1256009,   -2310077,    -664777,    9788325,     207618,     816655,    -768078,   -1874570,   -1613116,     235288,    1694932,    1621948,     377883,    -507902,    -243766,     773939,     679052,     391398,      78143,      70943,     516176,   -2961954,     104444,     936801,     186178,    -971859,   -1257559,     238423,     462669,     670075,     314213,    -672481,    -566615,   -1309880,   -1073728,    1594210,     361560,     472243,     414552,    -597724,    -260047,    -772016,    -887315,     216603,    1073384,   -1323896,    -231085,     509060,    -359227,     499417,     197952},
  {    1019585,    1101077,   -1103400,   -1217010,     110228,    1072076,    -164614,      89031,    -624707,    -647207,     287117,    -850019,     207618,    9689335,     704290,   -2495107,    -343154,    -545326,    1594815,    4764261,    4694945,    1741823,    -997869,    -298676,    -333203,    -157564,     218154,     283497,     127218,    -147690,     764431,   -2838739,    1284848,   -1411175,     796176,    1142228,     598938,    -102712,      48775,    1098536,   -1137672,   -1030484,    -190599,   -1133802,    2347281,    -484327,     960682,     908055,   -1281146,    -997818,   -1308632,   -1286716,    1401975,     747166,     -70699,   -1684165,    2374406,    -334264,    -130586,     172260},
  {    5833700,    7899915,   -4529238,   -5574861,    7883910,    9179053,   -5625407,   -5943125,   -4576847,   -4486485,   -5317816,   -3914508,     816655,     704290,   12856576,   -3650442,    -153223,    -509349,    2984690,    6258554,    6402344,     758796,   -1671327,    -526914,        472,    -173308,     381688,    -160284,      71948,     598991,    1047898,   -1081349,    5230227,     283473,     949081,    1517248,    1102581,    -184126,    -184437,    1235250,   -2015041,   -1859118,    2256388,     834088,    2086134,    -801538,    -649920,    1155134,    -692225,   -1974792,   -1934348,   -2169637,     884616,    1606568,      60140,   -2105033,    4180691,    -919229,     -60329,     382106},
  {   -1609797,   -3833937,    1922627,    2386416,   -2325769,   -2371600,    1704720,    1917870,    1695880,    1690858,    1555682,    1380687,    -768078,   -2495107,   -3650442,   16061715,     284740,     738712,  -15990290,  -39765302,  -39992484,  -13609368,    9753282,    2972046,     156313,     398252,    -793746,     -90924,     240150,    -692225,   -6722501,   -3772274,  -23064086,    2458558,   -6920292,   -7778422,   -2161491,    1501233,    1325224,   -2446757,    7918006,    7606452,   -6908594,   -2985205,  -19436137,    4164401,     147843,   -1345055,    8477804,    9636350,    9222882,    9766063,   -6790882,   -8657391,   -2361496,     460093,  -18777173,    6979470,   -2385573,   -3107404},
  {    -136098,    -175045,      67943,    -567819,     103020,    -331321,    -162789,    1311823,     476307,     608305,     130010,    -396598,   -1874570,    -343154,    -153223,     284740,    8943975,   -1726046,   -4422865,  -11965780,  -11979204,   -4298851,    3162346,    1105638,   -1701684,     969212,    -119091,      -9373,   -1028843,   -1922549,   -3197247,    -773590,   -6887291,     370210,    -890213,   -1733307,    -744361,     921020,     773952,    -860450,    2177367,    2171512,   -1578001,      82087,   -6649715,    2701955,   -2078191,    -154198,    2614010,    2515825,    2606238,    3755822,   -2042299,   -3216470,   -2271286,     202674,   -5822175,    1364777,      91778,    -759997},
  {      14746,     -54950,    -594084,     399012,    -580856,    -726418,    1058901,    -122953,    -158287,    -257057,     978906,     882119,   -1613116,    -545326,    -509349,     738712,   -1726046,    9279076,   -4122768,  -12397404,  -12391946,   -4508748,    3316732,    1261182,     601366,   -1733920,   -1652447,   -1685738,     458865,     205135,   -3458419,    -842673,   -6972261,     527616,   -1230943,   -1544141,    -784368,     985452,     885839,   -1107901,    2315732,    2157857,   -1772253,      29449,   -5009984,     946688,    -309783,   -1779855,    2773685,    2303574,    3556282,    2884208,   -2088659,   -2834284,   -2541311,     179041,   -5926123,    1727548,    -243610,    -508396},
  {    4199803,    6072206,   -4436559,   -5292193,    7068780,    7681229,   -4040265,   -4332928,   -3332444,   -3350870,   -4169702,   -3458436,     235288,    1594815,    2984690,  -15990290,   -4422865,   -4122768,    -169515,  -28616431,  -28456656,   -8272206,    5944023,    1391497,     485357,     302324,    -110825,    -524670,    -196731,    -977499,   -4449426,   -1278290,  -17503766,    1839778,   -4409581,   -5168434,   -1911570,    1277831,    1087315,   -2245147,    5878400,    5664632,   -5254766,   -2052598,  -12525819,    2249452,    -760678,    -200644,    5096033,    7585065,    6981948,    5551021,   -4598968,   -6184469,   -1312378,    1910194,  -14358844,    4952535,   -1312334,   -2111121},
  {   15820046,   13434946,  -10716612,  -13303845,   17106824,   19285416,  -11094051,  -11706073,   -9534973,   -9555891,  -11195194,   -9122862,    1694932,    4764261,    6258554,  -39765302,  -11965780,  -12397404,  -28616431,   30614535,   17938173,    6069703,   -5141440,   -2452230,    -103399,    -496191,     122684,     393306,      -3324,     566726,    3441613,    1599877,   10965699,    -524256,    3387788,    3919040,    1422213,    -446145,    -526119,    1510412,   -3928170,   -3932323,    3871650,    1934802,    8916034,   -2690702,     481386,     192736,   -4163786,   -3890368,   -6141496,   -4425174,    3039163,    4071256,    1008284,    -859215,    8542837,   -2865634,    1060847,    1616493},
  {   15661640,   15661640,  -12948181,  -13360923,   17369039,   19432752,  -11240782,  -11653524,   -9589812,   -9589812,  -11240782,   -9177070,    1621948,    4694945,    6402344,  -39992484,  -11979204,  -12391946,  -28456656,   17938173,   17938173,     996719,   -2434152,     932374,     -96427,    -220179,     -58991,     238588,     118573,     324122,    1231670,     777902,    3346342,    -205884,    1209513,    1379528,     452829,    -128851,      99329,     589815,   -1361698,   -1180023,    1389694,     949257,    2644065,   -1080600,     338992,    -127446,   -1231583,   -2950726,    -956807,   -1519733,     628094,    1443407,     427124,     -92232,    2537576,    -990861,     413479,     652123},
  {    5888319,    5768163,   -3099354,   -5639180,    5744570,    6482845,   -4277352,   -3963993,   -3359207,   -3250732,   -4157808,   -3454519,     377883,    1741823,     758796,  -13609368,   -4298851,   -4508748,   -8272206,    6069703,     996719,    -471422,    6195991,    1113967,     149453,     586130,    -240462,    -399150,    -155398,    -961888,   -4449688,   -1287357,  -15294819,    -325756,   -4396733,   -5152212,   -2127711,    1175047,    1191243,   -2026174,    5763885,    5756828,   -5394757,   -2209287,  -15074258,    4780945,    -306775,    -304869,    6116930,    5044574,    5755905,    5855058,   -3347241,   -5023645,   -1292896,    1911983,  -12155731,    2753977,   -1306931,   -2119034},
  {   -3837421,   -3875391,    3086687,    3651213,   -6152687,   -4523253,    3075254,    3185910,    2586819,    2572294,    3204649,    2713532,    -507902,    -997869,   -1671327,    9753282,    3162346,    3316732,    5944023,   -5141440,   -2434152,    6195991,   30596457,    5128965,     754357,     967489,    -977486,   -1008316,     643303,   -1400440,  -12958386,   -4650101,  -44458241,    1661554,  -12902311,  -14956077,   -5499032,    2838837,    2653009,   -5547818,   15749833,   15441678,  -14780057,   -6668242,  -36591537,    9732117,   -1394283,    -684778,   17053686,   16846975,   16925457,   17740069,  -10816408,  -17150081,   -3704620,    4622406,  -35229968,   10987703,   -3590848,   -5669752},
  {   -1317810,   -1169953,     741196,    1466137,    -983990,   -3272693,    1065447,    1308114,     946168,     948690,    1299856,    1139070,    -243766,    -298676,    -526914,    2972046,    1105638,    1261182,    1391497,   -2452230,     932374,    1113967,    5128965,   17938173,     654583,    1067326,    -996386,    -996386,     654583,   -1409128,  -13004611,   -4694945,  -44687429,    1707399,  -12946569,  -15010281,   -5549450,    2760215,    2760215,   -5549450,   15661640,   15661640,  -14868401,   -6558735,  -36722790,    9672038,   -1267248,    -854505,   17073993,   17073993,   17227159,   17639902,  -13090061,  -15153773,   -3685660,    4624005,  -35368479,   11026349,   -3627619,   -5691331},
  {    -375269,    -292941,     127286,     880935,    -364426,    -597204,     234919,   -1090325,     852391,     646779,     130348,      -9605,     773939,    -333203,        472,     156313,   -1701684,     601366,     485357,    -103399,     -96427,     149453,     754357,     654583,    9631898,   -1482633,      54818,     -22922,   -3162578,   -1646591,   -1985126,   -1181733,   -7097260,     453277,   -3345419,   -1996393,    -812280,     784881,     857171,    -502614,    2435906,    2422919,   -1673523,   -1532476,   -5928779,    1352122,   -1765015,     288456,    2407858,    2242905,    2337000,    3499857,   -1642341,   -2653975,    -104749,    1590181,   -6486955,    2704544,   -2191444,    -860476},
  {    -496546,    -536013,     909813,    -148585,    -482051,    -336131,    -912108,     -48253,    -121459,      76395,    1033123,    1098575,     679052,    -157564,    -173308,     398252,     969212,   -1733920,     302324,    -496191,    -220179,     586130,     967489,    1067326,   -1482633,    9131652,   -1750631,   -1402232,   -1529487,     433940,   -1873892,   -1577241,   -7430724,     775874,   -3809289,   -1785056,    -851404,     930039,     885092,    -756411,    2516119,    2516287,   -1981708,   -1520743,   -6312272,    1579176,     443212,   -1765501,    2589914,    2723308,    3868037,    2631217,   -2338451,   -2857429,    -336626,    1456269,   -4733684,    1188362,   -2559537,    -533359},
  {     149397,     124632,     551771,    -363477,     205432,     -60141,     650889,    -510843,    -417820,    -432195,   -1142203,     766756,     391398,     218154,     381688,    -793746,    -119091,   -1652447,    -110825,     122684,     -58991,    -240462,    -977486,    -996386,      54818,   -1750631,    9635236,   -3480355,     234715,   -1713339,   -1786009,    -942300,   -6582053,     567358,   -1268897,   -3199024,      94337,     278625,     223866,      -1227,    1998075,    1954983,   -1882173,    -989347,   -4837419,    1501913,    -378133,   -1579650,    2169282,    1939921,    2835185,    2284326,   -1471866,   -2331364,     603310,     774412,   -4564306,    1649815,     546095,   -3560514},
  {      21483,      45505,     418521,    -353888,     171091,     313513,     150505,    -290876,    -187145,    -170690,     701920,   -1302001,      78143,     283497,    -160284,     -90924,      -9373,   -1685738,    -524670,     393306,     238588,    -399150,   -1008316,    -996386,     -22922,   -1402232,   -3480355,    9133055,     576931,   -1838090,   -1575644,    -546667,   -5974924,     102294,   -1609096,   -3954897,     245672,      84620,     174242,      69164,    2035174,    2040868,   -2039600,    -666835,   -5288842,    1679362,     -63614,   -1983947,    2125508,    2331261,    3175056,    2199594,   -1918560,   -2327297,     474751,     231166,   -5196035,    1875155,    -931648,   -1133053},
  {    -341148,    -337415,    -174949,     618037,    -512242,    -626813,      89522,    1024800,    -994183,    1147802,     -27570,    -282375,      70943,     127218,      71948,     240150,   -1028843,     458865,    -196731,      -3324,     118573,    -155398,     643303,     654583,   -3162578,   -1529487,     234715,     576931,    9773489,   -1862392,   -1398658,    -521372,   -7079075,     102521,   -4088987,   -2503670,    -646979,     958975,     915398,    -912326,    2433740,    2400479,   -2163102,   -1113484,   -6239150,    1369007,   -1551509,     -55720,    2828224,    2821130,    3000805,    3768919,   -2097824,   -2821885,    -223074,    -602973,   -4947020,    2564102,   -2223357,    -901689},
  {     314595,     265604,    -545067,     631948,     192023,     170991,    -509848,     623728,     727155,   -1408811,    -660547,    -582102,     516176,    -147690,     598991,    -692225,   -1922549,     205135,    -977499,     566726,     324122,    -961888,   -1400440,   -1409128,   -1646591,     433940,   -1713339,   -1838090,   -1862392,    8706420,   -1366175,    -519201,   -5818939,     115095,   -1601087,   -4568129,     257121,     -40389,    -142522,     367959,    2032813,    1977819,   -1731039,   -1039554,   -4723662,    1379294,   -2100472,      68686,    2239639,    2209012,    1929147,    3196402,   -1858975,   -2543681,    -956770,     713196,   -4624084,    1609316,    1105386,   -1561099},
  {    2772502,    2721922,   -1869313,   -2599440,    3244057,    4236377,   -1766909,   -1974078,   -1116115,   -1083128,   -1635451,   -2863014,   -2961954,     764431,    1047898,   -6722501,   -3197247,   -3458419,   -4449426,    3441613,    1231670,   -4449688,  -12958386,  -13004611,   -1985126,   -1873892,   -1786009,   -1575644,   -1398658,   -1366175,    9977044,     -10005,     738692,    -243966,   -1685611,   -1277420,     613866,     998578,   -1141612,     274748,    -398265,    -403453,   -1280821,    1087012,    1393099,     592586,     376394,      72343,    -801939,    -841500,    -544546,    -895294,    -133277,     916054,   -1535713,    -471115,     418431,    -500743,      23010,     169846},
  {     843578,     823928,    -876135,   -1019748,    1864653,    1050429,     277069,     169173,    -339665,    -383340,   -1672910,    -392040,     104444,   -2838739,   -1081349,   -3772274,    -773590,    -842673,   -1278290,    1599877,     777902,   -1287357,   -4650101,   -4694945,   -1181733,   -1577241,    -942300,    -546667,    -521372,    -519201,     -10005,   10057852,    1115332,   -1483870,     684017,     102058,    1144549,     128732,     125507,    -700360,    -851573,    -849399,    1747805,   -1125075,    2181772,    -307616,     882249,     761661,   -1217332,   -1182985,   -1419944,   -1535269,    1248311,     347458,    -226997,   -1943992,    1859797,    -501906,      59397,    -138990},
  {    8843654,    8523149,   -7345496,   -8865897,   11153794,   11461421,   -7775749,   -6030119,   -5873899,   -5876692,   -5915594,   -5742588,     936801,    1284848,    5230227,  -23064086,   -6887291,   -6972261,  -17503766,   10965699,    3346342,  -15294819,  -44458241,  -44687429,   -7097260,   -7430724,   -6582053,   -5974924,   -7079075,   -5818939,     738692,    1115332,   19603777,   -3093355,    2705916,    3198213,    1279848,     -89116,    -147602,    1323054,   -2640907,   -4821370,    3326828,      26654,    9292167,   -2513710,     -56919,    -250815,   -4451120,   -3165932,   -3434306,   -3564544,    3493641,    3467468,     724596,    -622178,    6745180,   -2739488,     752126,    1361112},
  {   -1211426,   -1017852,     178672,     687501,    -125218,   -1234081,    1180521,    -477907,     366444,     381082,    1031074,      66937,     186178,   -1411175,     283473,    2458558,     370210,     527616,    1839778,    -524256,    -205884,    -325756,    1661554,    1707399,     453277,     775874,     567358,     102294,     102521,     115095,    -243966,   -1483870,   -3093355,   10734403,   -5132425,   -6004834,   -2452839,    1523012,    1570478,   -2067370,    5007404,    7163899,   -6403237,   -4721012,  -15151743,    5283223,    -625742,    -179878,    7573329,    6289278,    6598196,    7073180,   -3058860,   -5889436,   -1742525,    2385418,  -14706099,    3413449,   -1547209,   -2557578},
  {    2341534,    2281795,   -2378999,   -2968293,    2622003,    3788310,   -1906123,   -2291701,    -529818,   -2650521,   -1979946,    -664050,    -971859,     796176,     949081,   -6920292,    -890213,   -1230943,   -4409581,    3387788,    1209513,   -4396733,  -12902311,  -12946569,   -3345419,   -3809289,   -1268897,   -1609096,   -4088987,   -1601087,   -1685611,     684017,    2705916,   -5132425,    9429030,   -1579437,     323947,   -1105324,    1021651,     613824,    -400720,    -407706,   -1344265,    -157865,     297588,    -536963,     876120,     576127,    -238217,    -239680,    -462730,    -697919,     368196,    1243333,     216098,     769755,    1283325,     568448,   -1851094,    -247410},
  {    3013752,    2999166,   -2769171,   -3124000,    3388711,    4585317,   -2596068,   -2499215,   -3127321,    -978117,   -2368771,   -1225271,   -1257559,    1142228,    1517248,   -7778422,   -1733307,   -1544141,   -5168434,    3919040,    1379528,   -5152212,  -14956077,  -15010281,   -1996393,   -1785056,   -3199024,   -3954897,   -2503670,   -4568129,   -1277420,     102058,    3198213,   -6004834,   -1579437,    9563652,    -146178,    -106418,     -81968,    1318504,    -838181,    -809205,   -1197217,     321988,    1677085,    -495026,     393228,     642730,    -913139,    -910948,   -1384543,   -1249486,     527322,    1555940,    1777437,    -318896,    1831454,    -476864,    1224177,    -662168},
  {    1250340,    1218871,   -1090475,   -1089813,    1601939,    1236864,    -578000,    -533396,    -861888,    -962546,    -664404,   -1034744,     238423,     598938,    1102581,   -2161491,    -744361,    -784368,   -1911570,    1422213,     452829,   -2127711,   -5499032,   -5549450,    -812280,    -851404,      94337,     245672,    -646979,     257121,     613866,    1144549,    1279848,   -2452839,     323947,    -146178,    8838223,     129822,     106460,   -3781000,     978397,     950268,   -2389032,    -686959,   -3009043,     548512,   -1637754,   -1939260,    1143706,    1010841,    1661983,    1453029,   -1245950,   -1105731,   -1908689,    -872500,   -2607359,     887605,   -2120318,    -762565},
  {    -699051,    -700064,     331067,     119334,    -856517,    -894703,     357487,     449148,     762433,     746717,     614133,     544433,     462669,    -102712,    -184126,    1501233,     921020,     985452,    1277831,    -446145,    -128851,    1175047,    2838837,    2760215,     784881,     930039,     278625,      84620,     958975,     -40389,     998578,     128732,     -89116,    1523012,   -1105324,    -106418,     129822,    9407258,   -3329207,    -543404,     495433,     481935,    -639390,   -1645077,   -2949971,   -1125543,    -437749,    -331550,     723091,     653061,     720077,     769009,    -491982,    -982378,   -1366743,   -1520225,   -2789582,   -1051088,     760491,    -358717},
  {    -654566,    -634661,     236296,     419444,    -817212,   -1197329,     367605,     352872,     675088,     749606,     645425,     606184,     670075,      48775,    -184437,    1325224,     773952,     885839,    1087315,    -526119,      99329,    1191243,    2653009,    2760215,     857171,     885092,     223866,     174242,     915398,    -142522,   -1141612,     125507,    -147602,    1570478,    1021651,     -81968,     106460,   -3329207,    9412838,    -543963,     529994,     533542,    -878505,   -1815960,   -2987879,   -1027427,    -342803,    -215904,     671108,     727978,     768631,     578377,    -543201,    -699854,     759555,   -1492685,   -2966777,    -947133,   -1393669,    -375174},
  {     961558,     957048,    -551403,    -786927,     825017,    1736061,    -646039,    -885457,    -804551,    -760829,   -1082134,    -476333,     314213,    1098536,    1235250,   -2446757,    -860450,   -1107901,   -2245147,    1510412,     589815,   -2026174,   -5547818,   -5549450,    -502614,    -756411,      -1227,      69164,    -912326,     367959,     274748,    -700360,    1323054,   -2067370,     613824,    1318504,   -3781000,    -543404,    -543963,    9322729,     990421,     993122,   -2766044,    -920818,   -3085722,     719448,   -1609236,   -1539816,    1326448,    1448740,     981107,    1344461,    -797117,   -1314329,   -1795929,    1202468,   -3038978,     843359,   -1429736,   -3222343},
  {   -2338987,   -2629675,    2892697,    3367082,   -3038222,   -3427987,    2484350,    2684378,    2122875,    2024721,    2441715,    2033048,    -672481,   -1137672,   -2015041,    7918006,    2177367,    2315732,    5878400,   -3928170,   -1361698,    5763885,   15749833,   15661640,    2435906,    2516119,    1998075,    2035174,    2433740,    2032813,    -398265,    -851573,   -2640907,    5007404,    -400720,    -838181,     978397,     495433,     529994,     990421,    5600698,   -7094995,    3505347,    1677739,    8777107,   -3043075,     174980,      -6288,   -5704747,   -5414472,   -5816802,   -5963228,    1298304,    2336971,     941672,    -922438,    7623462,   -1994802,     918570,    1451741},
  {   -2621631,   -2235002,    2810799,    3316348,   -2961270,   -3398261,    2560723,    2523291,    2007541,    2095214,    2443669,    2032012,    -566615,   -1030484,   -1859118,    7606452,    2171512,    2157857,    5664632,   -3932323,   -1180023,    5756828,   15441678,   15661640,    2422919,    2516287,    1954983,    2040868,    2400479,    1977819,    -403453,    -849399,   -4821370,    7163899,    -407706,    -809205,     950268,     481935,     533542,     993122,   -7094995,    5669038,    3381247,    1560351,    8618204,   -2849997,     119959,     158191,   -5430756,   -5669979,   -5805779,   -5828349,    1234328,    2315406,     937305,    -900239,    9610408,   -4033535,     902614,    1438372},
  {    2873613,    2733295,   -2367546,   -2961598,    3416768,    5012230,   -2311007,   -2661828,   -1390150,   -1355683,   -2964969,   -1039768,   -1309880,    -190599,    2256388,   -6908594,   -1578001,   -1772253,   -5254766,    3871650,    1389694,   -5394757,  -14780057,  -14868401,   -1673523,   -1981708,   -1882173,   -2039600,   -2163102,   -1731039,   -1280821,    1747805,    3326828,   -6403237,   -1344265,   -1197217,   -2389032,    -639390,    -878505,   -2766044,    3505347,    3381247,    9684432,     119461,    1491972,    -864527,   -1862235,   -1619349,    -650694,    -930447,   -1076932,   -1168424,     832989,     -74466,     856824,     741985,    1744852,    -825050,     859086,     695081},
  {    1261792,    1136430,   -1617469,   -1738843,    2474327,    1426003,    -195134,    -154622,    -899468,    -815464,    -100626,   -1543121,   -1073728,   -1133802,     834088,   -2985205,      82087,      29449,   -2052598,    1934802,     949257,   -2209287,   -6668242,   -6558735,   -1532476,   -1520743,    -989347,    -666835,   -1113484,   -1039554,    1087012,   -1125075,      26654,   -4721012,    -157865,     321988,    -686959,   -1645077,   -1815960,    -920818,    1677739,    1560351,     119461,    9760389,    1434945,   -2639535,    -197156,    -543339,   -1300570,   -1619230,   -1579874,   -1620101,      27263,    1559717,    1159568,     218374,    3651176,    -685618,     106377,     630957},
  {    8000951,    7885100,   -4838379,   -6050705,    8116870,    9463295,   -5880504,   -6156614,   -4708544,   -5012953,   -5598599,   -4192878,    1594210,    2347281,    2086134,  -19436137,   -6649715,   -5009984,  -12525819,    8916034,    2644065,  -15074258,  -36591537,  -36722790,   -5928779,   -6312272,   -4837419,   -5288842,   -6239150,   -4723662,    1393099,    2181772,    9292167,  -15151743,     297588,    1677085,   -3009043,   -2949971,   -2987879,   -3085722,    8777107,    8618204,    1491972,    1434945,   13873087,   -3395506,     344530,     -88120,   -2871807,   -2466149,   -2305917,   -2707507,    1670567,    2475144,    1381304,     -88777,    5538967,   -1315201,     127143,     743682},
  {   -1746067,   -1626583,    1451362,    1707414,   -1917663,   -1841304,    1481832,    1638839,    1257097,    1493020,    1199646,    1227365,     361560,    -484327,    -801538,    4164401,    2701955,     946688,    2249452,   -2690702,   -1080600,    4780945,    9732117,    9672038,    1352122,    1579176,    1501913,    1679362,    1369007,    1379294,     592586,    -307616,   -2513710,    5283223,    -536963,    -495026,     548512,   -1125543,   -1027427,     719448,   -3043075,   -2849997,    -864527,   -2639535,   -3395506,   14738568,    -577570,    -177486,    8031699,    7662445,    9117774,    9535613,   -6246703,   -8146638,   -1076730,    2607313,  -18135663,    7145410,   -2145377,   -2919021},
  {       6638,     -58766,    -568191,     789397,     572557,     154862,    -645252,     973738,     336976,     421631,    -218183,    -664222,     472243,     960682,    -649920,     147843,   -2078191,    -309783,    -760678,     481386,     338992,    -306775,   -1394283,   -1267248,   -1765015,     443212,    -378133,     -63614,   -1551509,   -2100472,     376394,     882249,     -56919,    -625742,     876120,     393228,   -1637754,    -437749,    -342803,   -1609236,     174980,     119959,   -1862235,    -197156,     344530,    -577570,    8948369,   -1764389,    2088085,    2503927,    2545236,    1574731,   -1638344,   -2525936,     -59661,    1356156,   -5360968,    1502987,     392027,    -368960},
  {     -47636,     124832,     978772,    -308316,    -258900,    -198796,     765355,    -705099,    -271853,    -389564,     621491,     753326,     414552,     908055,    1155134,   -1345055,    -154198,   -1779855,    -200644,     192736,    -127446,    -304869,    -684778,    -854505,     288456,   -1765501,   -1579650,   -1983947,     -55720,      68686,      72343,     761661,    -250815,    -179878,     576127,     642730,   -1939260,    -331550,    -215904,   -1539816,      -6288,     158191,   -1619349,    -543339,     -88120,    -177486,   -1764389,    9130925,    2218720,    2309016,    1411297,    2630133,   -1528201,   -2222238,    -340818,    1438399,   -5296828,    1729061,     115197,    -229295},
  {   -5088578,   -4795309,     574172,    1178460,   -3200854,   -3804025,    2637470,    2787313,    2382850,    2325617,    2897493,    2349673,    -597724,   -1281146,    -692225,    8477804,    2614010,    2773685,    5096033,   -4163786,   -1231583,    6116930,   17053686,   17073993,    2407858,    2589914,    2169282,    2125508,    2828224,    2239639,    -801939,   -1217332,   -4451120,    7573329,    -238217,    -913139,    1143706,     723091,     671108,    1326448,   -5704747,   -5430756,    -650694,   -1300570,   -2871807,    8031699,    2088085,    2218720,    5288782,   -2468150,   -3178646,   -3176211,    1064242,    1810760,     357359,   -1230268,    7368719,   -2040753,     949232,    1171497},
  {   -5013620,   -5249849,    2759542,    3734616,   -5353978,   -5955104,    2458334,    2932584,    2263714,    2413194,    2894383,    2331917,    -260047,    -997818,   -1974792,    9636350,    2515825,    2303574,    7585065,   -3890368,   -2950726,    5044574,   16846975,   17073993,    2242905,    2723308,    1939921,    2331261,    2821130,    2209012,    -841500,   -1182985,   -3165932,    6289278,    -239680,    -910948,    1010841,     653061,     727978,    1448740,   -5414472,   -5669979,    -930447,   -1619230,   -2466149,    7662445,    2503927,    2309016,   -2468150,    5337396,   -5819478,   -6125576,    3533536,    4354519,     428621,   -1309456,    9322395,   -3447675,    1028222,    1316063},
  {   -3253847,   -3154841,     386836,    3617835,   -3054952,   -4195634,     907216,    3357426,    2150539,    2271141,    1396294,     192786,    -772016,   -1308632,   -1934348,    9222882,    2606238,    3556282,    6981948,   -6141496,    -956807,    5755905,   16925457,   17227159,    2337000,    3868037,    2835185,    3175056,    3000805,    1929147,    -544546,   -1419944,   -3434306,    6598196,    -462730,   -1384543,    1661983,     720077,     768631,     981107,   -5816802,   -5805779,   -1076932,   -1579874,   -2305917,    9117774,    2545236,    1411297,   -3178646,   -5819478,   11962726,    1120471,   -1276353,   -2407025,    -519383,     544834,   -4922921,    2040958,    -357661,    -999724},
  {   -3180615,   -3094350,    3123220,    1360963,   -4014445,   -4485277,    2880116,    1068284,     755793,     678383,    3009586,    2496085,    -887315,   -1286716,   -2169637,    9766063,    3755822,    2884208,    5551021,   -4425174,   -1519733,    5855058,   17740069,   17639902,    3499857,    2631217,    2284326,    2199594,    3768919,    3196402,    -895294,   -1535269,   -3564544,    7073180,    -697919,   -1249486,    1453029,     769009,     578377,    1344461,   -5963228,   -5828349,   -1168424,   -1620101,   -2707507,    9535613,    1574731,    2630133,   -3176211,   -6125576,    1120471,   11932308,   -1257381,   -1942319,    -740746,     603229,   -4828882,    2181421,    -504243,    -933866},
  {    2711412,    2642865,   -1235398,   -2307922,     410478,    2898985,   -2988096,   -3746916,    -943518,   -1024047,   -3031303,    -814587,     216603,    1401975,     884616,   -6790882,   -2042299,   -2088659,   -4598968,    3039163,     628094,   -3347241,  -10816408,  -13090061,   -1642341,   -2338451,   -1471866,   -1918560,   -2097824,   -1858975,    -133277,    1248311,    3493641,   -3058860,     368196,     527322,   -1245950,    -491982,    -543201,    -797117,    1298304,    1234328,     832989,      27263,    1670567,   -6246703,   -1638344,   -1528201,    1064242,    3533536,   -1276353,   -1257381,   12468168,    2467027,     616024,   -1458923,    8802460,   -2560956,     999619,    1240917},
  {    3844202,    3795316,   -2188412,   -2689133,    3983005,    1978361,   -1995274,   -2087932,   -3487005,   -3555556,   -2134450,   -3847450,    1073384,     747166,    1606568,   -8657391,   -3216470,   -2834284,   -6184469,    4071256,    1443407,   -5023645,  -17150081,  -15153773,   -2653975,   -2857429,   -2331364,   -2327297,   -2821885,   -2543681,     916054,     347458,    3467468,   -5889436,    1243333,    1555940,   -1105731,    -982378,    -699854,   -1314329,    2336971,    2315406,     -74466,    1559717,    2475144,   -8146638,   -2525936,   -2222238,    1810760,    4354519,   -2407025,   -1942319,    2467027,   13625898,     957609,   -1467811,   10212037,   -2432498,    1187653,    1760262},
  {     880534,     872576,    -119033,    -407480,    1088413,    1142239,    -783123,    -673963,    -942169,    -851184,    -403409,    -315744,   -1323896,     -70699,      60140,   -2361496,   -2271286,   -2541311,   -1312378,    1008284,     427124,   -1292896,   -3704620,   -3685660,    -104749,    -336626,     603310,     474751,    -223074,    -956770,   -1535713,    -226997,     724596,   -1742525,     216098,    1777437,   -1908689,   -1366743,     759555,   -1795929,     941672,     937305,     856824,    1159568,    1381304,   -1076730,     -59661,    -340818,     357359,     428621,    -519383,    -740746,     616024,     957609,    8529162,      44483,   -3881070,     914013,   -2915631,   -1377678},
  {   -1042552,   -1015702,     987303,    1067944,   -1375640,    -988737,     393286,     -44993,     853872,     779183,     839727,    1314137,    -231085,   -1684165,   -2105033,     460093,     202674,     179041,    1910194,    -859215,     -92232,    1911983,    4622406,    4624005,    1590181,    1456269,     774412,     231166,    -602973,     713196,    -471115,   -1943992,    -622178,    2385418,     769755,    -318896,    -872500,   -1520225,   -1492685,    1202468,    -922438,    -900239,     741985,     218374,     -88777,    2607313,    1356156,    1438399,   -1230268,   -1309456,     544834,     603229,   -1458923,   -1467811,      44483,    9139606,   -4197005,   -1086105,     333347,   -1196056},
  {    6946781,    6779035,   -5601207,   -6848988,    8044077,    9409193,   -5564831,   -5854907,   -5023503,   -4684921,   -5502336,   -4125681,     509060,    2374406,    4180691,  -18777173,   -5822175,   -5926123,  -14358844,    8542837,    2537576,  -12155731,  -35229968,  -35368479,   -6486955,   -4733684,   -4564306,   -5196035,   -4947020,   -4624084,     418431,    1859797,    6745180,  -14706099,    1283325,    1831454,   -2607359,   -2789582,   -2966777,   -3038978,    7623462,    9610408,    1744852,    3651176,    5538967,  -18135663,   -5360968,   -5296828,    7368719,    9322395,   -4922921,   -4828882,    8802460,   10212037,   -3881070,   -4197005,   13337711,   -3610183,    1073383,     753978},
  {   -3015244,   -2926770,    1946655,    2699162,   -3289536,   -3205744,    1655303,    2108010,    1542516,    1214615,    1239352,    1287673,    -359227,    -334264,    -919229,    6979470,    1364777,    1727548,    4952535,   -2865634,    -990861,    2753977,   10987703,   11026349,    2704544,    1188362,    1649815,    1875155,    2564102,    1609316,    -500743,    -501906,   -2739488,    3413449,     568448,    -476864,     887605,   -1051088,    -947133,     843359,   -1994802,   -4033535,    -825050,    -685618,   -1315201,    7145410,    1502987,    1729061,   -2040753,   -3447675,    2040958,    2181421,   -2560956,   -2432498,     914013,   -1086105,   -3610183,   15732413,   -1189288,   -2921216},
  {     406795,     386412,    -583034,    -925197,     441887,     894517,    -297358,    -584389,    -396522,    -415255,   -1319653,    -515796,     499417,    -130586,     -60329,   -2385573,      91778,    -243610,   -1312334,    1060847,     413479,   -1306931,   -3590848,   -3627619,   -2191444,   -2559537,     546095,    -931648,   -2223357,    1105386,      23010,      59397,     752126,   -1547209,   -1851094,    1224177,   -2120318,     760491,   -1393669,   -1429736,     918570,     902614,     859086,     106377,     127143,   -2145377,     392027,     115197,     949232,    1028222,    -357661,    -504243,     999619,    1187653,   -2915631,     333347,    1073383,   -1189288,    8409697,   -1554249},
  {    1147260,    1127795,   -1102184,   -1068995,    1325474,    1606478,   -1033184,    -737864,    -857101,    -854396,   -1327582,   -1501943,     197952,     172260,     382106,   -3107404,    -759997,    -508396,   -2111121,    1616493,     652123,   -2119034,   -5669752,   -5691331,    -860476,    -533359,   -3560514,   -1133053,    -901689,   -1561099,     169846,    -138990,    1361112,   -2557578,    -247410,    -662168,    -762565,    -358717,    -375174,   -3222343,    1451741,    1438372,     695081,     630957,     743682,   -2919021,    -368960,    -229295,    1171497,    1316063,    -999724,    -933866,    1240917,    1760262,   -1377678,   -1196056,     753978,   -2921216,   -1554249,   10842338}
};
static int s[60][60] = {
  {   10073848,    3548639,    1815793,    2027614,    -685064,    -713206,     384210,     194997,     191338,     774290,    1003453,    1017050,     428633,     322923,   -1075530,   -1055311,    -226724,    -360063,     650127,     627888,     752097,    1429091,    -891206,    -370811,     166955,       8517,      33001,     539591,     829982,     893382,     591068,     749604,     412098,     710846,     531854,     617418,     569381,     421819,     209795,    -187607,      38855,    -246742,     -70665,     323680,    -306626,    1313064,     252035,     359595,    -641626,    2146670,     450372,     544572,     974197,     970167,     685179,     842290,     413805,     710415,     641225,    1147260},
  {    3548639,   10109758,    -781009,   -1010509,    1890047,    1859624,    -299404,     -48150,     110393,    -321309,     127888,     150481,     109738,      99866,    -792513,    -769672,    -356709,     265956,    1027277,    1009222,    -627888,    -966020,    1015023,     752628,     -50284,      88982,     246951,     -55014,     416996,     477553,     506287,     854074,     533805,     582544,     518398,     603574,     429213,     350288,     319924,    -131064,    -573935,     203417,    -175601,     277745,    1142629,    -511495,     690957,     138430,    2249771,    -274693,    1168420,     548042,     122162,     114411,     353241,     701754,     276705,     324816,     359546,    1127795},
  {    1815793,    -781009,    9318628,   -1465214,    -379577,    -296717,    1548855,    -163448,      87398,    -322720,    1992691,    2059199,     238076,     323387,   -1182750,    -150896,    -217083,    -646361,     -70697,    -792513,    1075530,    -745609,     237041,    -138673,    -107528,    1139783,     952412,     617749,     381368,     -50541,     582857,     529005,     542286,     938840,     513432,     132373,      88577,     360837,    -140940,      31598,     -46372,     703250,     141432,    -364301,    1327432,     507491,     749677,    -736067,    2283835,    1289791,    -918231,     322981,    -300697,    -201852,    1011354,     579317,     689558,     740063,     583661,   -1102184},
  {    2027614,   -1010509,   -1465214,    9525899,     183886,    -140179,     -84488,    1425603,    1019961,    2102675,     728989,     322404,     533201,     303846,   -1327432,    -749565,    -841902,    -383446,    -258563,   -1142629,    -306626,    1424693,    -669550,     410595,     845735,    -615335,    -616139,     407036,    1719820,    1739733,    1324835,     657335,     948123,     847509,     823198,     760491,     497749,     181639,    -417041,     -56122,     392609,     386226,    -168048,    -173909,    1374468,     970448,    -591665,     869959,    2296097,     844298,     354274,    -922605,     676732,     304912,     939640,     672190,    1029280,    1270876,     797609,   -1068995},
  {    -685064,    1890047,    -379577,     183886,   10101791,    -599126,   -1495326,   -2131242,    -279534,    1027681,    -154979,    1905806,     544527,    -956896,    -542286,   -1603695,        137,    -554735,   -1478096,    -533805,     412098,     412702,     253606,    -248690,     -94879,    -219182,    -368662,    1098949,    1375467,    1374865,     929543,    2028437,    2357544,    2194488,    1035746,    1188443,     626950,     511997,     248938,    -647454,     338658,    -504181,     -14801,    -645026,     948123,    1809872,     271102,     733117,    1180007,    2040804,    -141671,     817507,     -51641,    1658234,     930437,     789454,    1116057,    1017334,    1088753,    1325474},
  {    -713206,    1859624,    -296717,    -140179,    -599126,    9965406,     294915,     161409,   -1978734,    -677810,    1716065,    -476988,    -829956,     301167,    -689558,   -1725934,     169475,    -703750,   -1423594,    -276705,     413805,     609164,   -1355668,    1616180,     136776,    -415582,    -548725,     522508,    1238487,    1090973,    2236917,     723124,    1116057,    1080690,    2301594,    1985767,     456349,     211711,    -643329,     -61929,     883541,      40312,    -831300,      92752,    1029280,    1870930,       5936,     922600,    1163360,    2033501,    -237440,     274819,    1555024,    -306251,    1265237,     970157,    1398089,    1304994,    1267008,    1606478},
  {     384210,    -299404,    1548855,     -84488,   -1495326,     294915,    9455411,   -1510944,     187219,     422146,   -3251745,   -1430459,     -48777,     567080,    -323387,    -105601,     194867,    -838816,     227594,     -99866,     322923,    -173581,    -332767,     187293,    -246330,    1006617,    -787936,    -338903,     -72859,     314167,      30318,     903463,    -956896,     566500,    -207989,     255058,    -218289,     138051,      62055,     235340,     358754,    -456209,     142003,    -705946,     303846,       8141,    -458522,     938283,     202993,    -548420,    1327027,    -168721,   -1411301,     412784,     192453,      33840,     301167,    -228004,    -296438,   -1033184},
  {     194997,     -48150,    -163448,    1425603,   -2131242,     161409,   -1510944,    9555644,    -634455,   -2024743,   -2028703,     201659,    -374435,     705946,    -364301,     460877,   -1033368,     880317,     388391,     277745,    -323680,    -314696,     420677,    -209682,     907772,     598427,     822447,    -259416,   -1374481,   -1367602,    -539048,     619100,     645026,   -1382240,    -441739,    -433341,    -341831,     -34570,     219882,     375144,      33921,    -120954,     556038,    -912101,     173909,    -589699,    1282467,    -938397,     120165,     -76721,    -194366,    1320694,   -2384819,     -48471,      -6903,     195461,     -92752,    -672308,    -514031,    -737864},
  {     191338,     110393,      87398,    1019961,    -279534,   -1978734,     187219,    -634455,   10364621,   -3811053,    -288635,   -2003496,     427109,     -62055,    -140940,     914305,   -1178850,     477785,     383068,     319924,    -209795,    -363388,     750164,    -808159,   -1001478,     740730,    1013772,    -491691,     599275,   -1262478,     387159,    -248832,    -248938,    -398738,     595298,   -1301930,    -327223,    -150855,      79658,     459105,     225110,       9644,    -566398,     219882,     417041,    -959827,     990976,    -468241,     215172,      21883,      16527,    1064643,    -163042,   -1897300,    -205594,     280188,     643329,    -809582,   -1050403,    -857101},
  {     774290,    -321309,    -322720,    2102675,    1027681,    -677810,     422146,   -2024743,   -3811053,   10304892,    1097416,    -584577,     903583,     138051,    -360837,    -655599,    -766294,    -565518,    -389124,    -350288,     421819,     492429,    -369929,     474565,    -358107,    -184581,    -741037,     377647,     -13578,    1592741,    1253222,     354489,     511997,     582183,     -68465,    1508451,     444122,    -114401,     150855,    -330718,     628580,    -369675,    -928995,      34570,     181639,     801390,     786908,     478109,     705838,    -296006,    -333894,    2034273,    1029649,    -705664,     457864,      85076,     211711,     848831,    1505096,    -854396},
  {    1003453,     127888,    1992691,     728989,    -154979,    1716065,   -3251745,   -2028703,    -288635,    1097416,   10807115,      23060,     345938,     903463,    -529005,    -777043,     -16402,   -1329038,    -525818,    -854074,     749604,     471151,    -805745,     813652,     -73160,   -1480632,     658381,      31428,    1379093,    1573128,    1038572,     -88151,    2028437,    1701283,    1063674,    1204145,     500478,     354489,     248832,    -298841,     268741,    -568994,    -504155,    -619100,     657335,     958289,     184137,    1419884,    1026456,     183407,    2045993,     729610,    -207553,    1608578,     851797,     791284,     723124,    1084875,    1815967,   -1327582},
  {    1017050,     150481,    2059199,     322404,    1905806,    -476988,   -1430459,     201659,   -2003496,    -584577,      23060,   10318773,    1130957,      33840,    -579317,   -1014476,     199622,   -1538324,    -372173,    -701754,     842290,     570996,    -259915,     534694,     138873,   -1626163,   -1655486,    1580957,    1336998,    1170942,     259178,     791284,     789454,     579841,    2181651,    2056497,     318584,      85076,    -280188,     -56984,     787054,     -37089,    -974697,    -195461,     672190,    1067415,     -77371,    1592128,     975058,     116100,    2021029,     214989,    1689816,    -650727,    1127444,     933159,     970157,    1412675,    1649898,   -1501943},
  {     428633,     109738,     238076,     533201,     544527,    -829956,     -48777,    -374435,     427109,     903583,     345938,    1130957,    9639653,    -246330,     107528,     310149,   -1153983,   -1478699,     217415,      50284,     166955,     161601,    -116650,     520787,    -140804,    -170314,     -59720,     531510,     681783,     463749,   -3190405,     -73160,     -94879,     106964,   -1379009,   -1337772,     612300,    -358107,    1001478,    -305639,     -40156,      36680,    1280885,    -907772,     845735,     977959,     -88136,     -37750,      93016,     -12792,      50568,     361937,     133113,     819885,   -1541056,     138873,     136776,     296474,     220882,     197952},
  {     322923,      99866,     323387,     303846,    -956896,     301167,     567080,     705946,     -62055,     138051,     903463,      33840,    -246330,    9455411,   -1548855,   -1327027,     194867,     458522,     548420,     299404,     384210,     202993,     456209,     358754,     -48777,    -142003,    -235340,    -218289,      30318,     192453,     -72859,   -3251745,   -1495326,   -1411301,    -207989,    -296438,    -338903,     422146,    -187219,     787936,     187293,     332767,   -1006617,    1510944,     -84488,    -168721,     838816,     938283,    -173581,    -227594,     105601,       8141,     566500,    -228004,     314167,   -1430459,     294915,     412784,     255058,     172260},
  {   -1075530,    -792513,   -1182750,   -1327432,    -542286,    -689558,    -323387,    -364301,    -140940,    -360837,    -529005,    -579317,     107528,   -1548855,    9318628,    -918231,     217083,     749677,    1289791,    -781009,   -1815793,   -2283835,     703250,      46372,    -238076,     141432,      31598,     -88577,    -582857,   -1011354,    -381368,   -1992691,     379577,     300697,    -513432,    -583661,    -617749,     322720,      87398,     952412,     138673,     237041,    1139783,    -163448,    1465214,    -322981,    -646361,     736067,     745609,     -70697,    -150896,    -507491,    -938840,    -740063,      50541,   -2059199,     296717,     201852,    -132373,     382106},
  {   -1055311,    -769672,    -150896,    -749565,   -1603695,   -1725934,    -105601,     460877,     914305,    -655599,    -777043,   -1014476,     310149,   -1327027,    -918231,    9366725,     239427,     274854,    -875466,    1168420,    -450372,     -36916,    -901303,   -1778168,     -50568,     202880,     654659,    -886936,    -380586,    -931771,    -382382,   -2045993,     141671,     150298,    -714527,    -912445,    -724395,     333894,      16527,    1131648,      71139,     419516,    1400473,    -194366,    -354274,    1370158,     983080,   -1185154,    -497648,     826358,    -315612,    -637431,    -861221,    -617974,      62102,   -2021029,     237440,     240868,    -282551,   -3107404},
  {    -226724,    -356709,    -217083,    -841902,        137,     169475,     194867,   -1033368,   -1178850,    -766294,     -16402,     199622,   -1153983,     194867,     217083,     239427,    9107636,   -1618486,      49667,     356709,    -226724,      91780,     -38746,     332565,   -1153983,     264787,      47924,     381604,   -1683014,   -1583360,   -1683014,     -16402,        137,     109289,     605001,     376413,     381604,    -766294,    1178850,     -47924,     332565,      38746,    -264787,    1033368,    -841902,     932180,    1618486,     -89570,      91780,     -49667,    -239427,     932180,     109289,     -14748,   -1583360,     199622,     169475,     -14748,     376413,    -759997},
  {    -360063,     265956,    -646361,    -383446,    -554735,    -703750,    -838816,     880317,     477785,    -565518,   -1329038,   -1538324,   -1478699,     458522,     749677,     274854,   -1618486,    9430347,     575005,     690957,    -252035,    -349451,     564728,    -556792,      88136,   -1011186,    -991207,   -2015366,    -457171,     113147,   -1662370,    -184137,    -271102,    -615937,     -88030,      90307,      46323,    -786908,     990976,     377848,     176847,     324349,    -180275,    1282467,     591665,   -1186711,    -144650,    1369689,    -156305,     160001,     983080,    -553694,     -52848,    -628708,   -2205485,      77371,      -5936,     -27911,    -266108,    -508396},
  {     650127,    1027277,     -70697,    -258563,   -1478096,   -1423594,     227594,     388391,     383068,    -389124,    -525818,    -372173,     217415,     548420,    1289791,    -875466,      49667,     575005,    9892701,    -274693,   -2146670,     -40627,    -464886,   -2184399,      12792,     555681,     549076,    -548474,   -1037168,    -881541,    -487307,    -183407,   -2040804,    -174626,    -837310,    -684086,     -12117,     296006,      21883,     446862,    -822442,    1193708,     339025,     -76721,    -844298,    1159232,     160001,    -294770,    -280012,    1929874,     826358,   -1375351,    -385767,    -328489,    -390691,    -116100,   -2033501,    -145880,    -715354,   -2111121},
  {     627888,    1009222,    -792513,   -1142629,    -533805,    -276705,     -99866,     277745,     319924,    -350288,    -854074,    -701754,      50284,     299404,    -781009,    1168420,     356709,     690957,    -274693,   10109758,   -3548639,   -2249771,     203417,     573935,    -109738,    -175601,    -131064,    -429213,    -506287,    -353241,    -416996,    -127888,   -1890047,    -122162,    -518398,    -359546,      55014,     321309,     110393,     246951,    -752628,    1015023,      88982,     -48150,    1010509,    -548042,     265956,    -138430,     966020,    1027277,    -769672,     511495,    -582544,    -324816,    -477553,    -150481,   -1859624,    -114411,    -603574,    1616493},
  {     752097,    -627888,    1075530,    -306626,     412098,     413805,     322923,    -323680,    -209795,     421819,     749604,     842290,     166955,     384210,   -1815793,    -450372,    -226724,    -252035,   -2146670,   -3548639,   10073848,    -641626,     246742,      38855,     428633,      70665,     187607,     569381,     591068,     685179,     829982,    1003453,    -685064,     974197,     531854,     641225,     539591,     774290,    -191338,     -33001,    -370811,     891206,      -8517,    -194997,    2027614,     544572,     360063,     359595,    1429091,    -650127,    1055311,    1313064,     710846,     710415,     893382,    1017050,    -713206,     970167,     617418,     652123},
  {    1429091,    -966020,    -745609,    1424693,     412702,     609164,    -173581,    -314696,    -363388,     492429,     471151,     570996,     161601,     202993,   -2283835,     -36916,      91780,    -349451,     -40627,   -2249771,    -641626,    9650591,   -2226103,    -437370,      93016,    -398116,    -448790,     703575,    1063106,    1164234,     928398,    1026456,    1180007,    -673360,     858688,     947959,     687597,     705838,    -215172,    -133451,    1224544,    -787254,     -75243,    -120165,    2296097,     395949,     156305,     623743,     463232,     280012,     497648,     645482,    1460686,    1662689,     818541,     975058,    1163360,    -715348,     727388,   -2119034},
  {    -891206,    1015023,     237041,    -669550,     253606,   -1355668,    -332767,     420677,     750164,    -369929,    -805745,    -259915,    -116650,     456209,     703250,    -901303,     -38746,     564728,    -464886,     203417,     246742,   -2226103,   10356582,   -3801323,     -36680,     862962,     779507,    -497956,    -681434,    -550179,     -54047,     568994,     504181,   -1874509,   -1011857,    -881387,      20373,     369675,       9644,     365017,     742391,    -260763,     540989,    -120954,    -386226,     987068,     324349,    -345743,     787254,    1193708,     419516,    -160927,     240058,   -1369583,    -235428,      37089,     -40312,   -1793762,    -569944,   -5669752},
  {    -370811,     752628,    -138673,     410595,    -248690,    1616180,     187293,    -209682,    -808159,     474565,     813652,     534694,     520787,     358754,      46372,   -1778168,     332565,    -556792,   -2184399,     573935,      38855,    -437370,   -3801323,   10332390,     -40156,    -460565,    -648252,     698431,     635757,     765957,     506720,     268741,     338658,    -690022,    1030479,    1154656,     555644,     628580,    -225110,    -132479,    1275419,    -742391,    -230549,     -33921,     392609,    1990107,    -176847,     778274,    1224544,     822442,     -71139,     917099,    -232520,    1625911,     691823,     787054,     883541,    -767926,     590846,   -5691331},
  {     166955,     -50284,    -107528,     845735,     -94879,     136776,    -246330,     907772,   -1001478,    -358107,     -73160,     138873,    -140804,     -48777,    -238076,     -50568,   -1153983,      88136,      12792,    -109738,     428633,      93016,     -36680,     -40156,    9639653,   -1280885,     305639,     612300,   -3190405,   -1541056,     681783,     345938,     544527,     133113,   -1379009,     220882,     531510,     903583,    -427109,      59720,     520787,     116650,     170314,     374435,     533201,     361937,    1478699,     -37750,     161601,    -217415,    -310149,     977959,     106964,     296474,     463749,    1130957,    -829956,     819885,   -1337772,    -860476},
  {       8517,      88982,    1139783,    -615335,    -219182,    -415582,    1006617,     598427,     740730,    -184581,   -1480632,   -1626163,    -170314,    -142003,     141432,     202880,     264787,   -1011186,     555681,    -175601,      70665,    -398116,     862962,    -460565,   -1280885,    9542197,    -732676,   -1843811,   -1881039,     193856,     383027,     504155,      14801,    -361836,   -2081210,     -34398,     148093,     928995,    -566398,     434800,     230549,     540989,     260646,     556038,     168048,     106704,    -180275,    1314085,      75243,     339025,    1400473,    -753093,    -446150,    -677944,    -130918,     974697,     831300,   -1001736,   -1999405,    -533359},
  {      33001,     246951,     952412,    -616139,    -368662,    -548725,    -787936,     822447,    1013772,    -741037,     658381,   -1655486,     -59720,    -235340,      31598,     654659,      47924,    -991207,     549076,    -131064,     187607,    -448790,     779507,    -648252,     305639,    -732676,   10596548,   -3717806,    -213986,   -1969096,     390699,     298841,     647454,    -316040,    -278950,   -2001203,     942609,     330718,     459105,    -349051,     132479,     365017,     434800,     375144,      56122,    -243208,     377848,    1285755,     133451,     446862,    1131648,    -496044,    -304459,    -452499,     928749,      56984,      61929,    -222468,     688033,   -3560514},
  {     539591,     -55014,     617749,     407036,    1098949,     522508,    -338903,    -259416,    -491691,     377647,      31428,    1580957,     531510,    -218289,     -88577,    -886936,     381604,   -2015366,    -548474,    -429213,     569381,     703575,    -497956,     698431,     612300,   -1843811,   -3717806,   10038127,    1202708,    -947943,    1054012,     500478,     626950,    1084874,    1475487,    -643142,    1630193,     444122,     327223,    -942609,     555644,     -20373,    -148093,     341831,     497749,     969010,     -46323,    2392480,     687597,      12117,     724395,     514498,    1120123,     576540,    1739931,     318584,     456349,     971353,     416500,   -1133053},
  {     829982,     416996,     381368,    1719820,    1375467,    1238487,     -72859,   -1374481,     599275,     -13578,    1379093,    1336998,     681783,      30318,    -582857,    -380586,   -1683014,    -457171,   -1037168,    -506287,     591068,    1063106,    -681434,     635757,   -3190405,   -1881039,    -213986,    1202708,   10884697,     -43244,    1220232,    1038572,     929543,    1420834,     491978,    1803583,    1054012,    1253222,    -387159,    -390699,     506720,      54047,    -383027,     539048,    1324835,    1076200,    1662370,     529993,     928398,     487307,     382382,    1797057,    1573000,    1419422,    1537872,     259178,    2236917,    1935230,    -233522,    -901689},
  {     893382,     477553,     -50541,    1739733,    1374865,    1090973,     314167,   -1367602,   -1262478,    1592741,    1573128,    1170942,     463749,     192453,   -1011354,    -931771,   -1583360,     113147,    -881541,    -353241,     685179,    1164234,    -550179,     765957,   -1541056,     193856,   -1969096,    -947943,     -43244,    9924096,    1537872,     851797,     930437,    1377257,    2088435,    -171109,    1739931,     457864,     205594,    -928749,     691823,     235428,     130918,       6903,     939640,     893440,    2205485,     560846,     818541,     390691,     -62102,    1773876,    1450482,    1195850,    1056306,    1127444,    1265237,    1164000,    3110960,   -1561099},
  {     591068,     506287,     582857,    1324835,     929543,    2236917,      30318,    -539048,     387159,    1253222,    1038572,     259178,   -3190405,     -72859,    -381368,    -382382,   -1683014,   -1662370,    -487307,    -416996,     829982,     928398,     -54047,     506720,     681783,     383027,     390699,    1054012,    1220232,    1537872,   10884697,    1379093,    1375467,    1573000,     491978,    -233522,    1202708,     -13578,    -599275,     213986,     635757,     681434,    1881039,    1374481,    1719820,    1797057,     457171,     529993,    1063106,    1037168,     380586,    1076200,    1420834,    1935230,     -43244,    1336998,    1238487,    1419422,    1803583,     169846},
  {     749604,     854074,     529005,     657335,    2028437,     723124,     903463,     619100,    -248832,     354489,     -88151,     791284,     -73160,   -3251745,   -1992691,   -2045993,     -16402,    -184137,    -183407,    -127888,    1003453,    1026456,     568994,     268741,     345938,     504155,     298841,     500478,    1038572,     851797,    1379093,   10807115,    -154979,    -207553,    1063674,    1815967,      31428,    1097416,     288635,    -658381,     813652,     805745,    1480632,    2028703,     728989,     729610,    1329038,    1419884,     471151,     525818,     777043,     958289,    1701283,    1084875,    1573128,      23060,    1716065,    1608578,    1204145,    -138990},
  {     412098,     533805,     542286,     948123,    2357544,    1116057,    -956896,     645026,    -248938,     511997,    2028437,     789454,     -94879,   -1495326,     379577,     141671,        137,    -271102,   -2040804,   -1890047,    -685064,    1180007,     504181,     338658,     544527,      14801,     647454,     626950,     929543,     930437,    1375467,    -154979,   10101791,     -51641,    1035746,    1088753,    1098949,    1027681,     279534,     368662,    -248690,    -253606,     219182,    2131242,     183886,     817507,     554735,     733117,     412702,    1478096,    1603695,    1809872,    2194488,    1017334,    1374865,    1905806,    -599126,    1658234,    1188443,    1361112},
  {     710846,     582544,     938840,     847509,    2194488,    1080690,     566500,   -1382240,    -398738,     582183,    1701283,     579841,     106964,   -1411301,     300697,     150298,     109289,    -615937,    -174626,    -122162,     974197,    -673360,   -1874509,    -690022,     133113,    -361836,    -316040,    1084874,    1420834,    1377257,    1573000,    -207553,     -51641,   10316742,    1354558,    1382532,    1120123,    1029649,     163042,     304459,    -232520,    -240058,     446150,    2384819,     676732,     428854,      52848,     838622,    1460686,     385767,     861221,     941340,    3181394,    2126928,    1450482,    1689816,    1555024,    -302301,    1262477,   -2557578},
  {     531854,     518398,     513432,     823198,    1035746,    2301594,    -207989,    -441739,     595298,     -68465,    1063674,    2181651,   -1379009,    -207989,    -513432,    -714527,     605001,     -88030,    -837310,    -518398,     531854,     858688,   -1011857,    1030479,   -1379009,   -2081210,    -278950,    1475487,     491978,    2088435,     491978,    1063674,    1035746,    1354558,   10629882,    -201757,    1475487,     -68465,    -595298,     278950,    1030479,    1011857,    2081210,     441739,     823198,     980270,      88030,     836672,     858688,     837310,     714527,     980270,    1354558,    2449803,    2088435,    2181651,    2301594,    2449803,    -201757,    -247410},
  {     617418,     603574,     132373,     760491,    1188443,    1985767,     255058,    -433341,   -1301930,    1508451,    1204145,    2056497,   -1337772,    -296438,    -583661,    -912445,     376413,      90307,    -684086,    -359546,     641225,     947959,    -881387,    1154656,     220882,     -34398,   -2001203,    -643142,    1803583,    -171109,    -233522,    1815967,    1088753,    1382532,    -201757,   10232054,     416500,    1505096,    1050403,    -688033,     590846,     569944,    1999405,     514031,     797609,    1149437,     266108,     512340,     727388,     715354,     282551,     976350,    1262477,    2210810,    3110960,    1649898,    1267008,    1617815,    3201103,    -662168},
  {     569381,     429213,      88577,     497749,     626950,     456349,    -218289,    -341831,    -327223,     444122,     500478,     318584,     612300,    -338903,    -617749,    -724395,     381604,      46323,     -12117,      55014,     539591,     687597,      20373,     555644,     531510,     148093,     942609,    1630193,    1054012,    1739931,    1202708,      31428,    1098949,    1120123,    1475487,     416500,   10038127,     377647,     491691,    3717806,     698431,     497956,    1843811,     259416,     407036,     514498,    2015366,    2392480,     703575,     548474,     886936,     969010,    1084874,     971353,    -947943,    1580957,     522508,     576540,    -643142,    -762565},
  {     421819,     350288,     360837,     181639,     511997,     211711,     138051,     -34570,    -150855,    -114401,     354489,      85076,    -358107,     422146,     322720,     333894,    -766294,    -786908,     296006,     321309,     774290,     705838,     369675,     628580,     903583,     928995,     330718,     444122,    1253222,     457864,     -13578,    1097416,    1027681,    1029649,     -68465,    1505096,     377647,   10304892,    3811053,     741037,     474565,     369929,     184581,    2024743,    2102675,    2034273,     565518,     478109,     492429,     389124,     655599,     801390,     582183,     848831,    1592741,    -584577,    -677810,    -705664,    1508451,    -358717},
  {     209795,     319924,    -140940,    -417041,     248938,    -643329,      62055,     219882,      79658,     150855,     248832,    -280188,    1001478,    -187219,      87398,      16527,    1178850,     990976,      21883,     110393,    -191338,    -215172,       9644,    -225110,    -427109,    -566398,     459105,     327223,    -387159,     205594,    -599275,     288635,     279534,     163042,    -595298,    1050403,     491691,    3811053,   10364621,    1013772,     808159,     750164,     740730,    -634455,   -1019961,   -1064643,     477785,     468241,     363388,     383068,     914305,     959827,     398738,     809582,    1262478,    2003496,    1978734,    1897300,    1301930,    -375174},
  {    -187607,    -131064,      31598,     -56122,    -647454,     -61929,     235340,     375144,     459105,    -330718,    -298841,     -56984,    -305639,     787936,     952412,    1131648,     -47924,     377848,     446862,     246951,     -33001,    -133451,     365017,    -132479,      59720,     434800,    -349051,    -942609,    -390699,    -928749,     213986,    -658381,     368662,     304459,     278950,    -688033,    3717806,     741037,    1013772,   10596548,     648252,     779507,    -732676,     822447,     616139,     496044,    -991207,   -1285755,     448790,     549076,     654659,     243208,     316040,     222468,    1969096,    1655486,     548725,     452499,    2001203,   -3222343},
  {      38855,    -573935,     -46372,     392609,     338658,     883541,     358754,      33921,     225110,     628580,     268741,     787054,     -40156,     187293,     138673,      71139,     332565,     176847,    -822442,    -752628,    -370811,    1224544,     742391,    1275419,     520787,     230549,     132479,     555644,     506720,     691823,     635757,     813652,    -248690,    -232520,    1030479,     590846,     698431,     474565,     808159,     648252,   10332390,    3801323,     460565,     209682,     410595,     917099,     556792,     778274,    -437370,    2184399,    1778168,    1990107,    -690022,    -767926,     765957,     534694,    1616180,    1625911,    1154656,    1451741},
  {    -246742,     203417,     703250,     386226,    -504181,      40312,    -456209,    -120954,       9644,    -369675,    -568994,     -37089,      36680,     332767,     237041,     419516,      38746,     324349,    1193708,    1015023,     891206,    -787254,    -260763,    -742391,     116650,     540989,     365017,     -20373,      54047,     235428,     681434,     805745,    -253606,    -240058,    1011857,     569944,     497956,     369929,     750164,     779507,    3801323,   10356582,     862962,     420677,     669550,     160927,     564728,     345743,    2226103,    -464886,    -901303,    -987068,    1874509,    1793762,     550179,     259915,    1355668,    1369583,     881387,    1438372},
  {     -70665,    -175601,     141432,    -168048,     -14801,    -831300,     142003,     556038,    -566398,    -928995,    -504155,    -974697,    1280885,   -1006617,    1139783,    1400473,    -264787,    -180275,     339025,      88982,      -8517,     -75243,     540989,    -230549,     170314,     260646,     434800,    -148093,    -383027,     130918,    1881039,    1480632,     219182,     446150,    2081210,    1999405,    1843811,     184581,     740730,    -732676,     460565,     862962,    9542197,     598427,     615335,     753093,   -1011186,   -1314085,     398116,     555681,     202880,    -106704,     361836,    1001736,    -193856,    1626163,     415582,     677944,      34398,     695081},
  {     323680,     277745,    -364301,    -173909,    -645026,      92752,    -705946,    -912101,     219882,      34570,    -619100,    -195461,    -907772,    1510944,    -163448,    -194366,    1033368,    1282467,     -76721,     -48150,    -194997,    -120165,    -120954,     -33921,     374435,     556038,     375144,     341831,     539048,       6903,    1374481,    2028703,    2131242,    2384819,     441739,     514031,     259416,    2024743,    -634455,     822447,     209682,     420677,     598427,    9555644,   -1425603,   -1320694,     880317,     938397,     314696,     388391,     460877,     589699,    1382240,     672308,    1367602,    -201659,    -161409,      48471,     433341,     630957},
  {    -306626,    1142629,    1327432,    1374468,     948123,    1029280,     303846,     173909,     417041,     181639,     657335,     672190,     845735,     -84488,    1465214,    -354274,    -841902,     591665,    -844298,    1010509,    2027614,    2296097,    -386226,     392609,     533201,     168048,      56122,     497749,    1324835,     939640,    1719820,     728989,     183886,     676732,     823198,     797609,     407036,    2102675,   -1019961,     616139,     410595,     669550,     615335,   -1425603,    9525899,    -922605,     383446,     869959,    1424693,     258563,     749565,     970448,     847509,    1270876,    1739733,     322404,    -140179,     304912,     760491,     743682},
  {    1313064,    -511495,     507491,     970448,    1809872,    1870930,       8141,    -589699,    -959827,     801390,     958289,    1067415,     977959,    -168721,    -322981,    1370158,     932180,   -1186711,    1159232,    -548042,     544572,     395949,     987068,    1990107,     361937,     106704,    -243208,     969010,    1076200,     893440,    1797057,     729610,     817507,     428854,     980270,    1149437,     514498,    2034273,   -1064643,     496044,     917099,     160927,     753093,   -1320694,    -922605,    9636580,     553694,     534719,     645482,    1375351,     637431,     991478,     941340,    1371723,    1773876,     214989,     274819,     -87262,     976350,   -2919021},
  {     252035,     690957,     749677,    -591665,     271102,       5936,    -458522,    1282467,     990976,     786908,     184137,     -77371,     -88136,     838816,    -646361,     983080,    1618486,    -144650,     160001,     265956,     360063,     156305,     324349,    -176847,    1478699,    -180275,     377848,     -46323,    1662370,    2205485,     457171,    1329038,     554735,      52848,      88030,     266108,    2015366,     565518,     477785,    -991207,     556792,     564728,   -1011186,     880317,     383446,     553694,    9430347,   -1369689,     349451,     575005,     274854,    1186711,     615937,      27911,    -113147,    1538324,     703750,     628708,     -90307,    -368960},
  {     359595,     138430,    -736067,     869959,     733117,     922600,     938283,    -938397,    -468241,     478109,    1419884,    1592128,     -37750,     938283,     736067,   -1185154,     -89570,    1369689,    -294770,    -138430,     359595,     623743,    -345743,     778274,     -37750,    1314085,    1285755,    2392480,     529993,     560846,     529993,    1419884,     733117,     838622,     836672,     512340,    2392480,     478109,     468241,   -1285755,     778274,     345743,   -1314085,     938397,     869959,     534719,   -1369689,    9863218,     623743,     294770,    1185154,     534719,     838622,     630744,     560846,    1592128,     922600,     630744,     512340,    -229295},
  {    -641626,    2249771,    2283835,    2296097,    1180007,    1163360,     202993,     120165,     215172,     705838,    1026456,     975058,      93016,    -173581,     745609,    -497648,      91780,    -156305,    -280012,     966020,    1429091,     463232,     787254,    1224544,     161601,      75243,     133451,     687597,     928398,     818541,    1063106,     471151,     412702,    1460686,     858688,     727388,     703575,     492429,     363388,     448790,    -437370,    2226103,     398116,     314696,    1424693,     645482,     349451,     623743,    9650591,      40627,      36916,     395949,    -673360,    -715348,    1164234,     570996,     609164,    1662689,     947959,    1171497},
  {    2146670,    -274693,    1289791,     844298,    2040804,    2033501,    -548420,     -76721,      21883,    -296006,     183407,     116100,     -12792,    -227594,     -70697,     826358,     -49667,     160001,    1929874,    1027277,    -650127,     280012,    1193708,     822442,    -217415,     339025,     446862,      12117,     487307,     390691,    1037168,     525818,    1478096,     385767,     837310,     715354,     548474,     389124,     383068,     549076,    2184399,    -464886,     555681,     388391,     258563,    1375351,     575005,     294770,      40627,    9892701,    -875466,   -1159232,     174626,     145880,     881541,     372173,    1423594,     328489,     684086,    1316063},
  {     450372,    1168420,    -918231,     354274,    -141671,    -237440,    1327027,    -194366,      16527,    -333894,    2045993,    2021029,      50568,     105601,    -150896,    -315612,    -239427,     983080,     826358,    -769672,    1055311,     497648,     419516,     -71139,    -310149,    1400473,    1131648,     724395,     382382,     -62102,     380586,     777043,    1603695,     861221,     714527,     282551,     886936,     655599,     914305,     654659,    1778168,    -901303,     202880,     460877,     749565,     637431,     274854,    1185154,      36916,    -875466,    9366725,   -1370158,    -150298,    -240868,     931771,    1014476,    1725934,     617974,     912445,    -999724},
  {     544572,     548042,     322981,    -922605,     817507,     274819,    -168721,    1320694,    1064643,    2034273,     729610,     214989,     361937,       8141,    -507491,    -637431,     932180,    -553694,   -1375351,     511495,    1313064,     645482,    -160927,     917099,     977959,    -753093,    -496044,     514498,    1797057,    1773876,    1076200,     958289,    1809872,     941340,     980270,     976350,     969010,     801390,     959827,     243208,    1990107,    -987068,    -106704,     589699,     970448,     991478,    1186711,     534719,     395949,   -1159232,   -1370158,    9636580,     428854,     -87262,     893440,    1067415,    1870930,    1371723,    1149437,    -933866},
  {     974197,     122162,    -300697,     676732,     -51641,    1555024,   -1411301,   -2384819,    -163042,    1029649,    -207553,    1689816,     133113,     566500,    -938840,    -861221,     109289,     -52848,    -385767,    -582544,     710846,    1460686,     240058,    -232520,     106964,    -446150,    -304459,    1120123,    1573000,    1450482,    1420834,    1701283,    2194488,    3181394,    1354558,    1262477,    1084874,     582183,     398738,     316040,    -690022,    1874509,     361836,    1382240,     847509,     941340,     615937,     838622,    -673360,     174626,    -150298,     428854,   10316742,    -302301,    1377257,     579841,    1080690,    2126928,    1382532,    1240917},
  {     970167,     114411,    -201852,     304912,    1658234,    -306251,     412784,     -48471,   -1897300,    -705664,    1608578,    -650727,     819885,    -228004,    -740063,    -617974,     -14748,    -628708,    -328489,    -324816,     710415,    1662689,   -1369583,    1625911,     296474,    -677944,    -452499,     576540,    1419422,    1195850,    1935230,    1084875,    1017334,    2126928,    2449803,    2210810,     971353,     848831,     809582,     222468,    -767926,    1793762,    1001736,     672308,    1270876,    1371723,      27911,     630744,    -715348,     145880,    -240868,     -87262,    -302301,    9973937,    1164000,    1412675,    1304994,    2348652,    1617815,    1760262},
  {     685179,     353241,    1011354,     939640,     930437,    1265237,     192453,      -6903,    -205594,     457864,     851797,    1127444,   -1541056,     314167,      50541,      62102,   -1583360,   -2205485,    -390691,    -477553,     893382,     818541,    -235428,     691823,     463749,    -130918,     928749,    1739931,    1537872,    1056306,     -43244,    1573128,    1374865,    1450482,    2088435,    3110960,    -947943,    1592741,    1262478,    1969096,     765957,     550179,    -193856,    1367602,    1739733,    1773876,    -113147,     560846,    1164234,     881541,     931771,     893440,    1377257,    1164000,    9924096,    1170942,    1090973,    1195850,    -171109,   -1377678},
  {     842290,     701754,     579317,     672190,     789454,     970157,      33840,     195461,     280188,      85076,     791284,     933159,     138873,   -1430459,   -2059199,   -2021029,     199622,      77371,    -116100,    -150481,    1017050,     975058,      37089,     787054,    1130957,     974697,      56984,     318584,     259178,    1127444,    1336998,      23060,    1905806,    1689816,    2181651,    1649898,    1580957,    -584577,    2003496,    1655486,     534694,     259915,    1626163,    -201659,     322404,     214989,    1538324,    1592128,     570996,     372173,    1014476,    1067415,     579841,    1412675,    1170942,   10318773,    -476988,    -650727,    2056497,   -1196056},
  {     413805,     276705,     689558,    1029280,    1116057,    1398089,     301167,     -92752,     643329,     211711,     723124,     970157,     136776,     294915,     296717,     237440,     169475,      -5936,   -2033501,   -1859624,    -713206,    1163360,     -40312,     883541,    -829956,     831300,      61929,     456349,    2236917,    1265237,    1238487,    1716065,    -599126,    1555024,    2301594,    1267008,     522508,    -677810,    1978734,     548725,    1616180,    1355668,     415582,    -161409,    -140179,     274819,     703750,     922600,     609164,    1423594,    1725934,    1870930,    1080690,    1304994,    1090973,    -476988,    9965406,    -306251,    1985767,     753978},
  {     710415,     324816,     740063,    1270876,    1017334,    1304994,    -228004,    -672308,    -809582,     848831,    1084875,    1412675,     296474,     412784,     201852,     240868,     -14748,     -27911,    -145880,    -114411,     970167,    -715348,   -1793762,    -767926,     819885,   -1001736,    -222468,     971353,    1935230,    1164000,    1419422,    1608578,    1658234,    -302301,    2449803,    1617815,     576540,    -705664,    1897300,     452499,    1625911,    1369583,     677944,      48471,     304912,     -87262,     628708,     630744,    1662689,     328489,     617974,    1371723,    2126928,    2348652,    1195850,    -650727,    -306251,    9973937,    2210810,   -2921216},
  {     641225,     359546,     583661,     797609,    1088753,    1267008,    -296438,    -514031,   -1050403,    1505096,    1815967,    1649898,     220882,     255058,    -132373,    -282551,     376413,    -266108,    -715354,    -603574,     617418,     727388,    -569944,     590846,   -1337772,   -1999405,     688033,     416500,    -233522,    3110960,    1803583,    1204145,    1188443,    1262477,    -201757,    3201103,    -643142,    1508451,    1301930,    2001203,    1154656,     881387,      34398,     433341,     760491,     976350,     -90307,     512340,     947959,     684086,     912445,    1149437,    1382532,    1617815,    -171109,    2056497,    1985767,    2210810,   10232054,   -1554249},
  {     672422,     404334,     198558,     837817,    1137943,    1050572,     171784,    -479562,    -802084,     928627,    1553990,    1903783,     225128,     171784,    -198558,    -466279,     121534,     -47895,    -596881,    -404334,     672422,     876663,    -464691,     728966,     225128,      53151,   -3160187,     431676,    1382550,     570357,    1382550,    1553990,    1137943,    1399098,    1772669,     921690,     431676,     928627,     802084,    3160187,     728966,     464691,     -53151,     479562,     837817,    1060836,      47895,     241465,     876663,     596881,     466279,    1060836,    1399098,    1274290,     570357,    1903783,    1050572,    1274290,     921690,   10842338}
};

static int map[60] = {
 39, 38, 37, 36, 41, 40, 54, 55, 56, 57, 
 58, 59, 49, 48, 52, 53, 50, 51, 42, 43, 
 44, 45, 46, 47, 33, 32, 31, 30, 35, 34, 
 12, 13, 14, 15, 16, 17, 29, 28, 24, 25, 
 27, 26, 21, 20, 19, 18, 23, 22,  2,  3,  
  5,  4,  1,  0, 10, 11,  9,  8,  6,  7};
			       
