# -*- readme-debian -*-

Using aspell with ispell.el
---------------------------

Ispell.el assumes you use ispell, if you use aspell write

(setq ispell-program-name "aspell")

in your {x}emacs configuration file.

ispell.el loading at startup
----------------------------

Emacs comes dumped with an ispell-menu-map containing a set of
dictionaries that won't be what's actually present. To make it match the
actually installed dictionaries some magic is done in the

/etc/emacs/site-start.d/50dictionaries-common.el

file, but that will force loading of ispell.el even if you do not intend
to use it at all. If you do not like that behavior, (lisp) comment the
lines

(setq ispell-menu-xemacs nil)
(ispell-change-dictionary nil)

in that file. Since that is a conffile your changes will be preserved if
you choose that at package upgrade.

Adding customized entries for emacs
-----------------------------------

You can currently do this in two ways in your {x}emacs configuration file,

The classical one, e.g.,

(setq ispell-dictionary-alist
      (append ispell-dictionary-alist
	      '(("british+accs"                           ; British version
		 "[A-Z\321\324a-z\361\364]"
		 "[^A-Z\321\324a-z\361\364]"
		 "[']" 
		 nil 
		 ("-B" "-d" "british-w_accents")
		 nil 
		 iso-8859-1))))

where some dummy accented characters have been added. You will lose this
entry if ispell.el is reloaded.

You can also use the debian-ispell.el provided function
'debian-ispell-add-dictionary-entry'

; --------------------
(if (fboundp 'debian-ispell-add-dictionary-entry)
  (progn
    (debian-ispell-add-dictionary-entry ... )
    (debian-ispell-add-dictionary-entry ... )
  )
)
(setq ispell-dictionary-alist debian-ispell-dictionary-alist)
; --------------------

where each of the calls to 'debian-ispell-add-dictionary-entry' is
something like

; --------------------
(debian-ispell-add-dictionary-entry
  '("british+accs"
    "[A-Z\321\324a-z\361\364]"
    "[^A-Z\321\324a-z\361\364]"
    "[']"
    nil
    ("-B" "-d" "british-w_accents")
    nil
    iso-8859-1)
  "aspell")
; --------------------

Remember to reset ispell-dictionary-list after this, as shown above. Also
better use as above the octal codes for the accented characters rather
than the character itself. This will save you some problems with editors
and with emacs itself.

The trailing "aspell" is currently not used, but is intended to mean
that the dict is available for aspell only. In the future it is possible
that, for systems where both ispell and aspell are installed, can be
implemented an automatic selection of the spellchecker program based on
the value of 'ispell-program-name' and dict availability for that entry
and spellchecker. But this is currently just smoke.

Using ispell-local-dictionary-alist does not currently work, but it
might in the future.

----------------------------------
 -- Agustin Martin Domingo <agmartin@debian.org>, Fri Apr  8 12:23:01 2005

 LocalWords:  debian debconf usr alioth org wordlists wordlist debhelper http
 LocalWords:  iamerican wspanish miscfiles xemacs wbritish var html dpkg
