/*
 * DiaSCE is a code editor for C and C++.
 * Copyright (C) 2000  Ander Lozano Prez
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Ander Lozano Prez
 * c/Juan de Gardeazabal 4, 1 D
 * 48004 Bilbao
 * Vizcaya
 * Spain
 *
 * ander1@wanadoo.es
 */

/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#include <gnome.h>

#include "main.h"

int
main (int argc, char *argv[],char *envp[])
{
	gint estado;
	gint cont;
	gchar *current_dir;
	gchar *temp_name;
	
	estado=0;
	david_ventana_maximizada=FALSE;
	commandline_project = NULL;
	pro_forzando_librerias=FALSE;
	mensajes_button_pressed = FALSE;
	project_has_glade_file = FALSE;
	current_glade_gui_window = NULL;
	glade_window_list= NULL;
	gui_store = NULL;
	bindtextdomain (PACKAGE, PACKAGE_LOCALE_DIR);
	textdomain (PACKAGE);
	
	LIBXML_TEST_VERSION

	gnome_program_init("diasce", VERSION, LIBGNOMEUI_MODULE, argc, argv, GNOME_PROGRAM_STANDARD_PROPERTIES, NULL);
	
	//Parse the commandline to find a project file argument to load.
	if (argc > 1) {
		argv++;
		for (cont = 1; cont < argc; cont++) {
			if (*argv[0] == '-') {
				argv++;
			} else {
				commandline_project = g_strdup(*argv);
				if (!g_path_is_absolute(commandline_project)) {
					if (commandline_project[0] == '.') {
						g_print ("%s\n", _("Use full directory names for project file path, please."));
						exit (0);
					} else {
						current_dir = g_get_current_dir();
						temp_name = g_strdup (commandline_project);
						g_free(commandline_project);
						commandline_project = g_strconcat (current_dir, "/",temp_name, NULL);
						g_free(current_dir);
						g_free(temp_name);
					}
				}
				break;
			}
		}
	}
	
	signal(SIGCHLD,(void *)gen_hijo_muerto);
	
	pix_inicializar();
	edit_inicializar();
	empty_buffer = gtk_source_buffer_new(NULL);
	
	if (gen_create_david_gui() == -1) {
		g_print("%s%s%s\n",_("diasce.glade file not found in "),GLADE_PROJECT,_(". DiaSCE2 is not properly installed"));
		return 0;
	}
	
	gtk_idle_add(david_init,&estado);

	gtk_main ();
	return 0;
}

gboolean david_init(gpointer estado)
{
	GtkTextView *mensajes;
	GdkColor color;
	GtkTextBuffer *buffer;
	static GtkWidget *ventana_principal;
	GtkWidget *widget;
	gchar *commandline_project_utf8;
	gsize read, written;
	GError *error;

	if ((*(guint*)estado)==0) {
		autoconfiguracion=0;
		pro_inicializar();
		buscar_inicializar();
		arch_inicializar();
		gla_gui_treeview_init();
		ext_inicializar();
		cvs_inicializar();
	}

	if ((*(guint*)estado)<=ULTIMA_FASE_AUTODETECCION) {
		pref_abrir((*(guint*)estado));
	}

	if ((*(guint*)estado)==ULTIMA_FASE_AUTODETECCION) {
		
		gen_clipboard=gtk_clipboard_get(gdk_atom_intern("CLIPBOARD",TRUE));
		
		ventana_principal =glade_xml_get_widget(david_ventana,"david_ventana");

		g_set_printerr_handler((GPrintFunc) gen_mensajes_stderr);
		g_set_print_handler((GPrintFunc) gen_mensajes_stdout);
		
		cefv_inicializar();
		
		edit_funciones_buffer=gtk_source_buffer_new(NULL);
		edit_aplicar_reglas_coloreado(edit_funciones_buffer);
		gtk_source_buffer_set_highlight(edit_funciones_buffer,TRUE);
		gtk_text_view_set_editable(GTK_TEXT_VIEW(edit_funciones),TRUE);
		gtk_text_view_set_buffer(GTK_TEXT_VIEW(edit_funciones),GTK_TEXT_BUFFER(edit_funciones_buffer));
		gtk_text_view_set_editable(GTK_TEXT_VIEW(edit_funciones),FALSE);
		
		mensajes=GTK_TEXT_VIEW(glade_xml_get_widget(david_ventana,"mensajes_texto"));
		buffer=gtk_text_view_get_buffer(mensajes);
		color.red=50000;
		color.green=1000;
		color.blue=1000;
		gtk_text_buffer_create_tag(buffer,"mensaje_error","foreground-gdk",&color,NULL);
		
		pref_aplicar();
		gen_anular_funciones();
          /*Aadimos a los menus los ultimos proyectos abiertos*/
          gen_ultimos_proyectos();

		gen_localizar_automake();

		gtk_window_maximize(GTK_WINDOW(ventana_principal));
		gtk_widget_show (ventana_principal);
	}
	
	if ((*(guint*)estado)==ULTIMA_FASE_AUTODETECCION+1) {
		if (!david_ventana_maximizada) {
			return TRUE;
		}
		widget=glade_xml_get_widget(david_ventana,"mensajes_vpaned");
		gtk_paned_set_position(GTK_PANED(widget),GTK_PANED(widget)->max_position-110);
		widget=glade_xml_get_widget(david_ventana,"arboles_hpaned");
		gtk_paned_set_position(GTK_PANED(widget),200);
		
		if (commandline_project != NULL) {
			commandline_project_utf8 = g_locale_to_utf8(commandline_project, -1, &read, &written, &error);
			gen_abrir_proyecto (commandline_project_utf8);
			g_free (commandline_project_utf8);
			g_free (commandline_project);
		} 
		return FALSE;
	}
	
	(*(guint*)estado)++;
	return TRUE;
}
