/*
 * DiaSCE is a code editor for C and C++.
 * Copyright (C) 2000  Ander Lozano Prez
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Ander Lozano Prez
 * c/Juan de Gardeazabal 4, 1 D
 * 48004 Bilbao
 * Vizcaya
 * Spain
 *
 * ander1@wanadoo.es
 */

#include "main.h"

//*******************************************************************

void arch_inicializar(void)
{
	GtkTreeView *tree_view;
	GtkCellRenderer *renderer;
	GtkTreeViewColumn *column;
	GtkTreeSelection *selection;

	DEBUG_MSG(->arch_inicializar);
	arch_store=gtk_tree_store_new(COL_TOTAL,GDK_TYPE_PIXBUF,G_TYPE_STRING);
		
	tree_view=GTK_TREE_VIEW(glade_xml_get_widget(david_ventana,"archivos_arbol"));
	gtk_tree_view_set_model(tree_view,GTK_TREE_MODEL(arch_store));
	
	renderer=gtk_cell_renderer_pixbuf_new();
	column=gtk_tree_view_column_new_with_attributes(NULL,renderer,"pixbuf",COL_ICONO,NULL);
	gtk_tree_view_append_column(tree_view,column);
	renderer=gtk_cell_renderer_text_new();
	column=gtk_tree_view_column_new_with_attributes(NULL,renderer,"text",COL_NOMBRE,NULL);
	gtk_tree_view_append_column(tree_view,column);
	
	selection=gtk_tree_view_get_selection(tree_view);
	gtk_tree_selection_set_mode(selection,GTK_SELECTION_SINGLE);
	g_signal_connect(G_OBJECT(selection),"changed",G_CALLBACK(on_archivos_arbol_tree_select_row),NULL);
	
	gtk_tree_sortable_set_default_sort_func(GTK_TREE_SORTABLE(arch_store),(GtkTreeIterCompareFunc)gen_GtkTreeIterCompareFunc,(gpointer)COL_NOMBRE,NULL);
	gtk_tree_sortable_set_sort_column_id(GTK_TREE_SORTABLE(arch_store),GTK_TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID,GTK_SORT_ASCENDING);
		
	DEBUG_MSG(<-arch_inicializar);
}

/*******************************************************************************
 Esta funcion crea el arbol de archivos con las secciones vacias para
 que luego se vallan introduciendo los arcivos en cada seccion.
 *******************************************************************************/
void arch_crear(void)
{
	GtkTreeView *tree_view;
	char *texto;

	DEBUG_MSG(->arch_crear);
	
	gtk_tree_store_clear(arch_store);
	
	gtk_tree_store_append(arch_store,&arch_raiz,NULL);
	gtk_tree_store_append(arch_store,&arch_cabeceras,&arch_raiz);
	gtk_tree_store_append(arch_store,&arch_fuentes,&arch_raiz);
	gtk_tree_store_append(arch_store,&arch_otros,&arch_raiz);
	
	texto=pro_nombre(UTF8);
	gtk_tree_store_set(arch_store,&arch_raiz,COL_ICONO,pixbufs[PROYECTO],COL_NOMBRE,texto,-1);
	g_free(texto);
	gtk_tree_store_set(arch_store,&arch_cabeceras,COL_ICONO,pixbufs[CABECERAS],COL_NOMBRE,_("Headers"),-1);
	gtk_tree_store_set(arch_store,&arch_fuentes,COL_ICONO,pixbufs[FUENTES],COL_NOMBRE,_("Sources"),-1);
	gtk_tree_store_set(arch_store,&arch_otros,COL_ICONO,pixbufs[OTROS],COL_NOMBRE,_("Others"),-1);
		
	tree_view=GTK_TREE_VIEW(glade_xml_get_widget(david_ventana,"archivos_arbol"));
	gtk_tree_view_expand_all(tree_view);
	
	DEBUG_MSG(<-arch_crear);
}

/*******************************************************************************
 Esta funcion aade un arcivo a la seccion del arbol de archivos correspondiente.
 Para colocar el archivo en usa seccion se basa en la externsion del archivo
 *******************************************************************************/
void arch_anadir(gchar *nombre,GtkTreeIter *nodo)
{
	guint tipo;

	DEBUG_MSG(->arch_anadir);
	tipo=gen_tipo_archivo(nombre);
	switch (tipo) {
		case 0:
			gtk_tree_store_append(arch_store,nodo,&arch_otros);
			gtk_tree_store_set(arch_store,nodo,COL_ICONO,pixbufs[OTROS],COL_NOMBRE,nombre,-1);
			break;
		case 1:
			gtk_tree_store_append(arch_store,nodo,&arch_fuentes);
			gtk_tree_store_set(arch_store,nodo,COL_ICONO,pixbufs[FUENTES],COL_NOMBRE,nombre,-1);
			break;
		case 2:
			gtk_tree_store_append(arch_store,nodo,&arch_cabeceras);
			gtk_tree_store_set(arch_store,nodo,COL_ICONO,pixbufs[CABECERAS],COL_NOMBRE,nombre,-1);
			break;
	};
	DEBUG_MSG(<-arch_anadir);
}

/*******************************************************************************
 Esta funcion elimina una entrada del arbol de archivos
 *******************************************************************************/
void arch_eliminar(gchar *nombre)
{
	struct s_lista_archivos *nodo;

	nodo=edit_conseguir_nodo(nombre);
	gtk_tree_store_remove(arch_store,&(nodo->nodo_arbol));
}
