/*
 * DiaSCE is a code editor for C and C++.
 * Copyright (C) 2000  Ander Lozano Prez
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Ander Lozano Prez
 * c/Juan de Gardeazabal 4, 1 D
 * 48004 Bilbao
 * Vizcaya
 * Spain
 *
 * ander1@wanadoo.es
 */

#include "main.h"

//*******************************************************************

/*******************************************************************************
 Esta funcion es la que decide que programa o archivo es detectado en cada
 fase de la autodeteccion, y va rellentando las estructuras necesarias
 *******************************************************************************/
void det_autodetectar(xmlDocPtr doc,gboolean crear,guint estado)
{
	GtkProgressBar *barra;
	gfloat total,actual;
	gchar *detectado;
	xmlNodePtr nodo;
	FILE *archivo;
	gchar *nombre;
	static gchar *programas,*tmp;
	static gboolean error;
	GtkWidget *ventana;
	gboolean aplicacion;
	
	DEBUG_MSG(->det_autodetectar);
	total=ULTIMA_FASE_AUTODETECCION;
	actual=estado;
	detectado=NULL;
	nombre=NULL;
	archivo=NULL;
	aplicacion=FALSE;
	
	if (estado==1) {
		error=FALSE;
		programas=g_strdup_printf(_("The following programs were not found:\n"));
		tmp=programas;
	}

	nodo=doc->root;
	if ((crear) && (estado==0)) {
		DEBUG_MSG(creando preferencias de autodeteccion);
		xmlNewChild(nodo,NULL,"programas",NULL);
		xmlNewChild(nodo,NULL,"includes",NULL);
		xmlNewChild(nodo,NULL,"librerias",NULL);
		nodo=buscar_nodo_xml(doc->root,"includes");
		xmlNewChild(nodo,NULL,"xml",NULL);
		xmlNewChild(nodo,NULL,"gtk",NULL);
		xmlNewChild(nodo,NULL,"orbit",NULL);
		xmlNewChild(nodo,NULL,"x11",NULL);
		xmlNewChild(nodo,NULL,"gnome",NULL);
		xmlNewChild(nodo,NULL,"glib",NULL);
		xmlNewChild(nodo,NULL,"gnomeui",NULL);
		xmlNewChild(nodo,NULL,"gnorba",NULL);
		xmlNewChild(nodo,NULL,"audiofile",NULL);
		xmlNewChild(nodo,NULL,"esd",NULL);
		xmlNewChild(nodo,NULL,"gmodule",NULL);
		xmlNewChild(nodo,NULL,"imlib",NULL);
		nodo=buscar_nodo_xml(doc->root,"librerias");
		xmlNewChild(nodo,NULL,"xml",NULL);
		xmlNewChild(nodo,NULL,"gtk",NULL);
		xmlNewChild(nodo,NULL,"orbit",NULL);
		xmlNewChild(nodo,NULL,"x11",NULL);
		xmlNewChild(nodo,NULL,"gnome",NULL);
		xmlNewChild(nodo,NULL,"glib",NULL);
		xmlNewChild(nodo,NULL,"gnomeui",NULL);
		xmlNewChild(nodo,NULL,"gnorba",NULL);
		xmlNewChild(nodo,NULL,"audiofile",NULL);
		xmlNewChild(nodo,NULL,"esd",NULL);
		xmlNewChild(nodo,NULL,"gmodule",NULL);
		xmlNewChild(nodo,NULL,"imlib",NULL);
		xmlNewChild(nodo,NULL,"electric_fence",NULL);
	}
	barra=GTK_PROGRESS_BAR(lookup_widget(ventana_inicio,"progreso_barra_autodetect"));
	
	switch (estado) {
		case 0:
			ejecutables.which=FALSE;
			ejecutables.which=det_prog("which which 2>/dev/stdout");
			break;
		case 1:
			aplicacion=FALSE;
			nodo=buscar_nodo_xml(doc->root,"includes");
			nodo=buscar_nodo_xml(nodo,"xml");
			detectado=g_strdup("`xml-config --cflags`");
			break;
		case 2:
			aplicacion=FALSE;
			nodo=buscar_nodo_xml(doc->root,"includes");
			nodo=buscar_nodo_xml(nodo,"gtk");
#ifdef _LINUX
			detectado=g_strdup("`gtk-config --cflags gtk`");
#endif
#ifdef _FREEBSD
			detectado=g_strdup("`gtk12-config --cflags gtk`");
#endif
			break;
		case 3:
			aplicacion=FALSE;
			nodo=buscar_nodo_xml(doc->root,"includes");
			nodo=buscar_nodo_xml(nodo,"orbit");
			if (preferencias.inc_orbit!=NULL) {
				nombre=g_strdup_printf("%s/orbit.h",&(preferencias.inc_orbit[2]));
			}
			archivo=fopen(nombre,"r");
			if (archivo==NULL) {
				DEBUG_MSG(no se encontro orbit.h);
				detectado=det_inc("orbit.h");
			} else {
				fclose(archivo);
				detectado=g_strdup(preferencias.inc_orbit);
			}
			break;
		case 4:
			aplicacion=FALSE;
			nodo=buscar_nodo_xml(doc->root,"includes");
			nodo=buscar_nodo_xml(nodo,"x11");
			if (preferencias.inc_x11!=NULL) {
				nombre=g_strdup_printf("%s/X.h",&(preferencias.inc_x11[2]));
			}
			archivo=fopen(nombre,"r");
			if (archivo==NULL) {
				DEBUG_MSG(no se encontro X.h);
				detectado=det_inc("X.h");
			} else {
				fclose(archivo);
				detectado=g_strdup(preferencias.inc_x11);
			}
			break;
		case 5:
			aplicacion=FALSE;
			nodo=buscar_nodo_xml(doc->root,"includes");
			nodo=buscar_nodo_xml(nodo,"gnome");
			detectado=g_strdup("`gnome-config --cflags gnome`");
			break;
		case 6:
			aplicacion=FALSE;
			nodo=buscar_nodo_xml(doc->root,"includes");
			nodo=buscar_nodo_xml(nodo,"gnomeui");
			detectado=g_strdup("`gnome-config --cflags gnomeui`");
			break;
		case 7:
			aplicacion=FALSE;
			nodo=buscar_nodo_xml(doc->root,"includes");
			nodo=buscar_nodo_xml(nodo,"glib");
#ifdef _LINUX
			detectado=g_strdup("`glib-config --cflags glib`");
#endif
#ifdef _FREEBSD
			detectado=g_strdup("`glib12-config --cflags glib`");
#endif
			break;
		case 8:
			aplicacion=FALSE;
			nodo=buscar_nodo_xml(doc->root,"includes");
			nodo=buscar_nodo_xml(nodo,"gnorba");
			detectado=g_strdup("`gnome-config --cflags gnorba`");
			break;
		case 9:
			aplicacion=FALSE;
			nodo=buscar_nodo_xml(doc->root,"includes");
			nodo=buscar_nodo_xml(nodo,"audiofile");
			detectado=g_strdup("`audiofile-config --cflags`");
			break;
		case 10:
			aplicacion=FALSE;
			nodo=buscar_nodo_xml(doc->root,"includes");
			nodo=buscar_nodo_xml(nodo,"esd");
			detectado=g_strdup("`esd-config --cflags`");
			break;
		case 11:
			aplicacion=FALSE;
			nodo=buscar_nodo_xml(doc->root,"includes");
			nodo=buscar_nodo_xml(nodo,"gmodule");
#ifdef _LINUX
			detectado=g_strdup("`glib-config --cflags gmodule`");
#endif
#ifdef _FREEBSD
			detectado=g_strdup("`glib12-config --cflags gmodule`");
#endif
			break;
		case 12:
			aplicacion=FALSE;
			nodo=buscar_nodo_xml(doc->root,"includes");
			nodo=buscar_nodo_xml(nodo,"imlib");
			detectado=g_strdup("`imlib-config --cflags`");
			break;
		case 13:
			aplicacion=FALSE;
			nodo=buscar_nodo_xml(doc->root,"librerias");
			nodo=buscar_nodo_xml(nodo,"xml");
			detectado=g_strdup("`xml-config --libs`");
			break;
		case 14:
			aplicacion=FALSE;
			nodo=buscar_nodo_xml(doc->root,"librerias");
			nodo=buscar_nodo_xml(nodo,"gtk");
#ifdef _LINUX
			detectado=g_strdup("`gtk-config --libs gtk`");
#endif
#ifdef _FREEBSD
			detectado=g_strdup("`gtk12-config --libs gtk`");
#endif
			break;
		case 15:
			aplicacion=FALSE;
			nodo=buscar_nodo_xml(doc->root,"librerias");
			nodo=buscar_nodo_xml(nodo,"orbit");
			detectado=g_strdup("`orbit-config --libs client` `orbit-config --libs server`");
			break;
		case 16:
			aplicacion=FALSE;
			nodo=buscar_nodo_xml(doc->root,"librerias");
			nodo=buscar_nodo_xml(nodo,"x11");
			if (preferencias.lib_x11!=NULL) {
				nombre=g_strdup_printf("%s/libX11.so",&(preferencias.lib_x11[2]));
			}
			archivo=fopen(nombre,"r");
			if (archivo==NULL) {
				DEBUG_MSG(no se encontro libX11.so);
				detectado=det_lib("libX11.so");
			} else {
				fclose(archivo);
				detectado=g_strdup(preferencias.lib_x11);
			}
			break;
		case 17:
			aplicacion=FALSE;
			nodo=buscar_nodo_xml(doc->root,"librerias");
			nodo=buscar_nodo_xml(nodo,"gnome");
			detectado=g_strdup("`gnome-config --libs gnome`");
			break;
		case 18:
			aplicacion=FALSE;
			nodo=buscar_nodo_xml(doc->root,"librerias");
			nodo=buscar_nodo_xml(nodo,"glib");
#ifdef _LINUX
			detectado=g_strdup("`glib-config --libs glib`");
#endif
#ifdef _FREEBSD
			detectado=g_strdup("`glib12-config --libs glib`");
#endif
			break;
		case 19:
			aplicacion=FALSE;
			nodo=buscar_nodo_xml(doc->root,"librerias");
			nodo=buscar_nodo_xml(nodo,"gnomeui");
			detectado=g_strdup("`gnome-config --libs gnomeui`");
			break;
		case 20:
			aplicacion=FALSE;
			nodo=buscar_nodo_xml(doc->root,"librerias");
			nodo=buscar_nodo_xml(nodo,"gnorba");
			detectado=g_strdup("`gnome-config --libs gnorba`");
			break;
		case 21:
			aplicacion=FALSE;
			nodo=buscar_nodo_xml(doc->root,"librerias");
			nodo=buscar_nodo_xml(nodo,"audiofile");
			detectado=g_strdup("`audiofile-config --libs`");
			break;
		case 22:
			aplicacion=FALSE;
			nodo=buscar_nodo_xml(doc->root,"librerias");
			nodo=buscar_nodo_xml(nodo,"esd");
			detectado=g_strdup("`esd-config --libs`");
			break;
		case 23:
			aplicacion=FALSE;
			nodo=buscar_nodo_xml(doc->root,"librerias");
			nodo=buscar_nodo_xml(nodo,"gmodule");
#ifdef _LINUX
			detectado=g_strdup("`glib-config --libs gmodule`");
#endif
#ifdef _FREEBSD
			detectado=g_strdup("`glib12-config --libs gmodule`");
#endif
			break;
		case 24:
			aplicacion=FALSE;
			nodo=buscar_nodo_xml(doc->root,"librerias");
			nodo=buscar_nodo_xml(nodo,"imlib");
			detectado=g_strdup("`imlib-config --libs`");
			break;
		case 25:
			aplicacion=FALSE;
			nodo=buscar_nodo_xml(doc->root,"librerias");
			nodo=buscar_nodo_xml(nodo,"electric_fence");
			if (preferencias.lib_electric_fence!=NULL) {
				nombre=g_strdup_printf("%s/libefence.so",&(preferencias.lib_electric_fence[2]));
			}
			archivo=fopen(nombre,"r");
			if (archivo==NULL) {
				DEBUG_MSG(no se encontro libefence.so);
				detectado=det_lib("libefence.so");
			} else {
				fclose(archivo);
				detectado=g_strdup(preferencias.lib_electric_fence);
			}
			break;
		case 26:
			aplicacion=TRUE;
			nodo=buscar_nodo_xml(doc->root,"programas");
			DEBUG_MSG(buscando gcc);
			if (det_prog("gcc --version 2> /dev/stdout")) {
				xmlSetProp(nodo,"gcc","1");
				ejecutables.gcc=TRUE;
			} else {
				xmlSetProp(nodo,"gcc","0");
				ejecutables.gcc=FALSE;
			}
			break;
		case 27:
			aplicacion=TRUE;
			nodo=buscar_nodo_xml(doc->root,"programas");
			DEBUG_MSG(buscando make);
#ifdef _NETBSD
			if (det_prog("gmake --version 2> /dev/stdout")) {
#endif
#ifdef _FREEBSD
			if (det_prog("gmake --version 2> /dev/stdout")) {
#endif
#ifdef _LINUX
			if (det_prog("make --version 2> /dev/stdout")) {
#endif
				xmlSetProp(nodo,"make","1");
				ejecutables.make=TRUE;
			} else {
				xmlSetProp(nodo,"make","0");
				ejecutables.make=FALSE;
			}
			break;
		case 28:
			aplicacion=TRUE;
			nodo=buscar_nodo_xml(doc->root,"programas");
			DEBUG_MSG(buscando aclocal);
			if (det_prog("aclocal --version 2> /dev/stdout")) {
				xmlSetProp(nodo,"aclocal","1");
				ejecutables.aclocal=TRUE;
			} else {
				xmlSetProp(nodo,"aclocal","0");
				ejecutables.aclocal=FALSE;
				programas=g_strdup_printf("%s\taclocal\n",tmp);
				g_free(tmp);
				tmp=programas;
				error=TRUE;
			}
			break;
		case 29:
			aplicacion=TRUE;
			nodo=buscar_nodo_xml(doc->root,"programas");
			DEBUG_MSG(buscando automake);
			if (det_prog("automake --version 2> /dev/stdout")) {
				xmlSetProp(nodo,"automake","1");
				ejecutables.automake=TRUE;
			} else {
				xmlSetProp(nodo,"automake","0");
				ejecutables.automake=FALSE;
				programas=g_strdup_printf("%s\tautomake\n",tmp);
				g_free(tmp);
				tmp=programas;
				error=TRUE;
			}
			break;
		case 30:
			aplicacion=TRUE;
			nodo=buscar_nodo_xml(doc->root,"programas");
			DEBUG_MSG(buscando autoconf);
			if (det_prog("autoconf --version 2> /dev/stdout")) {
				xmlSetProp(nodo,"autoconf","1");
				ejecutables.autoconf=TRUE;
			} else {
				xmlSetProp(nodo,"autoconf","0");
				ejecutables.autoconf=FALSE;
				programas=g_strdup_printf("%s\tautoconf\n",tmp);
				g_free(tmp);
				tmp=programas;
				error=TRUE;
			}
			break;
		case 31:
			aplicacion=TRUE;
			nodo=buscar_nodo_xml(doc->root,"programas");
			DEBUG_MSG(buscando glade);
			if (det_prog("glade --version 2> /dev/stdout")) {
				xmlSetProp(nodo,"glade","1");
				ejecutables.glade=TRUE;
			} else {
				xmlSetProp(nodo,"glade","0");
				ejecutables.glade=FALSE;
			}
			break;
		case 32:
			aplicacion=TRUE;
			nodo=buscar_nodo_xml(doc->root,"programas");
			DEBUG_MSG(buscando exuberant-ctags);
			//the executable could be called ctags-exuberant or just ctags, depending on the distro
#ifdef _LINUX
			if (det_prog("ctags-exuberant --version 2> /dev/stdout")) {
#endif
#ifdef _FREEBSD
			if (det_prog("exctags --version 2> /dev/stdout")) {
#endif
				xmlSetProp(nodo,"ctags","1");
				ejecutables.ctags=TRUE;
			} else if (det_prog("ctags --version 2> /dev/stdout")) {
				xmlSetProp(nodo,"ctags","1");
				ejecutables.ctags=TRUE;
			} else {
				xmlSetProp(nodo,"ctags","0");
				ejecutables.ctags=FALSE;
				programas=g_strdup_printf("%s\texuberant-ctags\n",tmp);
				g_free(tmp);
				tmp=programas;
				error=TRUE;
			}
			break;
		case 33:
			aplicacion=TRUE;
			nodo=buscar_nodo_xml(doc->root,"programas");
			DEBUG_MSG(buscando autoheader);
			if (det_prog("autoheader --version 2> /dev/stdout")) {
				xmlSetProp(nodo,"autoheader","1");
				ejecutables.autoheader=TRUE;
			} else {
				xmlSetProp(nodo,"autoheader","0");
				ejecutables.autoheader=FALSE;
				programas=g_strdup_printf("%s\tautoheader\n",tmp);
				g_free(tmp);
				tmp=programas;
				error=TRUE;
			}
			break;
		case 34:
			aplicacion=TRUE;
			nodo=buscar_nodo_xml(doc->root,"programas");
			DEBUG_MSG(buscando lpr);
			if (det_prog("lpr --version 2> /dev/stdout")) {
				xmlSetProp(nodo,"lpr","1");
				ejecutables.lpr=TRUE;
			} else {
				xmlSetProp(nodo,"lpr","0");
				ejecutables.lpr=FALSE;
			}
			break;
		case 35:
			aplicacion=TRUE;
			nodo=buscar_nodo_xml(doc->root,"programas");
			DEBUG_MSG(buscando glib);
#ifdef _LINUX
			if (det_prog("glib-config --version 2> /dev/stdout")) {
#endif
#ifdef _FREEBSD
			if (det_prog("glib12-config --version 2> /dev/stdout")) {
#endif
				xmlSetProp(nodo,"glib-config","1");
				ejecutables.glib_config=TRUE;
			} else {
				xmlSetProp(nodo,"glib-config","0");
				ejecutables.glib_config=FALSE;
#ifdef _LINUX
				programas=g_strdup_printf("%s\tglib-config\n",tmp);
#endif
#ifdef _FREEBSD
				programas=g_strdup_printf("%s\tglib12-config\n",tmp);
#endif
				g_free(tmp);
				tmp=programas;
				error=TRUE;
			}
			break;
		case 36:
			aplicacion=TRUE;
			nodo=buscar_nodo_xml(doc->root,"programas");
			DEBUG_MSG(buscando xml-config);
			if (det_prog("xml-config --version 2> /dev/stdout")) {
				xmlSetProp(nodo,"xml-config","1");
				ejecutables.xml_config=TRUE;
			} else {
				xmlSetProp(nodo,"xml-config","0");
				ejecutables.xml_config=FALSE;
				programas=g_strdup_printf("%s\txml-config\n",tmp);
				g_free(tmp);
				tmp=programas;
				error=TRUE;
			}
			break;
		case 37:
			aplicacion=TRUE;
			nodo=buscar_nodo_xml(doc->root,"programas");
			DEBUG_MSG(buscando gtk-config);
#ifdef _LINUX
			if (det_prog("gtk-config --version 2> /dev/stdout")) {
#endif
#ifdef _FREEBSD
			if (det_prog("gtk12-config --version 2> /dev/stdout")) {
#endif
				xmlSetProp(nodo,"gtk-config","1");
				ejecutables.gtk_config=TRUE;
			} else {
				xmlSetProp(nodo,"gtk-config","0");
				ejecutables.gtk_config=FALSE;
#ifdef _LINUX
				programas=g_strdup_printf("%s\tgtk-config\n",tmp);
#endif
#ifdef _FREEBSD
				programas=g_strdup_printf("%s\tgtk12-config\n",tmp);
#endif
				g_free(tmp);
				tmp=programas;
				error=TRUE;
			}
			break;
		case 38:
			aplicacion=TRUE;
			nodo=buscar_nodo_xml(doc->root,"programas");
			DEBUG_MSG(buscando gnome-config);
			if (det_prog("gnome-config --version 2> /dev/stdout")) {
				xmlSetProp(nodo,"gnome-config","1");
				ejecutables.gnome_config=TRUE;
			} else {
				xmlSetProp(nodo,"gnome-config","0");
				ejecutables.gnome_config=FALSE;
				programas=g_strdup_printf("%s\tgnome-config\n",tmp);
				g_free(tmp);
				tmp=programas;
				error=TRUE;
			}
			break;
		case 39:
			aplicacion=TRUE;
			nodo=buscar_nodo_xml(doc->root,"programas");
			DEBUG_MSG(buscando audiofile-config);
			if (det_prog("audiofile-config --version 2> /dev/stdout")) {
				xmlSetProp(nodo,"audiofile-config","1");
				ejecutables.audiofile_config=TRUE;
			} else {
				xmlSetProp(nodo,"audiofile-config","0");
				ejecutables.audiofile_config=FALSE;
				programas=g_strdup_printf("%s\taudiofile-config\n",tmp);
				g_free(tmp);
				tmp=programas;
				error=TRUE;
			}
			break;
		case 40:
			aplicacion=TRUE;
			nodo=buscar_nodo_xml(doc->root,"programas");
			DEBUG_MSG(buscando esd-config);
			if (det_prog("esd-config --version 2> /dev/stdout")) {
				xmlSetProp(nodo,"esd-config","1");
				ejecutables.esd_config=TRUE;
			} else {
				xmlSetProp(nodo,"esd-config","0");
				ejecutables.esd_config=FALSE;
				programas=g_strdup_printf("%s\tesd-config\n",tmp);
				g_free(tmp);
				tmp=programas;
				error=TRUE;
			}
			break;
		case 41:
			aplicacion=TRUE;
			nodo=buscar_nodo_xml(doc->root,"programas");
			DEBUG_MSG(buscando imlib-config);
			if (det_prog("imlib-config --version 2> /dev/stdout")) {
				xmlSetProp(nodo,"imlib-config","1");
				ejecutables.imlib_config=TRUE;
			} else {
				xmlSetProp(nodo,"imlib-config","0");
				ejecutables.imlib_config=FALSE;
				programas=g_strdup_printf("%s\timlib-config\n",tmp);
				g_free(tmp);
				tmp=programas;
				error=TRUE;
			}
			break;
		case 42:
			aplicacion=TRUE;
			nodo=buscar_nodo_xml(doc->root,"programas");
			DEBUG_MSG(buscando gdb);
			if (det_prog("gdb 2> /dev/stdout")) {
				xmlSetProp(nodo,"gdb","1");
				ejecutables.gdb=TRUE;
			} else {
				xmlSetProp(nodo,"gdb --version","0");
				ejecutables.gdb=FALSE;
			}
			break;
		case 43:
			aplicacion=TRUE;
			nodo=buscar_nodo_xml(doc->root,"programas");
			DEBUG_MSG(buscando ddd);
			if (det_prog("ddd --version 2> /dev/stdout")) {
				xmlSetProp(nodo,"ddd","1");
				ejecutables.ddd=TRUE;
			} else {
				xmlSetProp(nodo,"ddd","0");
				ejecutables.ddd=FALSE;
			}
			break;
		case 44:
			aplicacion=TRUE;
			nodo=buscar_nodo_xml(doc->root,"programas");
			DEBUG_MSG(buscando grep);
			if (det_prog("grep --version 2> /dev/stdout")) {
				xmlSetProp(nodo,"grep","1");
				ejecutables.grep=TRUE;
			} else {
				xmlSetProp(nodo,"grep","0");
				ejecutables.grep=FALSE;
			}
			break;
		case 45:
			aplicacion=TRUE;
			nodo=buscar_nodo_xml(doc->root,"programas");
			if (det_prog("memprof --version 2> /dev/stdout")) {
				xmlSetProp(nodo,"memprof","1");
				ejecutables.memprof=TRUE;
			} else {
				xmlSetProp(nodo,"memprof","0");
				ejecutables.memprof=FALSE;
			}
			break;
		case 46:
			aplicacion=TRUE;
			nodo=buscar_nodo_xml(doc->root,"programas");
			if (det_prog("gnome-terminal --version 2> /dev/stdout")) {
				xmlSetProp(nodo,"gnome_terminal","1");
				ejecutables.gnome_terminal=TRUE;
			} else {
				xmlSetProp(nodo,"gnome_terminal","0");
				ejecutables.gnome_terminal=FALSE;
			}
			break;
	}
	
	if ((estado>=1) && (!aplicacion)) {
		g_free(nombre);
		xmlNodeSetContent(nodo,detectado);
		g_free(detectado);
		gtk_progress_bar_update(barra,actual/total);
	}
	if (aplicacion) {
		gtk_progress_bar_update(barra,actual/total);
	}
	
	if ((error) && (estado==ULTIMA_FASE_AUTODETECCION)) {
		//There are some missing applications
		programas=g_strdup_printf(_("%s\nThey are needed for DiaSCE to work properly. Install them and make sure they are in your path."),tmp);
		g_free(tmp);
		ventana=gnome_error_dialog_parented(programas, GTK_WINDOW(david_ventana));
		gtk_widget_destroy(ventana_inicio);
		gnome_dialog_run_and_close(GNOME_DIALOG(ventana));
	} else if (estado == ULTIMA_FASE_AUTODETECCION) {
		gtk_widget_destroy(ventana_inicio);
	}
	if (estado==ULTIMA_FASE_AUTODETECCION) {
		g_free(programas);
	}
	DEBUG_MSG(<-det_autodetectar);
}

/*******************************************************************************
 Detecta la localizacion de una libreria y devuelve el parametro -L que
 hay que pasar al gcc
 *******************************************************************************/
gchar *det_lib(gchar *nombre)
{
	gchar *lib;
	FILE *tuberia;
	gchar *comando;
	guint mas;
	gchar letra;
	gchar *resultado,*tmp;
	guint cont;
	guint inicio;
	guint total;

	resultado=g_strdup("");
	tmp=resultado;
	lib=NULL;
	total=0;
	comando=g_strdup_printf("find /opt/gnome/lib /lib /usr/lib /usr/X11R6/lib /usr/share/lib /usr/local/lib -name %s 2> /dev/stdout",nombre);
	tuberia=popen(comando,"r");
	do {
		mas=fread(&letra,1,1,tuberia);
		if (mas) {
			total++;
			resultado=g_strdup_printf("%s%c",tmp,letra);
			g_free(tmp);
			tmp=resultado;
		}
	} while (mas);
	pclose(tuberia);
	cont=0;
	do {
		if (resultado[cont]=='/') {
			inicio=cont;
			for (;resultado[cont]!='\n';cont++);
			for (;resultado[cont]!='/';cont--);
			resultado[cont]=0;
			lib=g_strdup_printf("-L%s",&(resultado[inicio]));
		} else {
			for (;resultado[cont]!='\n';cont++);
			cont++;
		}
	} while ((cont!=total) && (lib==NULL));
	g_free(resultado);

	return lib;
}

/*******************************************************************************
 Detecta la localizacion de un archivo de cabecera y devuelve el parametro
 -I que hay que pasar al gcc
 *******************************************************************************/
gchar *det_inc(gchar *nombre)
{
	gchar *inc;
	FILE *tuberia;
	gchar *comando;
	guint mas;
	gchar letra;
	gchar *resultado,*tmp;
	guint cont;
	guint inicio;
	guint total;
	
	resultado=g_strdup("");
	tmp=resultado;
	inc=NULL;
	total=0;
	comando=g_strdup_printf("find /opt/gnome/include /opt/gnome/lib /usr/include /usr/lib /usr/X11R6/include /usr/share/include /usr/local/include -name %s 2> /dev/stdout",nombre);
	tuberia=popen(comando,"r");
	do {
		mas=fread(&letra,1,1,tuberia);
		if (mas) {
			total++;
			resultado=g_strdup_printf("%s%c",tmp,letra);
			g_free(tmp);
			tmp=resultado;
		}
	} while (mas);
	pclose(tuberia);
	cont=0;
	do {
		if (resultado[cont]=='/') {
			inicio=cont;
			for (;resultado[cont]!='\n';cont++);
			for (;resultado[cont]!='/';cont--);
			resultado[cont]=0;
			inc=g_strdup_printf("-I%s",&(resultado[inicio]));
		} else {
			for (;resultado[cont]!='\n';cont++);
			cont++;
		}
	} while ((cont!=total) && (inc==NULL));
	g_free(resultado);
	return inc;
}

/*******************************************************************************
 Devuelve verdadero o falso dependiendo de si un programa puede
 ser ejecutado por diasce o no
 *******************************************************************************/
gboolean det_prog(gchar *nombre)
{
	FILE *tuberia;
	gint salida;
	gchar letra;
	gchar *cadena;
	gchar *temporal;
	guint mas;
	gboolean error;
	gint cont;
	gchar *comando;
	gchar *parametro;
	
	if (ejecutables.which) {
		comando=g_strdup_printf("which %s",nombre);
		parametro=strstr(comando,"--version");
		if (parametro!=NULL) {
			for (cont=0;cont<9;cont++) {
				parametro[cont]=' ';
			}
		}
		DEBUG_MSG(usando which para detectar);
	} else {
		comando=g_strdup(nombre);
		DEBUG_MSG(detectando sin which);
	}
	tuberia=popen(comando,"r");
	temporal=NULL;
	cadena=NULL;
	do {
		mas=fread(&letra,1,1,tuberia);
		if (mas) {
			if (temporal!=NULL) {
				cadena=g_strdup_printf("%s%c",temporal,letra);
				g_free(temporal);
				temporal=cadena;
			} else {
				cadena=g_strdup_printf("%c",letra);
				temporal=cadena;
			}
		}
	} while ((mas) && (letra!='\n'));
	error=FALSE;
	if (cadena!=NULL) {
		for (cont=0;(cadena[cont]!=':') && (cadena[cont]!=0);cont++);
		if (cadena[cont]==':') {
			cont++;
		}
		for (;(cadena[cont]!=':') && (cadena[cont]!=0);cont++);
		if (cadena[cont]==':') {
			cont+=2;
			error=(strcmp(&cadena[cont],"command not found\n")!=0);
		} else error=TRUE;
		g_free(cadena);
	}
	salida=pclose(tuberia);
	g_free(comando);
	
	return error;
}
