/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2002-2005 Christian Schallhart
 *               2006-2007 model.in.tum.de group
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/unittest/build_test_suite.hpp
 *
 * @brief [LEVEL: beta] Declaration of the @ref diagnostics::unittest::build_test_suite method.
 *
 * $Id: build_test_suite.hpp,v 1.4 2005/06/23 09:54:24 esdentem Exp $
 * 
 * @author Christian Schallhart
 *
 * @test none
 */
#ifndef DIAGNOSTICS__UNITTEST__BUILD_TEST_SUITE_HPP__INCLUDE_GUARD
#define DIAGNOSTICS__UNITTEST__BUILD_TEST_SUITE_HPP__INCLUDE_GUARD

#include <diagnostics/frame/namespace.hpp>
#include <diagnostics/unittest/namespace.hpp>

DIAGNOSTICS_NAMESPACE_BEGIN;
UNITTEST_NAMESPACE_BEGIN;

// used by reference in the interface
// diagnostics/unittest/test_suite.hpp
class Test_Suite;

/**
 * @brief This method is used by test backends to obtain the tests of
 * the current test-driver (the cpp file, which contains the unittest).
 */
Test_Suite* build_test_suite();

UNITTEST_NAMESPACE_END;
DIAGNOSTICS_NAMESPACE_END;

#endif

// vim:ts=4:sw=4
