/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2002-2005 Christian Schallhart
 *               2006-2007 model.in.tum.de group
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/macros/relation_modifier.hpp
 *
 * $Id: relation_modifier.hpp,v 1.2 2005/06/23 09:54:22 esdentem Exp $
 *
 * @author Christian Schallhart
 *
 * @brief [LEVEL: beta] @ref DIAGNOSTICS_RELATION is used to wrap a
 * comparision A OP B such that the conctents A and B are logged if
 * the comparision fails.
 *
 * @test diagnostics/macros/relation_modifier.t.cpp
 */

#ifndef DIAGNOSTICS__MACROS__RELATION_MODIFIER_HPP__INCLUDE_GUARD
#define DIAGNOSTICS__MACROS__RELATION_MODIFIER_HPP__INCLUDE_GUARD

#include <diagnostics/util/to_string.hpp>


/**
 * @brief This macro is used to adapt ASSERT and CHECK macros such
 * that they assert or a relation. If the relation is satisfied, the
 * arguments to the comparision are converted to strings and included
 * into the exception what and the log message.
 *
 * for example: DIAGNOSTICS_RELATION(DIAGNOSTICS_AUDIT_ASSERT1,Test_Exception,min,<=,max);
 *
 * This macros is usually wrapped into other macros for the sake of succinctness.
 */ 
#define DIAGNOSTICS_RELATION(MACRO,NAME,OP1,REL,OP2) \
     MACRO(NAME,\
          ((OP1) REL (OP2)), \
          "(" #OP1 ")" #REL "(" #OP2 ") EVALUATES TO (" \
           + ::diagnostics::internal::to_string((OP1),")",#REL,"(",(OP2),")"))


#endif

// vim:ts=4:sw=4
