/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2002-2005 Christian Schallhart
 *               2006-2007 model.in.tum.de group
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/instrumentation.hpp
 *
 * $Id$
 *
 * @author Christian Schallhart
 *
 * @brief [LEVEL: beta] Use-Case: The include file is used in a
 * main-component (i.e., a component which contains the main()
 * procedure) to switch on instrumentation analysis. 
 *
 * @attention: Causes Instrumentation Allocations/Deallocations to be slow!
 */


#ifndef DIAGNOSTICS__INSTRUMENTATION__INCLUDE_GUARD
#define DIAGNOSTICS__INSTRUMENTATION__INCLUDE_GUARD

#include <diagnostics/extensions/instrumentation/annotations.hpp>

// ATTENTION: defined a second time in diagnostics/annotations.hpp
#ifndef DIAGNOSTICS_DEBUG__LEVEL__
#  define DIAGNOSTICS_DEBUG__LEVEL__ 2
#endif

////////////////////////////////////////////////////////////////////////////////

// AUDIT

#if DIAGNOSTICS_DEBUG__LEVEL__ > 1
#  define DIAGNOSTICS_AUDIT_INSTRUMENT_C_CALL(LIB_NAME,RETURN_TYPE,PROC,ARGS,THROW,CALL,MESG) \
          DIAGNOSTICS_BASE_INSTRUMENT_C_CALL(::diagnostics::LEVEL_AUDIT,LIB_NAME,RETURN_TYPE,PROC,ARGS,THROW,CALL,MESG) 
#else 
#  define DIAGNOSTICS_AUDIT_INSTRUMENT_C_CALL(LIB_NAME,RETURN_TYPE,PROC,ARGS,THROW,CALL,MESG)
          void do_not_call_this_method_which_is_only_declared_for_a_semicolon(void)
#endif

////////////////////////////////////////////////////////////////////////////////

// DEBUG

#if DIAGNOSTICS_DEBUG__LEVEL__ > 0
#  define DIAGNOSTICS_DEBUG_INSTRUMENT_C_CALL(LIB_NAME,RETURN_TYPE,PROC,ARGS,THROW,CALL,MESG) \
          DIAGNOSTICS_BASE_INSTRUMENT_C_CALL(::diagnostics::LEVEL_DEBUG,LIB_NAME,RETURN_TYPE,PROC,ARGS,THROW,CALL,MESG) 
#else 
#  define DIAGNOSTICS_DEBUG_INSTRUMENT_C_CALL(LIB_NAME,RETURN_TYPE,PROC,ARGS,THROW,CALL,MESG)
          void do_not_call_this_method_which_is_only_declared_for_a_semicolon(void)
#endif

////////////////////////////////////////////////////////////////////////////////

// PROD

#define DIAGNOSTICS_PROD_INSTRUMENT_C_CALL(LIB_NAME,RETURN_TYPE,PROC,ARGS,THROW,CALL,MESG) \
        DIAGNOSTICS_BASE_INSTRUMENT_C_CALL(::diagnostics::LEVEL_PROD,LIB_NAME,RETURN_TYPE,PROC,ARGS,THROW,CALL,MESG) 

#endif

// vim:ts=4:sw=4

