/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2002-2005 Christian Schallhart
 *               2006-2007 model.in.tum.de group
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/frame/exception.hpp
 *
 * $Id: exception.hpp,v 1.15 2005/06/23 09:54:18 esdentem Exp $
 *
 * @author Christian Schallhart
 *
 * @brief [LEVEL: beta] @ref diagnostics::Exception Interface
 */

#ifndef DIAGNOSTICS__FRAME__EXCEPTION_HPP__INCLUDE_GUARD
#define DIAGNOSTICS__FRAME__EXCEPTION_HPP__INCLUDE_GUARD

#include <diagnostics/frame/namespace.hpp>

/**
 * @brief set to throw() if you have ::std::exception::~exception()
 * and ::std::exception::~what() declared with throw()
 */
#ifndef DIAGNOSTICS_EXCEPTIONS_THROW_DECL
#  define DIAGNOSTICS_EXCEPTIONS_THROW_DECL throw()
#endif

// used in the interface by reference
#include <string>

// used as base class
#include <exception>

DIAGNOSTICS_NAMESPACE_BEGIN;

/**
 * @class Exception diagnostics/frame/exception.hpp
 *
 * @brief Abstract base class for all exceptions of diagnostics. You
 * _can_ use it as base class for you execeptions, too. 
 *
 * @attention If you do not use it as base class for your exception
 * (and there is no problem with doing so), make sure the @ref
 * DIAGNOSTICS_BASE_EXCEPTION_TYPE and @ref
 * DIAGNOSTICS_BASE_EXCEPTION_STR_WHAT are set suitable.
 *
 * @nosubgrouping
 */
class Exception
    : public ::std::exception
{
    ////////////////////////////////////////////////////////////////////////////////
    /**
     * @name Creation
     * @{
     */
public:
    /**
     * @brief noop
     *
     * @throw never
     */
    virtual ~Exception() DIAGNOSTICS_EXCEPTIONS_THROW_DECL;
    // @}

    
    ////////////////////////////////////////////////////////////////////////////////
    /**
     * @name Accessors
     * @{
     */
public:
    /**
     * @brief returns the case for the trouble.
     *
     * @throw never
     */
    virtual char const * what() const DIAGNOSTICS_EXCEPTIONS_THROW_DECL =0;

    /**
     * @brief returns the name of the exception
     *
     * @throw never
     */
    virtual char const * name() const =0;
    // @}
};


DIAGNOSTICS_NAMESPACE_END;

#endif

// vim:ts=4:sw=4
