/*
 * Unit tests for DiaShapeArt
 */

#define TEST_INITIALIZATION \
		gtk_init (&argc, &argv); \
		gtk_widget_push_colormap (gdk_rgb_get_cmap ())

#include <diacanvas/dia-shape-art.h>
#include <diacanvas/dia-canvas-box.h>
#include "unit-test.h"
#include "test-item.c"
#include <gtk/gtkmain.h>
#include <gtk/gtkwindow.h>
#include <libart_lgpl/art_svp.h>
#include <libart_lgpl/art_svp_vpath_stroke.h>
#include <libart_lgpl/art_svp_vpath.h>
#include <libart_lgpl/art_svp_wind.h>

DiaCanvas *canvas = NULL;
GtkWidget *window = NULL;
DiaCanvasView *view = NULL;

void setup (void)
{
	canvas = dia_canvas_new ();

	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	view = (DiaCanvasView*) dia_canvas_view_new (canvas, TRUE);
	gtk_container_add (GTK_CONTAINER (window), GTK_WIDGET (view));
	gtk_widget_show_all (window);

	TEST_EMPTY_QUEUE();
}

void teardown (void)
{
	gtk_object_destroy (GTK_OBJECT (window));
	//g_object_unref (window);
	g_object_unref (canvas);
	canvas = NULL;
	window = NULL;
	view = NULL;

	TEST_EMPTY_QUEUE();
}

TEST_BEGIN (DiaShapeArt, setup, teardown)

TEST_NEW (box)
{
	DiaCanvasItem *box = dia_canvas_item_create (DIA_TYPE_CANVAS_BOX, 
				"width", 75.0, "height", 75.0,
				"color", DIA_COLOR_A (100, 50, 180, 250),
				NULL);
	int i;

	dia_canvas_groupable_add (DIA_CANVAS_GROUPABLE (canvas->root), box);
	for (i = 0; i < 10; i++) {
		dia_canvas_item_request_update (box);

		TEST_EMPTY_QUEUE();
		TEST_EMPTY_QUEUE();
		TEST_EMPTY_QUEUE();
	}
	g_object_unref (box);
}

TEST_NEW(possible_libArt_memleak)
{
	ArtVpath *path = art_new (ArtVpath, 3);
	ArtSVP *svp, *tmp_svp;
	DiaPoint start = { 0.0, 0.0 }, end = { 100.0, 70.0 };

	path[0].code = ART_MOVETO;
	path[0].x = start.x;
	path[0].y = start.y;
	path[1].code = ART_LINETO;
	path[1].x = end.x;
	path[1].y = end.y;
	path[2].code = ART_END;
	path[2].x = 0;
	path[2].y = 0;

	svp = art_svp_vpath_stroke (path,
				    ART_PATH_STROKE_JOIN_ROUND,
				    ART_PATH_STROKE_CAP_ROUND,
				    1.0,
				    4,
				    0.25);
	art_free (path);
	tmp_svp = art_svp_uncross (svp);
	art_svp_free (svp);
	svp = art_svp_rewind_uncrossed (tmp_svp, ART_WIND_RULE_NONZERO);                art_svp_free (tmp_svp);
	art_svp_free (svp);
}

TEST_END ()
