
#define NO_IMPORT_PYGOBJECT 1
#define NO_IMPORT_PYGTK 1
#include <pygobject.h>

#include <diacanvas/dia-undo.h>
#include <diacanvas/dia-undo-manager.h>


typedef struct {
	DiaUndoAction action;

	PyObject *self;
} PyUndoAction;

static void
py_undo_action_undo (DiaUndoAction *action)
{
	PyObject *self = ((PyUndoAction*) action)->self;
	PyObject *py_ret;

	py_ret = PyObject_CallMethod (self, "undo", "");
	if (!py_ret) {
		PyErr_Print();
		PyErr_Clear();
	} else
		Py_DECREF (py_ret);
}

static void
py_undo_action_redo (DiaUndoAction *action)
{
	PyObject *self = ((PyUndoAction*) action)->self;
	PyObject *py_ret;

	py_ret = PyObject_CallMethod (self, "redo", "");
	if (!py_ret) {
		PyErr_Print();
		PyErr_Clear();
	} else
		Py_DECREF (py_ret);
}

static void
py_undo_action_destroy (gpointer action)
{
	Py_DECREF (((PyUndoAction*) action)->self);
	((PyUndoAction*) action)->self = NULL;
}

DiaUndoAction*
py_undo_action_new (PyObject *self)
{
	PyUndoAction * action;
	
	g_return_val_if_fail (self != NULL, NULL);

	action = (PyUndoAction*) dia_undo_action_new (sizeof (PyUndoAction),
						   py_undo_action_undo,
						   py_undo_action_redo,
						   py_undo_action_destroy);
	action->self = self;
	Py_INCREF (self);

	return (DiaUndoAction*) action;
}

/*
 * UndoManager
 */

#define METHOD_PREFIX "on_"

void
pydia_undo_manager_begin_transaction (DiaUndoManager *undo_manager)
{
	PyObject *self;

	self = pygobject_new ((GObject*) undo_manager);

#ifdef ENABLE_DEBUG_UNDO
	g_message (G_STRLOC": self = %p, obj = %p", self, group);
#endif

	if (PyObject_HasAttrString (self, METHOD_PREFIX "begin_transaction")) {
		PyObject *py_ret;

		pyg_block_threads();

		py_ret = PyObject_CallMethod (self,
					      METHOD_PREFIX "begin_transaction",
					      "");

		if (py_ret) {
			Py_DECREF (py_ret);
		} else {
			PyErr_Print ();
			PyErr_Clear ();
		}
		pyg_unblock_threads();
	} else {
		g_signal_stop_emission_by_name (undo_manager, "begin_transaction");
	}
	Py_DECREF (self);
}

void
pydia_undo_manager_commit_transaction (DiaUndoManager *undo_manager)
{
	PyObject *self;

	self = pygobject_new ((GObject*) undo_manager);

#ifdef ENABLE_DEBUG_UNDO
	g_message (G_STRLOC": self = %p, obj = %p", self, group);
#endif

	if (PyObject_HasAttrString (self, METHOD_PREFIX "commit_transaction")) {
		PyObject *py_ret;

		pyg_block_threads();

		py_ret = PyObject_CallMethod (self,
					      METHOD_PREFIX "commit_transaction",
					      "");

		if (py_ret) {
			Py_DECREF (py_ret);
		} else {
			PyErr_Print ();
			PyErr_Clear ();
		}
		pyg_unblock_threads();
	} else {
		g_signal_stop_emission_by_name (undo_manager, "commit_transaction");
	}
	Py_DECREF (self);
}

void
pydia_undo_manager_discard_transaction (DiaUndoManager *undo_manager)
{
	PyObject *self;

	self = pygobject_new ((GObject*) undo_manager);

#ifdef ENABLE_DEBUG_UNDO
	g_message (G_STRLOC": self = %p, obj = %p", self, group);
#endif

	if (PyObject_HasAttrString (self, METHOD_PREFIX "discard_transaction")) {
		PyObject *py_ret;

		pyg_block_threads();

		py_ret = PyObject_CallMethod (self,
					      METHOD_PREFIX "discard_transaction",
					      "");

		if (py_ret) {
			Py_DECREF (py_ret);
		} else {
			PyErr_Print ();
			PyErr_Clear ();
		}
		pyg_unblock_threads();
	} else {
		g_signal_stop_emission_by_name (undo_manager, "discard_transaction");
	}
	Py_DECREF (self);
}

void
pydia_undo_manager_undo_transaction (DiaUndoManager *undo_manager)
{
	PyObject *self;

	self = pygobject_new ((GObject*) undo_manager);

#ifdef ENABLE_DEBUG_UNDO
	g_message (G_STRLOC": self = %p, obj = %p", self, group);
#endif

	if (PyObject_HasAttrString (self, METHOD_PREFIX "undo_transaction")) {
		PyObject *py_ret;

		pyg_block_threads();

		py_ret = PyObject_CallMethod (self,
					      METHOD_PREFIX "undo_transaction",
					      "");

		if (py_ret) {
			Py_DECREF (py_ret);
		} else {
			PyErr_Print ();
			PyErr_Clear ();
		}
		pyg_unblock_threads();
	} else {
		g_signal_stop_emission_by_name (undo_manager, "undo_transaction");
	}
	Py_DECREF (self);
}

void
pydia_undo_manager_redo_transaction (DiaUndoManager *undo_manager)
{
	PyObject *self;

	self = pygobject_new ((GObject*) undo_manager);

#ifdef ENABLE_DEBUG_UNDO
	g_message (G_STRLOC": self = %p, obj = %p", self, group);
#endif

	if (PyObject_HasAttrString (self, METHOD_PREFIX "redo_transaction")) {
		PyObject *py_ret;

		pyg_block_threads();

		py_ret = PyObject_CallMethod (self,
					      METHOD_PREFIX "redo_transaction",
					      "");

		if (py_ret) {
			Py_DECREF (py_ret);
		} else {
			PyErr_Print ();
			PyErr_Clear ();
		}
		pyg_unblock_threads();
	} else {
		g_signal_stop_emission_by_name (undo_manager, "redo_transaction");
	}
	Py_DECREF (self);
}

void
pydia_undo_manager_add_undo_action (DiaUndoManager *undo_manager,
				    DiaUndoAction *action)
{
	PyObject *self;

	self = pygobject_new ((GObject*) undo_manager);

#ifdef ENABLE_DEBUG_UNDO
	g_message (G_STRLOC": self = %p, obj = %p", self, group);
#endif

	if (PyObject_HasAttrString (self, METHOD_PREFIX "add_undo_action")) {
		PyObject *py_ret, *py_action;

		py_action = pyg_boxed_new (DIA_TYPE_UNDO_ACTION,
					  action, FALSE, FALSE);

		pyg_block_threads();

		py_ret = PyObject_CallMethod (self,
					      METHOD_PREFIX "add_undo_action",
					      "O", py_action);

		Py_DECREF (py_action);

		if (py_ret) {
			Py_DECREF (py_ret);
		} else {
			PyErr_Print ();
			PyErr_Clear ();
		}
		pyg_unblock_threads();
	} else {
		g_signal_stop_emission_by_name (undo_manager, "add_undo_action");
	}
	Py_DECREF (self);
}

gboolean
pydia_undo_manager_in_transaction (DiaUndoManager *undo_manager)
{
	PyObject *self;
	gboolean ret = FALSE;

	self = pygobject_new ((GObject*) undo_manager);

#ifdef ENABLE_DEBUG_UNDO
	g_message (G_STRLOC": self = %p, obj = %p", self, group);
#endif

	if (PyObject_HasAttrString (self, METHOD_PREFIX "in_transaction")) {
		PyObject *py_ret;

		pyg_block_threads();

		py_ret = PyObject_CallMethod (self,
					      METHOD_PREFIX "in_transaction",
					      "");

		if (py_ret) {
			if (PyObject_IsTrue (py_ret))
				ret = TRUE;
			Py_DECREF (py_ret);
		} else {
			PyErr_Print ();
			PyErr_Clear ();
		}
		pyg_unblock_threads();
	}
	Py_DECREF (self);

	return ret;
}

gboolean
pydia_undo_manager_can_undo (DiaUndoManager *undo_manager)
{
	PyObject *self;
	gboolean ret = FALSE;

	self = pygobject_new ((GObject*) undo_manager);

#ifdef ENABLE_DEBUG_UNDO
	g_message (G_STRLOC": self = %p, obj = %p", self, group);
#endif

	if (PyObject_HasAttrString (self, METHOD_PREFIX "can_undo")) {
		PyObject *py_ret;

		pyg_block_threads();

		py_ret = PyObject_CallMethod (self,
					      METHOD_PREFIX "can_undo",
					      "");

		if (py_ret) {
			if (PyObject_IsTrue (py_ret))
				ret = TRUE;
			Py_DECREF (py_ret);
		} else {
			PyErr_Print ();
			PyErr_Clear ();
		}
		pyg_unblock_threads();
	}
	Py_DECREF (self);

	return ret;
}

gboolean
pydia_undo_manager_can_redo (DiaUndoManager *undo_manager)
{
	PyObject *self;
	gboolean ret = FALSE;

	self = pygobject_new ((GObject*) undo_manager);

#ifdef ENABLE_DEBUG_UNDO
	g_message (G_STRLOC": self = %p, obj = %p", self, group);
#endif

	if (PyObject_HasAttrString (self, METHOD_PREFIX "can_redo")) {
		PyObject *py_ret;

		pyg_block_threads();

		py_ret = PyObject_CallMethod (self,
					      METHOD_PREFIX "can_redo",
					      "");

		if (py_ret) {
			if (PyObject_IsTrue (py_ret))
				ret = TRUE;
			Py_DECREF (py_ret);
		} else {
			PyErr_Print ();
			PyErr_Clear ();
		}
		pyg_unblock_threads();
	}
	Py_DECREF (self);

	return ret;
}

void
pydia_undo_manager_init (DiaUndoManagerIface *iface)
{
	iface->begin_transaction = pydia_undo_manager_begin_transaction;
	iface->commit_transaction = pydia_undo_manager_commit_transaction;
	iface->discard_transaction = pydia_undo_manager_discard_transaction;
	iface->undo_transaction = pydia_undo_manager_undo_transaction;
	iface->redo_transaction = pydia_undo_manager_redo_transaction;
	iface->in_transaction = pydia_undo_manager_in_transaction;
	iface->can_undo = pydia_undo_manager_can_undo;
	iface->can_redo = pydia_undo_manager_can_redo;
	iface->add_undo_action = pydia_undo_manager_add_undo_action;
}

