/**************************************************************
  (C) 1997 by Achim Kaiser

  You may distribute under the terms of the GNU General Public
  License as specified in the COPYING file.
**************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <gtk/gtk.h>
#include "gtkhelp.h"
#include "gui.h"
#include "iwc.h"
#include "MwmUtil.h"
#include "iconmanager.h"
#include "stringfunctions.h"
#include "filemanager.h"
#include <X11/Xatom.h>
#include <stdlib.h>
#include <string.h>
#include "global.h"

#include "includepixmaps/dfmlogo.xpm"

#include <libintl.h>
#define _(string) gettext(string)

int exitvar=0;
GtkWidget *obj_ret;
GtkWidget *window;

void initgui(int* argc,char* *argv[])
{
  /*fl_initialize(&argc,argv,"DFM",0,0);
  SetDisplay(fl_get_display());*/
  gtk_init (argc, argv);
}

void destroying(GtkWidget *widget, GdkEvent *event, gpointer data)
{
  exitvar=CANCEL;
  gtk_main_quit ();
  gtk_widget_destroy(window);
}

void ExitCallback(GtkWidget *widget, gpointer data)
{
  exitvar=CANCEL;
  gtk_main_quit ();
  gtk_widget_destroy(window);
}

void YesCallback(GtkWidget *widget, gpointer data)
{
  exitvar=YES;
  gtk_main_quit ();
  gtk_widget_destroy(window);
}

void AllCallback(GtkWidget *widget, gpointer data)
{
  exitvar=ALL;
  gtk_main_quit ();
  gtk_widget_destroy(window);
}

void NoCallback(GtkWidget *widget, gpointer data)
{
  exitvar=NO;
  gtk_main_quit ();
  gtk_widget_destroy(window);
}

void RenameCallback(GtkWidget *widget, gpointer data)
{
  gchar *entry_text;
  
  entry_text = gtk_entry_get_text(GTK_ENTRY(obj_ret));
  *((char**)data)=strdup(entry_text);
  exitvar=RENAME;
  gtk_main_quit ();
  gtk_widget_destroy(window);
}

void DFMguiMainLoop()
{
  /*XEvent event;*/
  
  exitvar=0;
  mygtk_main();
  /*while(XEventsQueued(GetDisplay(),QueuedAfterReading)!=0)
    XNextEvent(GetDisplay(),&event);*/
}

void Info()
{
  GtkWidget *vbox;
  GtkWidget *logo;
  GtkWidget *label;
  GtkWidget *button;
  GdkPixmap* pixmap;
  GdkBitmap* mask;

  window = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_window_set_title(GTK_WINDOW(window), _("Control"));
  gtk_window_position(GTK_WINDOW(window),GTK_WIN_POS_CENTER);
  gtk_container_border_width(GTK_CONTAINER(window), 10);
  
  vbox=gtk_vbox_new(FALSE, 10);
  gtk_container_add(GTK_CONTAINER(window),vbox);
  gtk_widget_show(vbox);
  
  pixmap = gdk_pixmap_create_from_xpm_d(window->window,&mask,NULL,dfmlogo_xpm);
  logo = gtk_pixmap_new(pixmap, mask); 
  gtk_box_pack_start(GTK_BOX(vbox), logo, TRUE, TRUE, 0);
  gtk_widget_show(logo);

  label = gtk_label_new (VERSION);
  gtk_label_set_justify (GTK_LABEL(label),GTK_JUSTIFY_CENTER);
  gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
  gtk_widget_show(label);

  label = gtk_label_new ("Desktop-File-Manager");
  gtk_label_set_justify (GTK_LABEL(label),GTK_JUSTIFY_CENTER);
  gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
  gtk_widget_show(label);

  label = gtk_label_new ("(c) 1997/98/99 Achim Kaiser");
  gtk_label_set_justify (GTK_LABEL(label),GTK_JUSTIFY_CENTER);
  gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
  gtk_widget_show(label);

  label = gtk_label_new ("Distribute only under GNU GPL");
  gtk_label_set_justify (GTK_LABEL(label),GTK_JUSTIFY_CENTER);
  gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
  gtk_widget_show(label);

  label = gtk_label_new ("Man Page by Hans Paijmans");
  gtk_label_set_justify (GTK_LABEL(label),GTK_JUSTIFY_CENTER);
  gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
  gtk_widget_show(label);

  button = gtk_button_new_with_label ("Ok");
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
                    GTK_SIGNAL_FUNC (ExitCallback), (gpointer) "Ok");
  gtk_box_pack_start(GTK_BOX(vbox), button, TRUE, FALSE, 0);
  gtk_widget_show(button);

  gtk_signal_connect (GTK_OBJECT (window), "delete_event",
                      GTK_SIGNAL_FUNC (destroying), NULL);

  gtk_widget_show(window);

  DFMguiMainLoop();
}

int Question(char *text)
{
  GtkWidget *vbox;
  GtkWidget *hbox;
  GtkWidget *button;
  GtkWidget *label;

  window = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_window_set_title(GTK_WINDOW(window), _("Control"));
  gtk_window_position(GTK_WINDOW(window),GTK_WIN_POS_CENTER);
  gtk_container_border_width(GTK_CONTAINER(window), 10);
  
  vbox=gtk_vbox_new(FALSE, 10);
  gtk_container_add(GTK_CONTAINER(window),vbox);
  gtk_widget_show(vbox);

  label = gtk_label_new (text);
  gtk_label_set_justify (GTK_LABEL(label),GTK_JUSTIFY_CENTER);
  gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, FALSE, 0);
  gtk_widget_show(label);

  hbox=gtk_hbox_new(TRUE, 10);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, FALSE, 0);
  gtk_widget_show(hbox);
  
  button = gtk_button_new_with_label (_("Yes"));
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
                    GTK_SIGNAL_FUNC (YesCallback), (gpointer) "Yes");
  gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, 0);
  gtk_widget_show(button);

  button = gtk_button_new_with_label (_("Cancel"));
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
                    GTK_SIGNAL_FUNC (ExitCallback), (gpointer) "Cancel");
  gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, 0);
  gtk_widget_show(button);

  gtk_signal_connect (GTK_OBJECT (window), "delete_event",
                      GTK_SIGNAL_FUNC (destroying), NULL);

  gtk_widget_show(window);

  DFMguiMainLoop();
  return exitvar;
}

void Message(char *text)
{
  GtkWidget *vbox;
  GtkWidget *button;
  GtkWidget *label;

  window = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_window_set_title(GTK_WINDOW(window), _("DFM Warning"));
  gtk_window_position(GTK_WINDOW(window),GTK_WIN_POS_CENTER);
  gtk_container_border_width(GTK_CONTAINER(window), 10);
  
  vbox=gtk_vbox_new(FALSE, 10);
  gtk_container_add(GTK_CONTAINER(window),vbox);
  gtk_widget_show(vbox);

  label = gtk_label_new (text);
  gtk_label_set_justify (GTK_LABEL(label),GTK_JUSTIFY_CENTER);
  gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, FALSE, 0);
  gtk_widget_show(label);

  button = gtk_button_new_with_label (_("Noticed"));
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
                    GTK_SIGNAL_FUNC (YesCallback), (gpointer) "Yes");
  gtk_box_pack_start(GTK_BOX(vbox), button, TRUE, TRUE, 0);
  gtk_widget_show(button);

  gtk_signal_connect (GTK_OBJECT (window), "delete_event",
                      GTK_SIGNAL_FUNC (destroying), NULL);

  gtk_widget_show(window);

  DFMguiMainLoop();
}

int OverwriteQuestion(char *filename,char **rename_to)
{
  char *text;
  char *text2;
  GtkWidget *label;
  GtkWidget *entry;
  GtkWidget *button;
  GtkWidget *vbox;
  GtkWidget *hbox;

  *rename_to=NULL;
  window = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_window_set_title(GTK_WINDOW(window), "Control");
  gtk_window_position(GTK_WINDOW(window),GTK_WIN_POS_CENTER);
  gtk_container_border_width(GTK_CONTAINER(window), 10);

  vbox=gtk_vbox_new(FALSE, 10);
  gtk_container_add(GTK_CONTAINER(window),vbox);
  gtk_widget_show(vbox);

  entry = gtk_entry_new ();
  gtk_entry_set_text( GTK_ENTRY(entry), filename );
  gtk_entry_set_editable( GTK_ENTRY(entry),False);
  gtk_box_pack_start(GTK_BOX(vbox), entry, TRUE, TRUE, 0);
  gtk_widget_show(entry);

  label = gtk_label_new (_("Already exist! Delete this file before copying... ?"));
  gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
  gtk_widget_show(label);

  hbox=gtk_hbox_new(TRUE, 10);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, FALSE, 0);
  gtk_widget_show(hbox);

  button = gtk_button_new_with_label (_("Yes"));
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
                    GTK_SIGNAL_FUNC (YesCallback), (gpointer) "Yes");
  gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, 0);
  gtk_widget_show(button);

  button = gtk_button_new_with_label (_("All"));
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
                    GTK_SIGNAL_FUNC (AllCallback), (gpointer) "All");
  gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, 0);
  gtk_widget_show(button);

  button = gtk_button_new_with_label (_("No, next File"));
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
                    GTK_SIGNAL_FUNC (NoCallback), (gpointer) "No");
  gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, 0);
  gtk_widget_show(button);

  label = gtk_label_new (_("... or rename source to"));
  gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
  gtk_widget_show(label);

  obj_ret = gtk_entry_new ();
    text=GenerateLastNameWithoutSlash(filename);
    text2=malloc(strlen(text)+2);
    strcpy(text2,text);
    strcat(text2,"z");
    free(text);
    gtk_entry_set_text( GTK_ENTRY(obj_ret), text2 );
    free(text2);
  gtk_box_pack_start(GTK_BOX(vbox), obj_ret, TRUE, TRUE, 0);
  gtk_widget_show(obj_ret);

  hbox=gtk_hbox_new(TRUE, 10);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, FALSE, 0);
  gtk_widget_show(hbox);

  button = gtk_button_new_with_label (_("Rename"));
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
                    GTK_SIGNAL_FUNC (RenameCallback), (gpointer) rename_to);
  gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, 0);
  gtk_widget_show(button);

  button = gtk_button_new_with_label (_("Cancel"));
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
                    GTK_SIGNAL_FUNC (ExitCallback), (gpointer) "Cancel");
  gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, 0);
  gtk_widget_show(button);

  gtk_signal_connect (GTK_OBJECT (window), "delete_event",
                      GTK_SIGNAL_FUNC (destroying), NULL);

  gtk_widget_show(window);

  DFMguiMainLoop();
  return exitvar;
}

void NewProgram()
{
  GtkWidget *label;
  GtkWidget *button;
  GtkWidget *vbox;
  GtkWidget *hbox;

  char *text;

  window = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_window_set_title(GTK_WINDOW(window), _("Control"));
  gtk_window_position(GTK_WINDOW(window),GTK_WIN_POS_CENTER);
  gtk_container_border_width(GTK_CONTAINER(window), 10);

  vbox=gtk_vbox_new(FALSE, 10);
  gtk_container_add(GTK_CONTAINER(window),vbox);
  gtk_widget_show(vbox);

  hbox=gtk_hbox_new(FALSE, 10);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, FALSE, 0);
  gtk_widget_show(hbox);

  label = gtk_label_new (_("Program"));
  gtk_box_pack_start(GTK_BOX(hbox), label, TRUE, TRUE, 0);
  gtk_widget_show(label);

  obj_ret = gtk_entry_new ();
  gtk_box_pack_start(GTK_BOX(hbox), obj_ret, TRUE, TRUE, 0);
  gtk_widget_show(obj_ret);

  hbox=gtk_hbox_new(TRUE, 10);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, FALSE, 0);
  gtk_widget_show(hbox);

  button = gtk_button_new_with_label (_("Create"));
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
                    GTK_SIGNAL_FUNC (RenameCallback), (gpointer) &text);
  gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, 0);
  gtk_widget_show(button);

  button = gtk_button_new_with_label (_("Cancel"));
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
                    GTK_SIGNAL_FUNC (ExitCallback), (gpointer) "Cancel");
  gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, 0);
  gtk_widget_show(button);

  gtk_signal_connect (GTK_OBJECT (window), "delete_event",
                      GTK_SIGNAL_FUNC (destroying), NULL);

  gtk_widget_show(window);

  DFMguiMainLoop();

  if (exitvar!=1) {
    CreateProgramLink((char*)text);
    free(text);
    UpdateIcons(True);
  }
}

void NewFile()
{
  GtkWidget *label;
  GtkWidget *button;
  GtkWidget *vbox;
  GtkWidget *hbox;

  char *text;

  window = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_window_set_title(GTK_WINDOW(window), _("Control"));
  gtk_window_position(GTK_WINDOW(window),GTK_WIN_POS_CENTER);
  gtk_container_border_width(GTK_CONTAINER(window), 10);

  vbox=gtk_vbox_new(FALSE, 10);
  gtk_container_add(GTK_CONTAINER(window),vbox);
  gtk_widget_show(vbox);

  hbox=gtk_hbox_new(FALSE, 10);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, FALSE, 0);
  gtk_widget_show(hbox);

  label = gtk_label_new (_("File"));
  gtk_box_pack_start(GTK_BOX(hbox), label, TRUE, TRUE, 0);
  gtk_widget_show(label);

  obj_ret = gtk_entry_new ();
  gtk_box_pack_start(GTK_BOX(hbox), obj_ret, TRUE, TRUE, 0);
  gtk_widget_show(obj_ret);

  hbox=gtk_hbox_new(TRUE, 10);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, FALSE, 0);
  gtk_widget_show(hbox);

  button = gtk_button_new_with_label (_("Create"));
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
                    GTK_SIGNAL_FUNC (RenameCallback), (gpointer) &text);
  gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, 0);
  gtk_widget_show(button);

  button = gtk_button_new_with_label (_("Cancel"));
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
                    GTK_SIGNAL_FUNC (ExitCallback), (gpointer) "Cancel");
  gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, 0);
  gtk_widget_show(button);

  gtk_signal_connect (GTK_OBJECT (window), "delete_event",
                      GTK_SIGNAL_FUNC (destroying), NULL);

  gtk_widget_show(window);

  DFMguiMainLoop();

  if (exitvar!=1) {
    CreateFile((char*)text);
    free(text);
    UpdateIcons(True);
  }
}

void NewFolder()
{
  GtkWidget *label;
  GtkWidget *button;
  GtkWidget *vbox;
  GtkWidget *hbox;

  char *text;

  window = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_window_set_title(GTK_WINDOW(window), _("Control"));
  gtk_window_position(GTK_WINDOW(window),GTK_WIN_POS_CENTER);
  gtk_container_border_width(GTK_CONTAINER(window), 10);

  vbox=gtk_vbox_new(FALSE, 10);
  gtk_container_add(GTK_CONTAINER(window),vbox);
  gtk_widget_show(vbox);

  hbox=gtk_hbox_new(FALSE, 10);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, FALSE, 0);
  gtk_widget_show(hbox);

  label = gtk_label_new (_("Folder"));
  gtk_box_pack_start(GTK_BOX(hbox), label, TRUE, TRUE, 0);
  gtk_widget_show(label);

  obj_ret = gtk_entry_new ();
  gtk_box_pack_start(GTK_BOX(hbox), obj_ret, TRUE, TRUE, 0);
  gtk_widget_show(obj_ret);

  hbox=gtk_hbox_new(TRUE, 10);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, FALSE, 0);
  gtk_widget_show(hbox);

  button = gtk_button_new_with_label (_("Create"));
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
                    GTK_SIGNAL_FUNC (RenameCallback), (gpointer) &text);
  gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, 0);
  gtk_widget_show(button);

  button = gtk_button_new_with_label (_("Cancel"));
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
                    GTK_SIGNAL_FUNC (ExitCallback), (gpointer) "Cancel");
  gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, 0);
  gtk_widget_show(button);

  gtk_signal_connect (GTK_OBJECT (window), "delete_event",
                      GTK_SIGNAL_FUNC (destroying), NULL);

  gtk_widget_show(window);

  DFMguiMainLoop();

  if (exitvar!=1) {
    CreateFolder((char*)text);
    free(text);
    UpdateIcons(True);
  }
}

int EraseQuestion(char *filename)
{
  GtkWidget *vbox;
  GtkWidget *hbox;
  GtkWidget *label;
  GtkWidget *entry;
  GtkWidget *button;

  window = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_window_set_title(GTK_WINDOW(window), _("Control"));
  gtk_window_position(GTK_WINDOW(window),GTK_WIN_POS_CENTER);
  gtk_container_border_width(GTK_CONTAINER(window), 10);

  vbox=gtk_vbox_new(FALSE, 10);
  gtk_container_add(GTK_CONTAINER(window),vbox);
  gtk_widget_show(vbox);

  label = gtk_label_new (_("Really delete this file?"));
  gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, FALSE, 0);
  gtk_widget_show(label);

  entry = gtk_entry_new ();
  gtk_entry_set_text( GTK_ENTRY(entry), filename );
  gtk_entry_set_editable( GTK_ENTRY(entry),False);
  gtk_box_pack_start(GTK_BOX(vbox), entry, TRUE, FALSE, 0);
  gtk_widget_show(entry);

  hbox=gtk_hbox_new(FALSE, 10);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, FALSE, 0);
  gtk_widget_show(hbox);

  button = gtk_button_new_with_label (_("Yes"));
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
                    GTK_SIGNAL_FUNC (YesCallback), (gpointer) "Yes");
  gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, 0);
  gtk_widget_show(button);

  button = gtk_button_new_with_label (_("Cancel"));
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
                    GTK_SIGNAL_FUNC (ExitCallback), (gpointer) "Cancel");
  gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, 0);
  gtk_widget_show(button);

  button = gtk_button_new_with_label (_("All"));
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
                    GTK_SIGNAL_FUNC (AllCallback), (gpointer) "All");
  gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, 0);
  gtk_widget_show(button);

  button = gtk_button_new_with_label (_("No"));
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
                    GTK_SIGNAL_FUNC (NoCallback), (gpointer) "No");
  gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, 0);
  gtk_widget_show(button);

  gtk_signal_connect (GTK_OBJECT (window), "delete_event",
                      GTK_SIGNAL_FUNC (destroying), NULL);
  
  gtk_widget_show(window);

  DFMguiMainLoop();
  return exitvar;
}

int EraseQuestionOnDifferent(char *filename)
{
  GtkWidget *vbox;
  GtkWidget *hbox;
  GtkWidget *label;
  GtkWidget *entry;
  GtkWidget *button;

  window = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_window_set_title(GTK_WINDOW(window), _("Control"));
  gtk_window_position(GTK_WINDOW(window),GTK_WIN_POS_CENTER);
  gtk_container_border_width(GTK_CONTAINER(window), 10);

  vbox=gtk_vbox_new(FALSE, 10);
  gtk_container_add(GTK_CONTAINER(window),vbox);
  gtk_widget_show(vbox);

  label = gtk_label_new (_("Some files aren't copied correctly! There are differences!"));
  gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, FALSE, 0);
  gtk_widget_show(label);

  label = gtk_label_new (_("Really delete this orginal?"));
  gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, FALSE, 0);
  gtk_widget_show(label);

  entry = gtk_entry_new ();
  gtk_entry_set_text( GTK_ENTRY(entry), filename );
  gtk_entry_set_editable( GTK_ENTRY(entry),False);
  gtk_box_pack_start(GTK_BOX(vbox), entry, TRUE, FALSE, 0);
  gtk_widget_show(entry);

  hbox=gtk_hbox_new(FALSE, 10);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, FALSE, 0);
  gtk_widget_show(hbox);

  button = gtk_button_new_with_label (_("Yes"));
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
                    GTK_SIGNAL_FUNC (YesCallback), (gpointer) "Yes");
  gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, 0);
  gtk_widget_show(button);

  button = gtk_button_new_with_label (_("Cancel"));
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
                    GTK_SIGNAL_FUNC (ExitCallback), (gpointer) "Cancel");
  gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, 0);
  gtk_widget_show(button);

  button = gtk_button_new_with_label (_("All"));
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
                    GTK_SIGNAL_FUNC (AllCallback), (gpointer) "All");
  gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, 0);
  gtk_widget_show(button);

  button = gtk_button_new_with_label (_("No"));
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
                    GTK_SIGNAL_FUNC (NoCallback), (gpointer) "No");
  gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, 0);
  gtk_widget_show(button);

  gtk_signal_connect (GTK_OBJECT (window), "delete_event",
                      GTK_SIGNAL_FUNC (destroying), NULL);
  
  gtk_widget_show(window);

  DFMguiMainLoop();
  return exitvar;
}

