#include "config.h"
#include "todoterm.h"

#ifdef USETERMCAP
#include <string>
#include <stdexcept>
#include <term.h>

static char info[2048];

using namespace std;

int getWidth() {
	if (!info[2047]) {
	char const *termtype = getenv("TERM");
		if (!termtype) throw runtime_error("can't get terminal type, please set TERM envar");
	int result = tgetent(info, getenv("TERM"));
		if (result < 0)
			throw runtime_error("could not access termcap database");
		if (result == 0)
			throw runtime_error(string(string("unknown terminal type '") + termtype + "'").c_str());
		info[2047] = 1;
	}
	return tgetnum("co");
}
#else

int getWidth() { return 80; }

#endif
