/*
 * Detect a Library for hardware detection
 *
 * Copyright (C) 1998-2000 MandrakeSoft
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include "detect.h"
#include "utils.h"



struct webcam_info *webcam_detect(struct bus_lst *bus){
  struct usb_info *usb = (struct usb_info *)NULL;
  static struct webcam_info *first = (struct webcam_info *)NULL;
  struct webcam_info *result = (struct webcam_info *)NULL;

  if(debug)
    fprintf(stdout, "\nProbing WEBCAM...\n");


  /********************************************************************/
  /************************** USB WEBCAM *****************************/
  /********************************************************************/
  if(debug)
    fprintf(stdout, "\tProbing USB webcam...\n");

  for(usb = bus->usb; usb; usb = usb->next){
    if(usb->type == WEBCAM){
      if(!first){
        first = result = (struct webcam_info *)
                                 my_malloc(sizeof(struct webcam_info));
      }else{
        result->next = (struct webcam_info *)
                                 my_malloc(sizeof(struct webcam_info));
        result = result->next;
      }/*endif*/
      result->next = (struct webcam_info *)NULL;
      result->vendor = usb->vendor;
      result->model = usb->model;
      result->device = s_not_available;
      result->module = usb->modulename;
      result->long_id = usb->id;	
      result->bus = USB;
      if(debug)
	fprintf(stdout, "\t\tFound %s", result->model);
    }/*endif*/
  }/*next usb*/
  
  return first;
}/*endfunc webcam_detect*/
