/*
 * Detect a Library for hardware detection
 *
 * Copyright (C) 1998-2000 MandrakeSoft
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <stdio.h>
#include <stdlib.h>

#include "detect.h"
#include "utils.h"

extern struct memory_info *memory_detect(void)
{
    static struct memory_info *result = 0;
    char *temp, *temp2;

    if(debug)    
      fprintf(stdout, "\nProbing memory...\n");

    if (result)
	return result;

    result = (struct memory_info *) my_malloc(sizeof(struct memory_info));


/*****************************************************************************/
/*****************************TOTAL MEMORY************************************/
/*****************************************************************************/
    result->total = atoi(temp=extract_word(temp2=find_word("MemTotal", PATH_PROC_MEMINFO), 2, ":"));
    free(temp);
    free(temp2);

/*****************************************************************************/
/*****************************FREE MEMORY*************************************/
/*****************************************************************************/
    result->free = atoi(temp=extract_word(temp2=find_word("MemFree", PATH_PROC_MEMINFO), 2, ":"));
    free(temp);
    free(temp2);

/******************************************************************************/
/*****************************SHARED MEMORY************************************/
/******************************************************************************/
    result->shared = atoi(temp=extract_word(temp2=find_word("MemShared", PATH_PROC_MEMINFO), 2, ":"));
    free(temp);
    free(temp2);

/******************************************************************************/
/********************************BUFFERS***************************************/
/******************************************************************************/
    result->buffers = atoi(temp=extract_word(temp2=find_word("Buffers", PATH_PROC_MEMINFO), 2, ":"));
    free(temp);
    free(temp2);

/******************************************************************************/
/*******************************CACHED MEMORY**********************************/
/******************************************************************************/
    result->cached = atoi(temp=extract_word(temp2=find_word("Cached", PATH_PROC_MEMINFO), 2, ":"));
    free(temp);
    free(temp2);

/******************************************************************************/
/*******************************SWAP TOTAL*************************************/
/******************************************************************************/
    result->swap_total = atoi(temp=extract_word(temp2=find_word("SwapTotal", PATH_PROC_MEMINFO), 2, ":"));
    free(temp);
    free(temp2);

/******************************************************************************/
/*******************************SWAP FREE**************************************/
/******************************************************************************/
    result->swap_free = atoi(temp=extract_word(temp2=find_word("SwapFree", PATH_PROC_MEMINFO), 2, ":"));
    free(temp);
    free(temp2);


    return result;
}
