/*
 * Detect a Library for hardware detection
 *
 * Copyright (C) 1998-2000 MandrakeSoft
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include "detect.h"
#include "utils.h"



extern struct usbntf_info *usbinterface_detect(struct bus_lst *bus){
  struct pci_info *pci = (struct pci_info *)NULL;
  struct isa_info *isa = (struct isa_info *)NULL;
  static struct usbntf_info *first = (struct usbntf_info *)NULL;
  struct usbntf_info *result = (struct usbntf_info *)NULL;

  if(first){
    return first;
  }/*endif*/
  
  if(debug){
    fprintf(stdout, "\nProbing USB interface...\n");
  }/*endif*/
  /********************************************************************/
  /********************* PCI USB-INTERFACE DETECTION ******************/
  /********************************************************************/
  if(debug){
    fprintf(stdout, "\tProbing PCI interface...\n");
  }/*endif*/
  if(!kernel_verif(2, 1, 120)){
    for(pci = bus->pci; pci; pci = pci->next){
      if(pci->type == USBINTERFACE){
        if(!first){
          first = result = (struct usbntf_info *) 
                                  my_malloc(sizeof(struct usbntf_info));
        }else {
          result->next = (struct usbntf_info *) 
                                  my_malloc(sizeof(struct usbntf_info));
          result = result->next;
        }/*endif*/
        result->next = (struct usbntf_info *)NULL;
        
        result->vendor = pci->vendor;
        result->model = pci->model;
        result->module = pci->modulename;
        result->bus = PCI;
        result->long_id = pci->id;
        if(debug){
          fprintf(stdout, "\t\tFound %s %s\n", 
                                         result->vendor, result->model);
        }/*endif*/
      }/*endif*/
    }/*next pci*/
  }/*endif*/

  /********************************************************************/
  /********************** ISA USB-INTERFACE DETECTION *****************/
  /********************************************************************/
  if(debug){
    fprintf(stdout, "\tProbing ISA interface...\n");
  }/*endif*/
  for(isa = bus->isa; isa; isa = isa->next){
    if(isa->type == USBINTERFACE){
      if(!first){
        first = result = (struct usbntf_info *)
                                  my_malloc(sizeof(struct usbntf_info));
      }else{
        result->next = (struct usbntf_info *)
                                  my_malloc(sizeof(struct usbntf_info));
          result = result->next;
      }/*endif*/
      result->next = (struct usbntf_info *)NULL;
      
      result->board_num = isa->board_num;
      result->board_id = isa->board_id;
      result->dev_num = isa->dev_num;
      result->dev_id =isa->dev_id;
      result->vendor = isa->vendor;
      result->model = isa->model;
      result->module = isa->modulename;
      result->bus = ISA;
      result->io = isa->io;
      result->irq = isa->irq;
      if(debug){
        fprintf(stdout, "\t\tFound %s %s\n", 
                                         result->vendor, result->model);
      }/*endif*/
    }/*endif*/
  }/*next isa*/
  return first;
}/*endfunc usbinterfce_detect*/


extern struct usb_info *usb_detect(struct cards_lst *lst) {
  FILE *f;
  struct cards_lst *bkup_lst;
  struct usb_info *result = (struct usb_info *)NULL;
  static struct usb_info *first = (struct usb_info *)NULL;
  int vendorid, devid;
  int class;
  unsigned long id;
  char *line;
  int found;
  size_t len = 0;

  if(first){
    return first;
  }/*endif*/
  
  if(debug){
    fprintf(stdout, "\nProbing USB devices...\n");
  }/*endif*/
  /********************************************************************/
  /********************* USB DEVICE DETECTION *************************/
  /********************************************************************/
  if((f = fopen(PATH_PROC_USB, "r"))){
    while(getline(&line, &len, f) >= 0){
      if(strstr(line, "ProdID=")){
        sscanf(line, "P:  Vendor=%04x ProdID=%04x Rev=%*2x.%*02x\n", 
                                                     &vendorid, &devid);
        id = (vendorid * 0x10000) + devid; 
        
        while(getline(&line, &len, f) >= 0){
          if(strstr(line, "I: ")){
            sscanf(line, "I:  If#=%*2d Alt=%*2d #EPs=%*2d "
                         "Cls=%02x(%*5s) Sub=%*02x Prot=%*02x "
                         "Driver=%*s\n", &class);
            break;
          }/*endif*/
        }/*endwhile*/
        
        if(!first){
          first = result = (struct usb_info *)
                                     my_malloc(sizeof(struct usb_info));
        }else{
          result->next = (struct usb_info *)
                                     my_malloc(sizeof(struct usb_info));
          result = result->next;
        }/*endif*/
        result->next = (struct usb_info *)NULL;
        found = 0;
        
        result->type = usbclass2device(class);
        
        for(bkup_lst = lst; bkup_lst; bkup_lst = bkup_lst->next){
          if((id == bkup_lst->long_id) && (bkup_lst->bus == USB)){
            result->id = bkup_lst->long_id;
            result->vendor = bkup_lst->vendor;
            result->model = bkup_lst->model;
            result->modulename = bkup_lst->modulename;

            if(bkup_lst->type != UNKNOWN_DEVICE){
              result->type = bkup_lst->type;        
            }/*endif*/
            found = 1;
          }/*endif*/
        }/*next bkup_lst*/
      
        if(!found){
          result->id = id;
          result->vendor = s_unknown;
          result->model = s_unknown;
          result->modulename = s_unknown;
        }/*endif*/
        if(debug){
          fprintf(stdout, "\t\tFound %s %s\n", 
                                         result->vendor, result->model);
        }/*endif*/
      }/*endif*/
    }/*endwhile*/
    len = 0;
    free(line);
    fclose(f);
  }/*endif*/

  return first;
}/*endfunc usb_detect*/
