/* print.cpp
 * 
 * basic printing support for GNU Denemo
 * outputs to a dvi file
 *
 * for Denemo, a gtk+ frontend to GNU Lilypond
 * (c) 2001-2005 Adam Tee
 */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>

#ifdef HAVE_SYS_WAIT_H
#include <sys/wait.h>
#endif
#ifdef HAVE_WAIT_H
#include <wait.h>
#endif

#include <errno.h>

#include "print.h"
#include "prefops.h"
#include "exportlilypond.h"
#include "utils.h"



/*  Print function 
 *  Save file in lilypond format
 *  Fork and run lilypond
 *  TODO Add in lpr command
 */
static void
print (DenemoGUI * gui, gboolean part_only)
{
  static GString *filename = NULL;
  GError *err = NULL;
  DenemoScore *si = gui->si;

  if (!filename)
    {
      filename = g_string_new (locatedotdenemo ());
      g_string_append (filename, "/denemoprint");
    }

  gchar *printfile = g_strconcat (filename->str, ".pdf", NULL);
  FILE *fp = fopen(printfile, "w");
  if(fp)
    fclose(fp);
  else {
    warningdialog("Could not open ~/.denemo/denemoprint.pdf, check permissions");
    return;
  }

  gchar *mudelafile = g_strconcat (filename->str, ".ly", NULL);
  remove (mudelafile);
  if(part_only)
    export_lilypond_part (mudelafile, si, si->start, si->end);
  else
    exportlilypond (mudelafile, si, 0, 0);
  gchar *convert = "convert-ly";
  gchar *conv_argv[] = {
    convert,
    "-e",
    mudelafile,
    NULL
  };

  gint exit_status;
  g_spawn_sync (locatedotdenemo (),		/* dir */
		conv_argv, NULL,	/* env */
		G_SPAWN_SEARCH_PATH, NULL,	/* child setup func */
		NULL,		/* user data */
		NULL,		/* stdout */
		NULL,		/* stderr */
		&exit_status, &err);

  if (err != NULL)
    {
      warningdialog("Could not execute lilypond's convert-ly program - check Edit->preferences->externals->lilypond setting\nand lilypond installation");
      g_warning ("%s", err->message);
      g_error_free (err);
      err = NULL;
    }
  gchar *argv[] = {
    gui->prefs->lilypath->str,
    "--pdf",
    "-o",
    filename->str,
    mudelafile,
    NULL
  };

  g_spawn_sync (locatedotdenemo (),		/* dir */
		argv, NULL,	/* env */
		G_SPAWN_SEARCH_PATH, NULL,	/* child setup func */
		NULL,		/* user data */
		NULL,		/* stdout */
		NULL,		/* stderr */
		&exit_status, &err);

  if (err != NULL)
    {
      warningdialog("Could not execute lilypond - check Edit->preferences->externals->lilypond setting\nand lilypond installation");
      g_warning ("%s", err->message);
      g_error_free (err);
      err = NULL; 
    }


  if((fp=fopen(printfile, "r"))) {
    if(getc(fp)==EOF) {
      g_warning ("Failed to read %s", (gchar *) printfile);
      warningdialog("Cannot make score, probably errors in lilypond output");
      return;
    }
  } else
  {
    g_warning ("Failed to find %s", (gchar *) printfile);
    warningdialog("Could not create a pdf - check permissions");
    return;
  }
    


  //g_print("using %s\n", printfile);
  gchar *args[] = {
    gui->prefs->pdfviewer->str,
    printfile,
    NULL
  };

 
  exit_status = 0;

  GPid printpid;//ignored
  g_spawn_async (locatedotdenemo (),		/* dir */
		args, NULL,	/* env */
		G_SPAWN_SEARCH_PATH, NULL,	/* child setup func */
		NULL,		/* user data */		
		&printpid, &err);


  if (err != NULL)
    {
      g_warning ("Failed to find %s", gui->prefs->pdfviewer->str);
      warningdialog("Cannot display: Check Edit->Preferences->externals\nfor your PDF viewer");
      g_warning ("%s", err->message);
      g_error_free (err);
      err = NULL;
    }
  g_free(printfile);


}


/* callback to print whole of score */
void
printall_cb (GtkAction * action, DenemoGUI * gui) {
  gchar *str = g_strdup_printf("No direct printing yet\nWe will run the PDF viewer program %s so you can use its print command.\nYou can change the PDF viewer using \nEdit->Preferences->Externals->Pdf viewer.", gui->prefs->pdfviewer->str);
  warningdialog(str);
  g_free(str);
  print(gui, FALSE);
}
/* callback to print current part (staff) of score */
void
printpart_cb (GtkAction * action, DenemoGUI * gui) {
  print(gui, TRUE);
}
void
printpreview_cb (GtkAction * action, DenemoGUI * gui) {
  print(gui, FALSE);
}
