#include <stdlib.h>
#include <unistd.h>
#include <string.h>

#include <deborphan.h>
#include <xalloc.h>

dep *
set_dep(dep *p, const char *name)
{
    p->name = xmalloc ((strlen(name)+1)*sizeof(char));
    strcpy(p->name, name);
    p->namehash = strhash(name);

    return p;
}

dep *
set_provides(pkg_info *p, const char *name, const int i)
{
    p->provides[i].name = xmalloc ((strlen(name)+1)*sizeof(char));
    strcpy(p->provides[i].name, name);
    p->provides[i].namehash = strhash(name);
    p->provides[i+1].name = NULL;

    return &(p->provides[i]);
}

void
set_section(pkg_info *p, const char *section, const char *prefix)
{
    if (prefix) {
	p->section = xmalloc ((strlen(section)+strlen(prefix)+2)
			      *sizeof(char));
	strcpy(p->section, prefix);
	strcat(p->section, "/");
	strcat(p->section, section);
    } else {
	p->section = xmalloc ((strlen(section)+1)*sizeof(char));
	strcpy(p->section, section);
    }
}

int
set_priority(pkg_info *p, const char *priority)
{
    return (p->priority = string_to_priority(priority));
}

void
init_pkg(pkg_info *p)
{
    p->self.name = p->deps[0].name = p->provides[0].name = p->section = NULL;
    p->next = NULL;
    p->priority = p->install = p->hold = 0;
}

void
reinit_pkg(pkg_info *p)
{
    int i;
    if (p->self.name) {
	free(p->self.name);
	p->self.name = NULL;
    }
    if (p->section) {
	free(p->section);
	p->section = NULL;
    }
    for (i = 0; p->deps[i].name; i++)
	free(p->deps[i].name);
    p->deps[0].name = NULL;

    for (i = 0; p->provides[i].name; i++)
	free(p->provides[i].name);
    p->provides[0].name = NULL;
}
