#ifndef xcontrol_version_h_
#define xcontrol_version_h_ 1

#include <string>

#include <stdexcept>

typedef std::string version;

enum version_op
{
	dontcare = 0,
	equal,
	lessthan,
	greaterthan,
	lessorequal,
	greaterorequal
};

template<typename CharT_, typename Traits_>
std::basic_ostream<CharT_, Traits_> &operator<<(
		std::basic_ostream<CharT_, Traits_> &stream,
		version_op op)
{
	typename std::basic_ostream<CharT_, Traits_>::sentry sentry(stream);
	if(!sentry)
		return stream;
	
	switch(op)
	{
	case equal:
		stream << "=";
		break;
	case lessthan:
		stream << "<<";
		break;
	case greaterthan:
		stream << ">>";
		break;
	case lessorequal:
		stream << "<=";
		break;
	case greaterorequal:
		stream << ">=";
		break;
	default:
		throw std::invalid_argument("invalid version comparison operator");
	}

	return stream;
}

#endif
