#ifndef xcontrol_dependency_alternative_list_h_
#define xcontrol_dependency_alternative_list_h_ 1

#include "dependency.hpp"

#include <string>
#include <list>
#include <ostream>

#include <iostream>

class dependency_alternative_list :
	public std::list<dependency>
{
public:
	dependency_alternative_list(void) { }
	dependency_alternative_list(std::string const &str) { *this = str; }

	dependency_alternative_list &operator=(std::string const &);
	operator std::string(void) const;

	dependency_alternative_list &operator+=(dependency_alternative_list const &rhs);

};

inline std::ostream &operator<<(std::ostream &stream, dependency_alternative_list const &list)
{
	std::ostream::sentry sentry(stream);
	if(!sentry)
		return stream;

	stream << std::string(list);
	return stream;
}

#endif
