#ifndef xcontrol_architecture_h_
#define xcontrol_architecture_h_ 1

#include <string>

class architecture :
	public std::string
{
public:
	explicit architecture(std::string const &);

	bool operator==(architecture const &rhs) const
	{
		return static_cast<std::string const &>(*this) == rhs;
	}
	bool operator!=(architecture const &rhs) const
	{
		return static_cast<std::string const &>(*this) != rhs;
	}

	static architecture const build;
	static architecture const host;

private:
	static architecture get_build_arch(void);
	static architecture get_host_arch(void);
};

#endif
