#!/usr/bin/env perl
#
# A script adding machines to LDAP for use by samba
#
# Authors: Odd Rune Dahle <oddrune@pvv.org> 
#          Svein Magne Bang <sveinmb@stud.ntnu.no>
#     
# Date:   2003-04-15

use warnings;

use vars qw(%text %config);
sub text{}
sub read_file{}

require '/usr/share/debian-edu-config/tools/ldap-users.pl';

my $uid    = shift || die "usage: smbaddclient.pl <machine-name>\n"; 

read_adduser_config();    # puts adduser config into %config

my $DEBUG = 1;

my $smbconf="/etc/samba/smb.conf";
my $secretstdb="/var/lib/samba/secrets.tdb";
my $tdbdumpbin="/usr/bin/tdbdump";

################# end of user configuration ##################
##############################################################


##
# First we need to read the ldap configuration from smb.conf
##

open(FILE,$smbconf) || die "Can't open $smbconf: $!";   # open smb.conf

$ldapdata[0] = "passdb backend";
$ldapdata[1] = "ldap suffix";
$ldapdata[2] = "ldap admin dn";
$ldapdata[3] = "ldap rootpw";

while ($line = <FILE>) {     # parse file and extract ldap config
  if ($line =~ /ldap/i) {
   for($n=0;$n<3;$n++){
    if ($line =~ /$ldapdata[$n]/i) {
      $line =~ s/$ldapdata[$n]//i;
      $line =~ s/=//;
      $line =~ s/^\s+//;
      $line =~ s/\"//g;
      $ldapdata[$n]=$line;
    }
   }
  }
}

my $n;
for($n=0;$n<3;$n++){      # get rid of newlines
  chomp($ldapdata[$n]);
}

$ldapdata[0] =~ s/ldapsam:ldap:\/\///i;  # remove service type from server
$ldapdata[1] =~ s/ou=people,//i;  # remove ou=people from basedn

close(FILE);   # close smb.conf



## 
# Now it's time to dump det secrets.tdb and retrive the ldap admin pw
##


$tdbret=`$tdbdumpbin $secretstdb`;  # execute tdbdump

$foundkey = "no";  # boolean used for loop

foreach $line (split ("\n", $tdbret)){  # parse tdbdump output
  if ($foundkey eq "yes"){   # if key is found, then extract rootwd
    $line =~ s/data = //i;
    $line =~ s/\"//g;
    $ldapdata[3] = $line;
    last;
  } else {                   # still not found, keep searching
    if ($line =~ s/key = //i) {
      $line =~ s/\"//g;
      if($line eq "SECRETS/LDAP_BIND_PW/" . $ldapdata[2]){ # see if this is the right key 
        $foundkey="yes";
      }
    }
  }
}  

$ldapdata[3] =~ s/\\00$//i;  # remove trailing 0x00 from password

# done reading configuration


$server = $ldapdata[0];
$basedn = $ldapdata[1];
$rootdn = $ldapdata[2];
$rootpw = $ldapdata[3];

# detecting 
my $machine_gid = getgrnam("machines");
die "There is no machine-group. Please run upgrade-ldap-backend as root.\n" 
    unless $machine_gid; 

# Some Debug info
# print "server: " . $server . "\n" ;
# print "basedn: " . $basedn . "\n" ;
# print "rootdn: " . $rootdn . "\n" ;
# print "rootpw: " . $rootpw . "\n" ;
# print "machineGroup: " . $machine_gid . "\n" ;

ldap_connect(# Connect to the ldap server.
	     $server, 
	     $rootdn, 
	     $basedn, 
	     $config{'FIRST_UID'} || 10000,
	     $config{'LAST_UID'} || 29999,
	     );

my $nextid = ldap_get_newid ($rootpw);

my $cn  = "$uid MachineAccount";
my $gidNumber = $machine_gid;
my $uidNumber = $nextid;


ldap_add_machine($cn, "$uid", $uidNumber, $gidNumber, $rootpw);
system ('/usr/sbin/nscd -i passwd') if (-e '/usr/sbin/nscd') ;
print ldap_dbg_output();

