#!/bin/bash
## ---------------------------------------------------------------------
##
## Copyright (C) 2018 by the deal.II authors
##
## This file is part of the deal.II library.
##
## The deal.II library is free software; you can use it, redistribute
## it, and/or modify it under the terms of the GNU Lesser General
## Public License as published by the Free Software Foundation; either
## version 2.1 of the License, or (at your option) any later version.
## The full text of the license can be found in the file LICENSE at
## the top level of the deal.II distribution.
##
## ---------------------------------------------------------------------

#
# This script downloads the global coverage report uploader for Codecov.
# If you are running the testsuite to create coverage information and
# the codecov uploader is present, there is also a report uploaded to
# https://codecov.io/gh/dealii/dealii.
#

PRG="$(cd "$(dirname "$0")" && pwd)/programs"
CODECOV_PATH="${PRG}/codecov"

if [ ! -d "$PRG" ]
then
    echo "create folder $PRG"
    mkdir "$PRG"
fi

# codecov
if [ ! -d "$CODECOV_PATH" ]
then
    echo "Downloading codecov-bash."
    mkdir "$CODECOV_PATH"
    curl -s "https://codecov.io/bash" > $CODECOV_PATH/codecov-bash.sh
fi
