<?php
/*
 * $Id: class.dbProductModules.inc.php,v 1.1.2.2 2002/10/22 00:32:08 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('db');

class dbProductModules extends dclDB
{
	var $product_module_id;
	var $product_id;
	var $module_name;
	var $active;

	function dbProductModules()
	{
		// Table Fields
		$this->fieldArray = array('product_module_id', 'product_id', 'module_name', 'active');

		// Foriegn keys
		$this->foreignKeys = array('products' => 'productid');

		$this->cache = array();
		$this->cacheEnabled = true;

		$this->dclDB();
	}

	function Add()
	{
		$idSQL = $this->GetNewIDSQLForTable('dcl_product_module');
		$query = 'INSERT INTO dcl_product_module (';
		if ($idSQL != '')
			$query .= 'product_module_id,';
		$query .= 'product_id, module_name, active)';
		$query .= ' VALUES (';
		if ($idSQL != '')
			$query .= $idSQL . ',';
			
		$query .= $this->product_id . ', ';
		$query .= "'" . $this->DBAddSlashes($this->module_name) . "', 'Y')";

		if ($this->Insert($query) == -1)
		{
			echo '<BR>' . sprintf(STR_DB_PRODUCTINSERTERR, $query) . '<BR>';
		}
	}

	function Edit()
	{
		$query = 'UPDATE dcl_product_module SET ';
		$query .= "module_name='" . $this->DBAddSlashes($this->module_name) . "',";
		$query .= " active='" . $this->active . "'";
		$query .= ' WHERE product_module_id=' . $this->product_module_id;

		$this->Execute($query);
	}

	function Delete()
	{
		$query = 'DELETE FROM dcl_product_module WHERE product_module_id=' . $this->product_module_id;
		return $this->Execute($query);
	}

	function SetActive($active)
	{
		$isActive = 'N';
		if ($active)
			$isActive = 'Y';

		$query = 'UPDATE dcl_product_module SET ';
		$query .= "active='$isActive'";
		$query .= ' WHERE product_module_id=' . $this->product_module_id;

		return $this->Execute($query);
	}

	function GetRow()
	{
		if (!$this->res)
			return -1;

		if (count($this->Record) > 0)
		{
			$this->product_module_id = $this->f('product_module_id');
			$this->product_id = $this->f('product_id');
			$this->module_name = trim($this->f('module_name'));
			$this->active = $this->f('active');

			if ($this->cacheEnabled)
				$this->CacheRow($this->product_module_id);
		}
		else
			$this->Clear();
	}

	function Load($id)
	{
		$this->Clear();

		if ($this->cacheEnabled && $this->LoadCache($id) != -1)
			return 0;

		if ($this->conn == 0)
		{
			if (!$this->Connect())
				return -1;
		}

		$sql = "SELECT * FROM dcl_product_module WHERE product_module_id = $id";
		if (!$this->Query($sql))
			return -1;

		$this->next_record();
		return $this->GetRow();
	}

	function Clear()
	{
		$this->product_module_id = 0;
		$this->product_id = 0;
		$this->module_name = '';
		$this->active = '';
	}
}
?>
