<?php
/*
 * $Id: class.dbStatuses.inc.php,v 1.4 2001/09/23 21:33:38 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('db');
class dbStatuses extends dclDB
{
	var $id;
	var $short;
	var $name;
	var $active;
	var $dcl_status_type;

	function dbStatuses()
	{
           //Table Fields
		$this->fieldArray = array('id', 'short', 'name', 'active', 'dcl_status_type');

           // Foreign keys
		$this->foreignKeys = array(
				'workorders' => 'status',
				'timecards' => 'status',
				'dcl_projects' => 'status',
				'tickets' => 'status',
				'ticketresolutions' => 'status');

		$this->cache = array();
		$this->cacheEnabled = true;

		$this->dclDB();
	}

	function Add()
	{
		$idSQL = $this->GetNewIDSQLForTable('statuses');
		$query = 'INSERT INTO statuses (';
		if ($idSQL != '')
			$query .= 'id,';
		$query .= 'short,name,active,dcl_status_type)';
		$query .= ' VALUES (';
		if ($idSQL != '')
			$query .= $idSQL . ',';
		$query .= '\'' . $this->DBAddSlashes($this->short) . '\',';
		$query .= '\'' . $this->DBAddSlashes($this->name) . '\',\'Y\',';
		$query .= $this->dcl_status_type . ')';

		if ($this->Insert($query) == -1)
		{
			echo '<BR>' . sprintf(STR_DB_STATUSINSERTERR, $query) . '<BR>';
		}
	}

	function Edit()
	{
		$query = 'UPDATE statuses SET ';
		$query .= 'short=\'' . $this->DBAddSlashes($this->short) . '\',';
		$query .= 'name=\'' . $this->DBAddSlashes($this->name) . '\',';
		$query .= 'active=\'' . $this->active . '\',';
		$query .= 'dcl_status_type=' . $this->dcl_status_type;
		$query .= ' WHERE id=' . $this->id;

		$this->Execute($query);
	}

	function Delete()
	{
		$query = 'DELETE FROM statuses WHERE id=' . $this->id;
		return $this->Execute($query);
	}

	function SetActive($active)
	{
		$isActive = 'N';
		if ($active)
			$isActive = 'Y';

		$query = 'UPDATE statuses SET ';
		$query .= "active='$isActive'";
		$query .= ' WHERE id=' . $this->id;

		return $this->Execute($query);
	}

	function GetRow()
	{
		if (!$this->res)
			return -1;

		if (count($this->Record) > 0)
		{
			$this->id = $this->f('id');
			$this->short = trim($this->f('short'));
			$this->name = trim($this->f('name'));
			$this->active = $this->f('active');
			$this->dcl_status_type = $this->f('dcl_status_type');

			if ($this->cacheEnabled)
				$this->CacheRow($this->id);
		}
		else
			$this->Clear();
	}

	function Load($id)
	{
		$this->Clear();

		if ($this->cacheEnabled && $this->LoadCache($id) != -1)
			return 0;

		if ($this->conn == 0)
		{
			if (!$this->Connect())
				return -1;
		}

		$sql = "SELECT * FROM statuses WHERE id=$id";
		if (!$this->Query($sql))
			return -1;

		$this->next_record();
		return $this->GetRow();
	}

	function GetStatusType($id)
	{
		$db = new dclDB;
		$db->Connect();
		if ($db->Query("select dcl_status_type from statuses where id=$id") == -1)
			return 0;

		if ($db->next_record())
		{
			$retVal = $db->f(0);
			$db->FreeResult();
			return $retVal;
		}

		$db->FreeResult();
		return 0;
	}

	function Clear()
	{
		$this->id = 0;
		$this->short = '';
		$this->name = '';
		$this->active = '';
		$this->dcl_status_type = 0;
	}
}
?>
