/* dc_gui2 - a GTK+2 GUI for DCTC
 * Copyright (C) 2002 Eric Prevoteau
 *
 * user_clist.h: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: user_clist.h,v 1.6 2003/12/28 09:29:32 uid68112 Exp $
*/

#ifndef __USER_CLIST_H__
#define __USER_CLIST_H__

#include "global_user.h"

/*******************************************/
/* build model and view for the user clist */
/*******************************************/
void bmav4_user_clist(void);

/* -------------------------------------------------------------------------- */
/*********************************************************************************************/
/* this function search in the user_clist to find a nick matching the partially provided one */
/*********************************************************************************************/
/* output: a Gstring containing the full nick or NULL if none or more than one match */
/*************************************************************************************/
GString *complete_a_nick(const char *partial_nick);

/*****************************************************************/
/* remove the user having the given nickname from the user_clist */
/*********************************************************************/
/* gtm is the TreeModel of the 'user_clist' widget                   */
/* (NULL can be provided to let the function found it automatically) */
/* (mainly here for speed)                                           */
/*********************************************************************/
void remove_user(GLOB_USER *gu, GtkTreeModel *gtm);

/*******************************************************************/
/* this function adds the nickname to the user_clist or updates it */
/*******************************************************************/
/* output: modified/created GLOB_USER entry */
/*********************************************************************/
/* gtm is the TreeModel of the 'user_clist' widget                   */
/* (NULL can be provided to let the function found it automatically) */
/* (mainly here for speed)                                           */
/* email can be NULL                                                 */
/*********************************************************************/
GLOB_USER *add_or_update_user(char *cnx_type, char *nickname, unsigned long long share_size,char *email, char *description, unsigned int flag, GtkTreeModel *gtm, gboolean online_flag, gboolean op_flag);

void update_users_info(void);
#endif
