/* dc_gui2 - a GTK+2 GUI for DCTC
 * Copyright (C) 2002 Eric Prevoteau
 *
 * uaddr_clist.c: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: uaddr_clist.c,v 1.8 2003/12/28 09:29:32 uid68112 Exp $
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gnome.h>

#include "gtkcellrenderertextx.h"
#include "misc_gtk.h"
#include "uaddr_clist.h"
#include "main.h"
#include "gui_define.h"
#include "macro.h"
#include "global_user.h"

/*****************************************/
/* for each UADDR entry, call a function */
/***************************************************************************************************/
/* NOTE: unlike gtk_tree_model_foreach, this function handles destruction of UADDR during the walk */
/***************************************************************************************************/
void generic_uaddr_entry_list_calls(GtkTreeModelForeachFunc fnc, void *data)
{
	GtkWidget *w;
	GtkTreeModel *gtm;
	GtkListStore *gls;

	int i;

	w=get_widget_by_widget_name(main_window,"uaddr_clist");
	gls=GTK_LIST_STORE(gtm=gtk_tree_view_get_model(GTK_TREE_VIEW(w)));

	i=gtk_tree_model_iter_n_children(gtm,NULL)-1;
	while(i>=0)
	{
		GtkTreeIter iter;
		if(gtk_tree_model_iter_nth_child(gtm,&iter,NULL,i)==TRUE)
		{
			GtkTreePath *path;
			gboolean ret;

			path=gtk_tree_model_get_path(gtm,&iter);
			ret=(*fnc)(gtm,path,&iter,data);
			gtk_tree_path_free(path);
			if(ret==TRUE)
				return;
		}
		i--;
	}

}

/**************************************************/
/* for each selected UADDR entry, call a function */
/********************************************************************/
/* NOTE: this function handles destruction of UADDR during the walk */
/********************************************************************/
void generic_select_uaddr_entry_list_calls(GtkTreeSelectionForeachFunc fnc, void *data)
{
	GtkWidget *w;
	GtkTreeModel *gtm;
	GtkListStore *gls;
	GtkTreeSelection *slc;

	int i;

	w=get_widget_by_widget_name(main_window,"uaddr_clist");
	gls=GTK_LIST_STORE(gtm=gtk_tree_view_get_model(GTK_TREE_VIEW(w)));
	slc=gtk_tree_view_get_selection(GTK_TREE_VIEW(w));

	i=gtk_tree_model_iter_n_children(gtm,NULL)-1;
	while(i>=0)
	{
		GtkTreeIter iter;
		if(gtk_tree_model_iter_nth_child(gtm,&iter,NULL,i)==TRUE)
		{
			if(gtk_tree_selection_iter_is_selected(slc,&iter)==TRUE)
			{
				GtkTreePath *path;

				path=gtk_tree_model_get_path(gtm,&iter);
				(*fnc)(gtm,path,&iter,data);
				gtk_tree_path_free(path);
			}
		}
		i--;
	}

}

/************************************************/
/* update user information using GLOB_USER data */
/************************************************/
static void uaddr_clist_user_info_update_row(GtkTreeModel *gtm, GtkTreePath *gtp, GtkTreeIter *gti, gpointer user_data)
{
	GLOB_USER *gu;

	/* get GLOB_USER entry to use */
	gtk_tree_model_get(gtm,gti,UAC_USER_POINTER,&gu,-1);

	/* we may have entry without user */
	if(gu==NULL)
		return;

	/* block the update signal on this function */
	g_signal_handlers_block_matched (G_OBJECT(gtm),G_SIGNAL_MATCH_FUNC,0,0,NULL,uaddr_clist_user_info_update_row,NULL);

	/* update user info */
	gtk_list_store_set(GTK_LIST_STORE(gtm),gti,
												UAC_NICK_COL,gu->fmt_nick,
												UAC_BACKGROUND_COL,gu->back_color,
												UAC_FOREGROUND_COL,gu->front_color,
												-1);

	/* unblock the update signal on this function */
	g_signal_handlers_unblock_matched (G_OBJECT(gtm),G_SIGNAL_MATCH_FUNC,0,0,NULL,uaddr_clist_user_info_update_row,NULL);
}

/*********************************************/
/* build modele and view for the uaddr clist */
/*********************************************/
void bmav4_uaddr_clist(void)
{
	GtkListStore *model;
	GtkWidget *view;
	GtkCellRenderer *rend;
	GtkTreeSelection *slc;

	model=gtk_list_store_new(NB_UAC_COL,G_TYPE_STRING,G_TYPE_STRING, 
													G_TYPE_STRING,G_TYPE_STRING,
													G_TYPE_POINTER);
	g_signal_connect_after(G_OBJECT(model),"row-changed",G_CALLBACK(uaddr_clist_user_info_update_row),NULL);

	view=get_widget_by_widget_name(main_window,"uaddr_clist");

	gtk_tree_view_set_model(GTK_TREE_VIEW(view),GTK_TREE_MODEL(model));
	gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(view),TRUE);

	slc=gtk_tree_view_get_selection(GTK_TREE_VIEW(view));
	gtk_tree_selection_set_mode(slc,GTK_SELECTION_MULTIPLE);
	
	/* the first column of the view display the first column of the model, and so on. The 4th entry of the model is not displayed */
	rend=gtk_cell_renderer_textx_new();
	g_object_set(rend,"rowspacing",TRUE,NULL);
	MY_RS_gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view),UAC_NICK_COL,_("Nick"),rend,"text",UAC_NICK_COL,"background",UAC_BACKGROUND_COL,"foreground",UAC_FOREGROUND_COL,NULL);

	rend=gtk_cell_renderer_textx_new();
	g_object_set(rend,"rowspacing",TRUE,NULL);
	MY_RS_gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view),UAC_ADDR_PORT_COL,_("Host Address and port"),rend,"text",UAC_ADDR_PORT_COL,"background",UAC_BACKGROUND_COL,"foreground",UAC_FOREGROUND_COL,NULL);

	/* The view now holds a reference.  We can get rid of our own
	 * reference */
	g_object_unref (G_OBJECT (model));
}

