/* dc_gui2 - a GTK+2 GUI for DCTC
 * Copyright (C) 2002 Eric Prevoteau
 *
 * proc_serv.h: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: proc_serv.h,v 1.1 2004/01/02 08:30:17 ericprev Exp $
*/

#ifndef __PROC_SERV_H__
#define __PROC_SERV_H__

typedef struct
{
	gchar *service_name;				/* just to identify the entry */
	GByteArray *incoming_data;
	GByteArray *outgoing_data;
	GIOChannel *channel;				/* communication channel */
	guint g_io_watch_id;				/* ID returned by g_io_add_watch (for read) for g_source_remove */
	guint g_io_watch_id_w;			/* ID returned by g_io_add_watch (for write) for g_source_remove */
} PROC_SERV_ENTRY;

/********************************************************************/
/* the communication between process uses a binary protocol         */
/* 2 bytes: size of packets (including this 2 bytes)                */
/* 2 bytes: command to do                                           */
/* 1 byte: number of parameter (=N)                                 */
/* everything after this is composed of N * the following structure */
/* 2 bytes: param size (=Kx)                                        */
/* Kx bytes: parameter                                              */
/********************************************************************/

/****************************************/
/* register a new entry with its socket */
/****************************************/
PROC_SERV_ENTRY *register_entry(int sock_fd, const char *service_name);


#endif
