/* dc_gui2 - a GTK+2 GUI for DCTC
 * Copyright (C) 2002 Eric Prevoteau
 *
 * flagged_user_clist.c: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: flagged_user_clist.c,v 1.7 2003/12/26 14:35:04 uid68112 Exp $
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <db.h>
#include <gnome.h>

#include "gtkcellrenderertextx.h"
#include "misc_gtk.h"
#include "flagged_user_clist.h"
#include "main.h"
#include "gui_define.h"
#include "macro.h"
#include "unode.h"
#include "init_fnc.h"
#include "bdb.h"
#include "global_user.h"

/* ---------------------------------------------------------------------------------------------------- */
static struct
			{
				const char *widget_name;
				const char *option_name;
				const char *autoflag_widget_name;
			} opt_list[]={
								{"user_flag_ignore_pmsg_togglebutton","IGNORE_PMSG","autoflag_user_flag_ignore_pmsg_togglebutton"},
								{"user_flag_ignore_pubmsg_togglebutton","IGNORE_PUBMSG","autoflag_user_flag_ignore_pubmsg_togglebutton"},
								{"user_flag_ignore_srch_togglebutton","IGNORE_SRCH","autoflag_user_flag_ignore_srch_togglebutton"},
								{"user_flag_ignore_sr_togglebutton","IGNORE_SREP","autoflag_user_flag_ignore_sr_togglebutton"},
								{"user_flag_no_xfer_togglebutton","IGNORE_XFER","autoflag_user_flag_no_xfer_togglebutton"},
								{"user_flag_ignore_dl_limit_togglebutton","IGNORE_SLOT_LIMIT","autoflag_user_flag_ignore_dl_limit_togglebutton"},
								{NULL,NULL}};

/**********************************************/
/* automatically flag the given user nickname */
/**********************************************/
void auto_flag_user(const char *nick)
{
	GtkTreeModel *gtm;
	GLOB_USER *gu;
	GtkWidget *w;

	w=get_widget_by_widget_name(main_window,"flagged_user_clist");
	if(w==NULL)
		return;
	gtm=gtk_tree_view_get_model(GTK_TREE_VIEW(w));

	gu=gu_get_user(nick);
	if(gu!=NULL)
	{
		/* the user exist but it may be reference elsewhere */
		GtkTreePath *gtp;

		gtp=gu_user_get_path_for_model(gu,gtm);
		if(gtp!=NULL)
		{
			/* the user is already flagged */
			GtkTreeSelection *slc;
			slc=gtk_tree_view_get_selection(GTK_TREE_VIEW(w));
			gtk_tree_selection_select_path(slc,gtp);
			gtk_tree_path_free(gtp);
		}
		else
			goto not_here;
	}
	else
	{
		int i;
		not_here:

		w=get_widget_by_widget_name(main_window,"flagged_user_label");
		if(w)
		{
			gtk_label_set(GTK_LABEL(w),nick);
		
			i=0;
			while(opt_list[i].widget_name!=NULL)
			{
				w=get_widget_by_widget_name(main_window,opt_list[i].widget_name);
				if(w!=NULL)
				{
					gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(w),
						gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(get_widget_by_widget_name(main_window,opt_list[i].autoflag_widget_name))));
				}
				i++;
			}
		}

		/* automatically flag the user ? */
		if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(get_widget_by_widget_name(main_window,"pchat_flag_auto_add_checkbutton")))==TRUE)
		{
			gtk_button_clicked(GTK_BUTTON(get_widget_by_widget_name(main_window,"add_modify_flag_user_button")));
		}
	}
		
	/* switch to flagged user tab ? */
	if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(get_widget_by_widget_name(main_window,"pchat_flag_switch_to_flag_tab_checkbutton")))==TRUE)
	{
		w=get_widget_by_widget_name(main_window,"main_notebook");
		gtk_notebook_set_page(GTK_NOTEBOOK(w),FLAGGED_USER_TAB);
	}
}
/* ---------------------------------------------------------------------------------------------------- */

/*****************************************/
/* reload the flagged user clist content */
/*****************************************/
void reload_flagged_user_clist(int only_if_empty)
{
	GtkWidget *w;
	w=get_widget_by_widget_name(main_window,"flagged_user_clist");
	if(w)
	{
		GtkListStore *gls;
		GtkTreeIter iter;
		GtkTreeModel *gtm;
		DBC *cursor;
		int ret;

		gls=GTK_LIST_STORE(gtm=gtk_tree_view_get_model(GTK_TREE_VIEW(w)));

		if((only_if_empty==1)&&gtk_tree_model_is_not_empty(gtm))
			return;

		gu_unref_model(gtm);
		gtk_list_store_clear(gls);

		ret=unwanted_user->cursor(unwanted_user,NULL,&cursor,0);
		if(ret==0)
		{
			DBT key;
			DBT data;
			char buf1[8192];
			char buf2[8192];

			memset(&key,0,sizeof(key));
			memset(&data,0,sizeof(data));

			key.data=buf1;
			key.ulen=sizeof(buf1)-1;
			key.flags=DB_DBT_USERMEM;

			data.data=buf2;
			data.ulen=sizeof(buf2)-1;
			data.flags=DB_DBT_USERMEM;

			ret=cursor->c_get(cursor,&key,&data,DB_FIRST);
			while(ret==0)
			{
				GLOB_USER *gu;

				buf1[key.size]='\0';
				buf2[data.size]='\0';
				
				/* get/create this user */
				gu=gu_add_user(buf1,TRUE,NULL);

				gtk_list_store_append(gls,&iter);
				gu_ref_from_iter(gu,gtm,&iter);

				gtk_list_store_set(gls,&iter, FUC_FLAGS_COL,buf2,
														FUC_USER_POINTER,gu,
														-1);

				ret=cursor->c_get(cursor,&key,&data,DB_NEXT);
			}

			/* end of scan, destroy the cursor */
			cursor->c_close(cursor);
		}
	}
}


/************************************************/
/* update user information using GLOB_USER data */
/************************************************/
static void flagged_user_clist_user_info_update_row(GtkTreeModel *gtm, GtkTreePath *gtp, GtkTreeIter *gti, gpointer user_data)
{
	GLOB_USER *gu;

	/* get GLOB_USER entry to use */
	gtk_tree_model_get(gtm,gti,FUC_USER_POINTER,&gu,-1);

	/* block the update signal on this function */
	g_signal_handlers_block_matched (G_OBJECT(gtm),G_SIGNAL_MATCH_FUNC,0,0,NULL,flagged_user_clist_user_info_update_row,NULL);

	/* update user info */
	gtk_list_store_set(GTK_LIST_STORE(gtm),gti,
												FUC_NICK_COL,gu->fmt_nick,
												FUC_BACKGROUND_COL,gu->back_present_color,
												FUC_FOREGROUND_COL,gu->front_color,
												-1);

	/* unblock the update signal on this function */
	g_signal_handlers_unblock_matched (G_OBJECT(gtm),G_SIGNAL_MATCH_FUNC,0,0,NULL,flagged_user_clist_user_info_update_row,NULL);
}
/****************************************************/
/* build modele and view for the flagged user clist */
/****************************************************/
void bmav4_flagged_user_clist(void)
{
	GtkListStore *model;
	GtkWidget *view;
	GtkCellRenderer *rend;
	GtkTreeSelection *slc;

	model=gtk_list_store_new(NB_FUC_COL,G_TYPE_STRING,G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_POINTER);
	g_signal_connect_after(G_OBJECT(model),"row-changed",G_CALLBACK(flagged_user_clist_user_info_update_row),NULL);

	view=get_widget_by_widget_name(main_window,"flagged_user_clist");

	gtk_tree_view_set_model(GTK_TREE_VIEW(view),GTK_TREE_MODEL(model));
	gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(view),TRUE);

	slc=gtk_tree_view_get_selection(GTK_TREE_VIEW(view));
	gtk_tree_selection_set_mode(slc,GTK_SELECTION_SINGLE);
	
	/* the first column of the view display the first column of the model, and so on. The 4th entry of the model is not displayed */
	rend=gtk_cell_renderer_textx_new();
	g_object_set(rend,"rowspacing",TRUE,NULL);
	MY_RS_gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view),FUC_NICK_COL,_("Nick"),rend,"text",FUC_NICK_COL,"background",FUC_BACKGROUND_COL,"foreground",FUC_FOREGROUND_COL,NULL);

	rend=gtk_cell_renderer_textx_new();
	g_object_set(rend,"rowspacing",TRUE,NULL);
	MY_RS_gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view),FUC_FLAGS_COL,_("Flags"),rend,"text",FUC_FLAGS_COL,"background",FUC_BACKGROUND_COL,"foreground",FUC_FOREGROUND_COL,NULL);

	/* The view now holds a reference.  We can get rid of our own
	 * reference */
	g_object_unref (G_OBJECT (model));
}

